---
generated_at: 2026-01-23 23:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-フッター編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editFooter.asp` - 画面定義ファイル（1-9行目）
- E-02: `asp/includes/customer.asp` - cls_customerクラス（11, 138, 322, 383行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング情報（126行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bSetupPageElements権限が必要 | E-01 (4行目: logon.hasaccess secondAdmin.bSetupPageElements) | ○ |
| C-02 | btnaction="save"で保存処理実行 | E-01 (4行目: if request("btnaction")=l("save") then) | ○ |
| C-03 | CSRF検証実行 | E-01 (5行目: checkCSRF()) | ○ |
| C-04 | convertStr()でフォーム値を変換 | E-01 (6行目: convertStr(Request.Form("sFooter"))) | ○ |
| C-05 | customer.sFooterに値を設定 | E-01 (6行目: customer.sFooter=...) | ○ |
| C-06 | customer.save()で保存 | E-01 (7行目: if customer.save then) | ○ |
| C-07 | 保存成功時fb_saveOKメッセージ追加 | E-01 (7行目: message.Add("fb_saveOK")) | ○ |
| C-08 | FCKEditorで編集（siteBuilderFooter設定） | E-01 (8行目: createFCKInstance customer.sFooter,"siteBuilderFooter","sFooter") | ○ |
| C-09 | テーブル幅640px | E-01 (8行目: width=640) | ○ |
| C-10 | sFooterはtblCustomerテーブルに保存 | E-02 (383行目: rs("sFooter") = sFooter) | ○ |
| C-11 | removeEmptyP()で空pタグ除去 | E-02 (322行目: sFooter=removeEmptyP(sFooter)) | ○ |
| C-12 | 機能No.22はフッター編集 | E-03 (126行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（シンプルな画面構成のため、すべての情報をソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 保存処理（ソースコードで確認済み）
- 0: 低リスク - CSRF検証（確認済み）
- 0: 低リスク - 権限チェック（確認済み）
- 0: 低リスク - HTMLサニタイズ（FCKEditor使用、XSSリスクは標準的）

## 6) レビュアーチェックリスト（最小）
- [ ] createFCKInstanceの"siteBuilderFooter"設定内容を確認
- [ ] フロントサイドでの[FOOTER]タグ置換処理を確認
- [ ] removeEmptyP関数の実装を確認
- [ ] HTMLコンテンツのXSSリスクを評価（管理者入力のため低リスク）
