---
generated_at: 2026-01-23 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：91-ヘッダー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **MYQS_urlSupport定数の定義場所**：根拠不足
  2. **QS_ASPX定数の詳細仕様**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_header.asp`（行4-544）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_header.aspはヘッダーメニュー構築のための共通インクルードファイル | E-01（行2-544の関数群） | ○ |
| C-02 | buildMenu関数でHTMLテーブル形式のメニューを構築 | E-01（行4-54） | ○ |
| C-03 | getMenuArray関数でメインメニュー配列を取得 | E-01（行59-188） | ○ |
| C-04 | getBSArtMenu関数でARTテーマ形式のメニューを生成 | E-01（行189-293） | ○ |
| C-05 | secondAdmin権限に基づくメニュー表示制御 | E-01（行70-176）, E-02（行17-75） | ○ |
| C-06 | Material Symbolsアイコンフォントを使用 | E-01（行20-42） | ○ |
| C-07 | メニュー配列は5要素構造 | E-01（行60-65）arrMenu(0-4,x) | ○ |
| C-08 | bs_default.aspへのホームリンク | E-01（行81-85） | ○ |
| C-09 | bs_FormList.aspへのフォームリンク | E-01（行93-98） | ○ |
| C-10 | bs_Intranet.aspへのイントラネットリンク | E-01（行100-106） | ○ |
| C-11 | bs_catalogList.aspへのカタログリンク | E-01（行107-113） | ○ |
| C-12 | bs_logoff.aspへのログオフリンク | E-01（行182-186） | ○ |
| C-13 | セッションにメニューHTMLをキャッシュ | E-01（行290-292） | ○ |
| C-14 | Cookie認証モードのサポート | E-01（行205-211） | ○ |
| C-15 | 関連機能としてバナーメニュー編集(No.20) | E-03（行127-128） | ○ |
| C-16 | getBOHeader関数は現在obsolete | E-01（行56-58） | ○ |
| C-17 | MYQS_urlSupportは外部ヘルプへのリンク | E-01（行62） | △ |
| C-18 | QS_ASPXフラグでギャラリー機能の表示制御 | E-01（行121） | △ |

## 4) 不足情報（Unknown / Missing）
- MYQS_urlSupport定数の定義場所が確認できない（config系ファイルと推定）
  - 候補：asp/config/web_config.asp / asp/includes/constants.asp / グローバル設定ファイル
- QS_ASPX定数の詳細定義（ASPXとASPの切り替え条件）
  - 候補：asp/begin.asp / asp/config/web_config.asp / Application変数

## 5) リスクフラグ（レビュー観点）
- 0: 画面説明の正確性（低リスク）
- 0: メニュー構造の説明（低リスク）
- 1: 外部リンク(MYQS_urlSupport)の具体的URL（中リスク - 環境依存の可能性）
- 0: 権限制御の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] メニュー項目一覧が実際のコードと一致しているか確認
- [ ] secondAdmin権限フラグの説明が完全か確認
- [ ] Material Symbolsアイコン名が正確か確認
- [ ] 遷移先URLが正しいか確認
