---
generated_at: 2026-01-23 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：92-バナーメニュー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **createFCKInstance関数の詳細仕様**：定義元ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editBannerMenu.asp`（行1-15）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `docs/code-to-docs/データベース設計書/データベース設計書.md`（tblCustomer）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_editBannerMenu.aspはバナーメニュー編集画面 | E-01, E-05（行93） | ○ |
| C-02 | sLeftBanner, sBannerMenu, sRightBannerを編集可能 | E-01（行6-8） | ○ |
| C-03 | checkCSRF()でCSRF検証を実施 | E-01（行5） | ○ |
| C-04 | removeEmptyP関数で空Pタグを除去 | E-01（行6-8） | ○ |
| C-05 | customer.save()でデータベースに保存 | E-01（行12） | ○ |
| C-06 | secondAdmin.bSetupPageElements権限が必要 | E-01（行4）, E-02 | ○ |
| C-07 | デフォルトテンプレート有無で表示が変化 | E-01（行13-14） | ○ |
| C-08 | sHighlights, sContactInfoはテキスト入力 | E-01（行14） | ○ |
| C-09 | bannerApplicationは条件付き編集 | E-01（行11, 13） | ○ |
| C-10 | tblCustomerのsLeftBannerカラムに保存 | E-03（行41） | ○ |
| C-11 | tblCustomerのsBannerMenuカラムに保存 | E-03（行111） | ○ |
| C-12 | fb_saveOKメッセージで保存成功を通知 | E-01（行12） | ○ |
| C-13 | QS_secCodeHiddenでCSRF対策 | E-01（行13） | ○ |
| C-14 | 関連機能はバナーメニュー編集(No.20) | E-04（行128） | ○ |
| C-15 | createFCKInstance関数でWYSIWYGエディタ生成 | E-01（行13-14）参照 | △ |

## 4) 不足情報（Unknown / Missing）
- createFCKInstance関数の定義元ファイルが未確認
  - 候補：asp/includes/fck.asp / asp/includes/editor.asp / 外部ライブラリ

## 5) リスクフラグ（レビュー観点）
- 0: 保存処理の説明（低リスク）
- 0: 入力項目の説明（低リスク）
- 1: WYSIWYGエディタの詳細仕様（中リスク - 外部ライブラリ依存）
- 0: 権限制御の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトテンプレート有無による表示切替が正確か確認
- [ ] tblCustomerの該当カラムのデータ型が正しいか確認
- [ ] FCKEditorの初期化処理が正しく機能するか確認
- [ ] CSRF対策が適切に実装されているか確認
