---
generated_at: 2026-01-23 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：93-矢印アップ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_arrowup.asp`（行1-57）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `asp/bs_header.asp`（行423-426のgetBOSetupMenuArr関数）
- E-04: `docs/code-to-docs/データベース設計書/データベース設計書.md`（tblCustomer）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_arrowup.aspはスクロールトップボタン設定画面 | E-01, E-05（行129） | ○ |
| C-02 | sArrowUPプロパティで矢印画像ファイル名を設定 | E-01（行9） | ○ |
| C-03 | postbackフラグでPOST処理を判定 | E-01（行5, 7） | ○ |
| C-04 | customer.save()でデータベースに保存 | E-01（行12） | ○ |
| C-05 | 保存成功時にfbMessage=fb_saveOKでリダイレクト | E-01（行13） | ○ |
| C-06 | FileSystemObjectで画像ファイル一覧を取得 | E-01（行36-38） | ○ |
| C-07 | fixedImages/arrowsフォルダから画像を取得 | E-01（行38） | ○ |
| C-08 | for each fileで各画像をループ処理 | E-01（行40） | ○ |
| C-09 | ラジオボタンで矢印を選択 | E-01（行28, 44） | ○ |
| C-10 | No arrowオプションで矢印非表示設定可能 | E-01（行27-29） | ○ |
| C-11 | tblCustomerのsArrowUPカラムに保存 | E-04（行108） | ○ |
| C-12 | C_DIRECTORY_QUICKERSITE定数でルートディレクトリ参照 | E-01（行38, 43） | ○ |
| C-13 | 関連機能はScroll To Top設定(No.36) | E-05（行129） | ○ |
| C-14 | セットアップメニューからアクセス可能 | E-03（行423-426） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 保存処理の説明（低リスク）
- 0: 画像一覧取得の説明（低リスク）
- 0: UI操作の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] fixedImages/arrowsフォルダが実際に存在し、画像が格納されているか確認
- [ ] customer.sArrowUPの値がフロントエンドで正しく参照されているか確認
- [ ] FileSystemObjectのセキュリティ設定が適切か確認
