---
generated_at: 2026-01-23 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：94-スクリプト一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_scriptList.asp`（行1-12）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `asp/bs_header.asp`（行531-535のgetHomeMenuArr関数）
- E-04: `docs/code-to-docs/データベース設計書/データベース設計書.md`（tblConstant）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_scriptList.aspはASP/VBScript一覧画面 | E-01, E-05（行130） | ○ |
| C-02 | secondAdmin.bHomeVBScript権限が必要 | E-01（行4）, E-02 | ○ |
| C-03 | customer.bApplication=falseでbs_constantList.aspにリダイレクト | E-01（行4） | ○ |
| C-04 | customer.constantsでスクリプト一覧を取得 | E-01（行6-7） | ○ |
| C-05 | iType=QS_VBScriptでフィルタリング | E-01（行9） | ○ |
| C-06 | sConstantにスクリプト名が格納される | E-01（行9）, E-04（行622） | ○ |
| C-07 | sParametersにパラメータ定義が格納される | E-01（行9）, E-04（行627） | ○ |
| C-08 | encrypt関数でIDを暗号化 | E-01（行9） | ○ |
| C-09 | sanitize関数でXSS対策 | E-01（行9） | ○ |
| C-10 | statusStringでオンライン/オフライン状態を表示 | E-01（行9） | ○ |
| C-11 | bs_constantEdit.aspへの遷移リンク | E-01（行5, 9） | ○ |
| C-12 | bs_constantlist.aspへの遷移リンク | E-01（行5） | ○ |
| C-13 | getArtLink関数でリンクを生成 | E-01（行4-5） | ○ |
| C-14 | 関連機能はスクリプト管理(No.96) | E-05（行130） | ○ |
| C-15 | ホームメニューからアクセス可能 | E-03（行531-535） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 一覧表示の説明（低リスク）
- 0: 権限制御の説明（低リスク）
- 0: 遷移先の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] QS_VBScript定数の値が正しく定義されているか確認
- [ ] customer.constantsプロパティが正しく機能するか確認
- [ ] encrypt/decrypt関数のペアが正しく動作するか確認
