---
generated_at: 2026-01-23 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-統計画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_stats.asp`（行1-18）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `asp/bs_process.asp`（行17-19）
- E-04: `asp/includes/search.asp`（行1-171）
- E-05: `docs/code-to-docs/データベース設計書/データベース設計書.md`（tblPage, tblCustomer）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_stats.aspはサイト統計画面 | E-01, E-06（行131-132） | ○ |
| C-02 | secondAdmin.bStats権限が必要 | E-01（行4）, E-02 | ○ |
| C-03 | cls_searchクラスでページ情報を取得 | E-01（行4-12）, E-04 | ○ |
| C-04 | orderby="iHits desc"でヒット数降順ソート | E-01（行7） | ○ |
| C-05 | includePasswordProtected=trueでパスワード保護ページも含める | E-01（行10） | ○ |
| C-06 | includeIntranet=trueでイントラネットページも含める | E-01（行11） | ○ |
| C-07 | tblPage.iHitsに総閲覧数が格納される | E-01（行17）, E-05（行224） | ○ |
| C-08 | tblPage.iHitsRSSにRSSフィード経由アクセス数が格納される | E-01（行15-17）, E-05（行239） | ○ |
| C-09 | tblPage.iVisitorsにユニーク訪問者数が格納される | E-01（行17）, E-05（行225） | ○ |
| C-10 | customer.aantalDagenで経過日数を取得 | E-01（行13-14） | ○ |
| C-11 | RSSフィード経由アクセス数はオレンジ色(#ffa500)で表示 | E-01（行14-17） | ○ |
| C-12 | btnaction=ResetStatsで統計リセット | E-01（行17）, E-03（行17-19） | ○ |
| C-13 | customer.resetStats()で統計をリセット | E-03（行19） | ○ |
| C-14 | customer.dResetStatsにリセット日時を記録 | E-01（行17）, E-05（行8） | ○ |
| C-15 | bs_referers.aspへのリンク（bScanreferer有効時） | E-01（行17） | ○ |
| C-16 | 関連機能はアクセス統計表示(No.91) | E-06（行131-132） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 統計表示の説明（低リスク）
- 0: リセット処理の説明（低リスク）
- 0: 権限制御の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_searchクラスの検索条件が適切か確認
- [ ] 統計リセット処理が正しく動作するか確認
- [ ] aantalDagen（経過日数）の計算ロジックが正しいか確認
- [ ] sortableテーブルのJavaScript機能が動作するか確認
