---
generated_at: 2026-01-23 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：96-リファラー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_referers.asp`（行1-84）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `asp/includes/logvisit.asp`（行1-63）
- E-04: `asp/includes/groupRefByList.asp`（行1-41）
- E-05: `docs/code-to-docs/データベース設計書/データベース設計書.md`（tblSession）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_referers.aspはリファラー一覧画面 | E-01, E-06（行133） | ○ |
| C-02 | secondAdmin.bStats権限が必要 | E-01（行4）, E-02 | ○ |
| C-03 | customer.bScanreferer=falseでbs_statsにリダイレクト | E-01（行24） | ○ |
| C-04 | cls_refGroupByListでグループ化条件を管理 | E-01（行32）, E-04 | ○ |
| C-05 | sb_ref_REFERER, sb_ref_URL等のグループ化定数 | E-04（行2-8） | ○ |
| C-06 | getReferersArr関数でリファラーデータを取得 | E-01（行38）, E-03（行46-62） | ○ |
| C-07 | tblSessionテーブルからデータを取得 | E-03（行49-50）, E-05（行28） | ○ |
| C-08 | dFrom, dUntillで期間指定 | E-01（行26-30）, E-03（行52-53） | ○ |
| C-09 | デフォルト期間は7日前〜本日 | E-01（行29-30） | ○ |
| C-10 | groupByに応じてkeyValueを設定 | E-01（行44-55） | ○ |
| C-11 | refDictで集計 | E-01（行72-78） | ○ |
| C-12 | pageAction=Resetでリファラーデータをリセット | E-01（行33-36） | ○ |
| C-13 | checkCSRF()でCSRF検証 | E-01（行34） | ○ |
| C-14 | removeReferers()でデータ削除 | E-01（行35）, E-03（行41-45） | ○ |
| C-15 | URLDecode2関数でデコード | E-01（行4-23） | ○ |
| C-16 | JQDatePicker関数で日付ピッカー生成 | E-01（行33） | ○ |
| C-17 | sortableクラスでソート機能 | E-01（行43, 80） | ○ |
| C-18 | 関連機能は参照元サイト一覧(No.92) | E-06（行133） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: リファラー取得の説明（低リスク）
- 0: グループ化処理の説明（低リスク）
- 0: リセット処理の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] tblSessionテーブルの構造が正しいか確認
- [ ] グループ化条件の定数値が正しいか確認
- [ ] 日付範囲のSQL条件が正しいか確認
- [ ] removeReferers関数が正しく動作するか確認
