---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-ショッピングカート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_shoppingcart.asp`（行1-46）
- E-02: `asp/bs_security.asp`（行1-79）
- E-03: `asp/includes/shopCategory.asp`（行1-145）
- E-04: `asp/includes/shopMake.asp`（行1-102）
- E-05: `asp/bs_shoppingcartmenu.asp`（行1-3）
- E-06: `docs/code-to-docs/データベース設計書/データベース設計書.md`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_shoppingcart.aspはショッピングカート管理画面 | E-01, E-07（行135） | ○ |
| C-02 | secondAdmin.bShoppingCart権限が必要 | E-01（行4）, E-02 | ○ |
| C-03 | cls_shopCategoryでカテゴリ情報を管理 | E-01（行5-6）, E-03 | ○ |
| C-04 | cls_shopMakeでメーカー情報を管理 | E-01（行7）, E-04 | ○ |
| C-05 | listメソッドで親カテゴリ一覧を取得 | E-01（行6）, E-03（行24-36） | ○ |
| C-06 | subcategories()で子カテゴリを取得 | E-01（行11）, E-03（行11-23） | ○ |
| C-07 | カテゴリは親子構造（iParentCatID） | E-03（行3, 14） | ○ |
| C-08 | tblQShopCategoryテーブルを参照 | E-03（行14, 27）, E-06（行35） | ○ |
| C-09 | tblQShopMakeテーブルを参照 | E-04（行13）, E-06（行33） | ○ |
| C-10 | allproductsプロパティで商品一覧を取得 | E-01（行29） | ○ |
| C-11 | encrypt関数でIDを暗号化 | E-01（行9, 14, 22, 31） | ○ |
| C-12 | sanitize関数でXSS対策 | E-01（行9, 22, 33） | ○ |
| C-13 | MYQS_offlineLinkColorでオフライン項目の色設定 | E-01（行10, 15, 23） | ○ |
| C-14 | bs_shoppingcartmenu.aspで共通メニュー | E-01（行4）, E-05 | ○ |
| C-15 | bs_shopAdCat.aspへの遷移リンク | E-01（行9, 14, 20） | ○ |
| C-16 | bs_shopMake.aspへの遷移リンク | E-01（行22, 25） | ○ |
| C-17 | bs_shopProduct.aspへの遷移リンク | E-01（行33, 39, 44） | ○ |
| C-18 | 関連機能はショッピングカート管理(No.77) | E-07（行135） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: カテゴリ一覧表示の説明（低リスク）
- 0: メーカー一覧表示の説明（低リスク）
- 0: 商品一覧表示の説明（低リスク）
- 0: 権限制御の説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_shopCategoryクラスの構造が正しいか確認
- [ ] cls_shopMakeクラスの構造が正しいか確認
- [ ] 商品一覧取得（allproducts）が正しく動作するか確認
- [ ] 各遷移先画面への暗号化IDパラメータが正しいか確認
