---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：99-カテゴリ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_shopAdCat.asp`（行1-22）
- E-02: `asp/includes/shopCategory.asp`（行1-145）
- E-03: `asp/bs_security.asp`（行1-79）
- E-04: `docs/code-to-docs/データベース設計書/データベース設計書.md`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_shopAdCat.aspはカテゴリ管理画面 | E-01, E-05（行136） | ○ |
| C-02 | secondAdmin.bShoppingCart権限が必要 | E-01（行4）, E-03 | ○ |
| C-03 | cls_shopCategoryでカテゴリ情報を管理 | E-01（行5）, E-02 | ○ |
| C-04 | pickメソッドでカテゴリデータを取得 | E-01（行6）, E-02（行37-52） | ○ |
| C-05 | sName, iParentCatID, bOnlineを設定可能 | E-01（行12-14）, E-02（行3） | ○ |
| C-06 | saveメソッドでデータを保存 | E-01（行15）, E-02（行61-90） | ○ |
| C-07 | deleteメソッドでデータを削除 | E-01（行17）, E-02（行91-95） | ○ |
| C-08 | 保存/削除後bs_shoppingcart.aspにリダイレクト | E-01（行15, 18） | ○ |
| C-09 | tblQShopCategoryテーブルを参照・更新 | E-02（行40, 72, 76）, E-04（行35） | ○ |
| C-10 | Checkメソッドでバリデーション | E-02（行53-60, 63） | ○ |
| C-11 | sNameが空の場合エラー | E-02（行55-58） | ○ |
| C-12 | iParentCatIDが0の場合nullに変換 | E-02（行69） | ○ |
| C-13 | 新規作成時dCreatedTSを設定 | E-02（行74） | ○ |
| C-14 | オフライン時に子カテゴリも連動してオフライン | E-02（行87-89） | ○ |
| C-15 | 削除時に子カテゴリのiParentCatIDをnullに更新 | E-02（行92） | ○ |
| C-16 | 削除時にtblQShopProdCatから紐付け削除 | E-02（行93） | ○ |
| C-17 | bShowParentCatDropDownで親カテゴリ選択の表示制御 | E-01（行20）, E-02（行96-105） | ○ |
| C-18 | bShowOnlineCBでオンラインチェックボックスの表示制御 | E-01（行21）, E-02（行106-119） | ○ |
| C-19 | showParentCatで親カテゴリ候補を生成 | E-01（行20）, E-02（行120-144） | ○ |
| C-20 | encrypt/decryptでIDを暗号化 | E-01（行6, 20） | ○ |
| C-21 | QS_secCodeHiddenでCSRF対策 | E-01（行20） | ○ |
| C-22 | sanitize関数でXSS対策 | E-01（行20） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: カテゴリCRUD処理の説明（低リスク）
- 0: 親子カテゴリの連動処理（低リスク）
- 0: 表示制御ロジックの説明（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_shopCategoryクラスのSaveメソッドが正しく動作するか確認
- [ ] 削除時の関連データ処理（子カテゴリ、商品紐付け）が正しいか確認
- [ ] bShowParentCatDropDown/bShowOnlineCBの表示条件が正しいか確認
- [ ] オフライン連動更新が期待通りに動作するか確認
