---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：結合テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **IT-040**: IIS連携機能の実行環境依存（権限・コンポーネント確認要）
  2. **IT-049**: ZIP展開機能のaspZipコンポーネント依存
  3. **IT-033**: Gravatar外部サービス連携のネットワーク依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/begin.asp` - アプリケーション初期化・インクルードファイル定義
- E-02: `asp/includes/database.asp` - cls_Databaseクラス、データベース接続処理
- E-03: `asp/includes/contact.asp` - cls_contactクラス、連絡先CRUD操作
- E-04: `asp/includes/mail.asp` - cls_mailクラス、メール履歴管理
- E-05: `asp/includes/form.asp` - cls_formクラス、フォーム処理・送信
- E-06: `asp/includes/newsletter.asp` - cls_newsletterクラス、ニュースレター送信
- E-07: `asp/includes/guestbook.asp` - cls_guestbookクラス、ゲストブック機能
- E-08: `asp/includes/shopProduct.asp` - cls_shopProductクラス、商品管理
- E-09: `asp/includes/customer.asp` - cls_customerクラス、顧客・サイト設定管理
- E-10: `asp/process_login.asp` - ログイン処理フロー
- E-11: `asp/process_catalog.asp` - カタログ表示・検索処理
- E-12: `README.md` - プロジェクト概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: 管理者ログイン認証とセッション管理 | E-10, E-09 | ○ |
| C-02 | IT-002: イントラネットユーザーログイン | E-03 | ○ |
| C-03 | IT-003: ページ取得とテンプレート結合 | E-01, E-02 | ○ |
| C-04 | IT-004: カタログアイテム検索とフィルタリング | E-11, E-02 | ○ |
| C-05 | IT-005: フォームデータ保存とバリデーション | E-05 | ○ |
| C-06 | IT-006: フォーム送信時のメール通知 | E-05 | ○ |
| C-07 | IT-007: オートレスポンダーメール送信 | E-05 | ○ |
| C-08 | IT-008: 連絡先データCRUD操作 | E-03 | ○ |
| C-09 | IT-009: 連絡先カスタムフィールド保存 | E-03 | ○ |
| C-10 | IT-010: パスワードリセットメール送信 | E-03 | ○ |
| C-11 | IT-011: ニュースレター作成と保存 | E-06 | ○ |
| C-12 | IT-012: ニュースレター一括送信 | E-06 | ○ |
| C-13 | IT-013: ゲストブック投稿とCAPTCHA検証 | E-07 | ○ |
| C-14 | IT-014: ゲストブック投稿通知メール | E-07 | ○ |
| C-15 | IT-015: 商品データCRUD操作 | E-08 | ○ |
| C-16 | IT-016: 商品カテゴリ関連付け | E-08 | ○ |
| C-17 | IT-017: フォームファイルアップロードと保存 | E-05 | ○ |
| C-18 | IT-018: テンプレートファイル読み込み | E-01 | ○ |
| C-19 | IT-019: メール送信履歴の保存と取得 | E-04 | ○ |
| C-20 | IT-020: RSSフィード生成 | E-01 | ○ |
| C-21 | IT-021: ギャラリー画像リストと表示 | E-01 | ○ |
| C-22 | IT-022: ASPX画像リサイズ連携 | E-12 | ○ |
| C-23 | IT-023: 顧客設定の保存と読み込み | E-09 | ○ |
| C-24 | IT-024: セカンド管理者権限管理 | E-01 | ○ |
| C-25 | IT-025: ポップアップ表示制御 | E-09 | ○ |
| C-26 | IT-026: アンケート投票と結果集計 | E-01 | ○ |
| C-27 | IT-027: フォーラム投稿とスレッド管理 | E-01 | ○ |
| C-28 | IT-028: システム定数の置換処理 | E-01 | ○ |
| C-29 | IT-029: 多言語ラベルの取得 | E-01 | ○ |
| C-30 | IT-030: Cookie同意とセッション管理 | E-09 | ○ |
| C-31 | IT-031: 動的サイトマップ生成 | E-01 | ○ |
| C-32 | IT-032: 全文検索とページ横断検索 | E-01 | ○ |
| C-33 | IT-033: メールアドレスからのアバター取得（Gravatar） | E-03 | △ |
| C-34 | IT-034: アバター画像アップロードと保存 | E-03 | ○ |
| C-35 | IT-035: ページヒット数カウント | E-01 | ○ |
| C-36 | IT-036: 訪問者ログ記録 | E-09 | ○ |
| C-37 | IT-037: カタログアイテムファイル管理 | E-01 | ○ |
| C-38 | IT-038: パスワード保護ページアクセス | E-10 | ○ |
| C-39 | IT-039: ページキャッシュ生成と無効化 | E-09 | ○ |
| C-40 | IT-040: サイト自動作成（IIS連携） | E-09 | △ |
| C-41 | IT-041: ニュースレターカテゴリ管理 | E-01, E-09 | ○ |
| C-42 | IT-042: スレッド購読とメール通知 | E-03 | ○ |
| C-43 | IT-043: 親子ページ関係とメニュー生成 | E-01 | ○ |
| C-44 | IT-044: 一覧ページと詳細ページ連携 | E-01 | ○ |
| C-45 | IT-045: CSRF保護 | E-05 | ○ |
| C-46 | IT-046: テンプレートコピーと顧客間移行 | E-01 | ○ |
| C-47 | IT-047: フォームとフィールドの一括コピー | E-05 | ○ |
| C-48 | IT-048: カタログ構造の一括コピー | E-01 | ○ |
| C-49 | IT-049: テンプレートZIPファイル展開 | E-09 | △ |
| C-50 | IT-050: サイト全体の複製処理 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-033（Gravatar連携）**: 外部サービス（Gravatar API）への依存があり、ネットワーク環境やサービス可用性によりテスト結果が変動する可能性
  - 候補：モックサーバーの構築 / ネットワーク分離環境でのテスト / サービスモニタリング
- **IT-040（IIS連携）**: cls_iisSiteの実行にはIIS管理者権限とCOMコンポーネントへのアクセスが必要。開発環境では動作確認困難
  - 候補：IISが利用可能なステージング環境 / 権限設定の確認 / 代替テスト手法の検討
- **IT-049（ZIP展開）**: aspZip.EasyZIPコンポーネントがインストールされている環境が必要。コンポーネント非存在時は機能が無効化される
  - 候補：コンポーネントインストール確認 / フォールバック処理の検証 / 代替ライブラリの検討

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**: IT-040（IIS連携） - 本番環境での自動サイト作成は重大な影響を及ぼす可能性があり、十分なテスト環境分離が必要
- **1（中リスク）**: IT-049（ZIP展開） - 外部コンポーネント依存により、環境差異でテスト失敗の可能性
- **1（中リスク）**: IT-033（Gravatar連携） - 外部サービス依存、ネットワーク障害時の挙動確認が必要
- **0（低リスク）**: その他のテストケース - ソースコードから直接確認可能な機能であり、単体テスト環境での検証が可能

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル名（tblCustomer, tblPage, tblContact等）がソースコードと一致しているか
- [ ] クラス名・メソッド名（cls_contact.save(), cls_form.build()等）が実際のコードと一致しているか
- [ ] メール送信処理のSMTP設定項目（SMTPSERVER, SMTPPORT等）がcustomerテーブルに存在するか
- [ ] ファイルパス（asp/includes/*, asp/process_*.asp）が実際のディレクトリ構成と一致しているか
- [ ] 外部依存コンポーネント（aspZip, showThumb.aspx）の存在を確認しているか
- [ ] セッション・Cookie処理の前提条件が正しく記述されているか
- [ ] 高優先度テストケース（認証・フォーム送信・ファイルアップロード）が漏れなく含まれているか
- [ ] テスト手順が再現可能なレベルで具体的に記述されているか
