---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての通知機能に対してソースコードからの根拠が確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/mail_message.asp` - メール送信コアクラス（cls_mail_message）
- E-02: `asp/includes/mail.asp` - メール管理クラス（cls_mail）
- E-03: `asp/includes/newsletter.asp` - ニュースレタークラス（cls_newsletter）
- E-04: `asp/includes/newsletterMailing.asp` - ニュースレター配信クラス（cls_newsletterMailing）
- E-05: `asp/bs_newsletterMailingSend.asp` - ニュースレター一斉配信画面
- E-06: `asp/process_unsubscribe.asp` - 購読解除処理
- E-07: `asp/includes/form.asp` - フォームクラス（cls_form）
- E-08: `asp/includes/contact.asp` - コンタクトクラス（cls_contact）
- E-09: `asp/process_forgotPW.asp` - パスワードリセット処理
- E-10: `asp/includes/ticket.asp` - 登録チケットクラス（cls_ticket）
- E-11: `asp/process_register.asp` - ユーザー登録処理
- E-12: `asp/bs_massMailing2.asp` - 一斉メール配信
- E-13: `mailPage.asp` - ページ共有メール
- E-14: `asp/fs_mailcontact.asp` - プライベートメッセージ
- E-15: `asp/includes/post.asp` - フォーラム投稿クラス（cls_post）
- E-16: `asp/includes/customerIntranetMessage.asp` - ステータス変更メッセージ
- E-17: `asp/includes/LogonEdit.asp` - ログイン管理クラス（cls_LogonEdit）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター配信機能が存在する | E-03, E-04, E-05 | ○ |
| C-02 | ニュースレター購読解除通知機能が存在する | E-06 | ○ |
| C-03 | フォーム送信通知機能が存在する（bSendEmail） | E-07 | ○ |
| C-04 | フォーム自動返信機能が存在する（bAutoResponder） | E-07 | ○ |
| C-05 | パスワードリセット通知機能が存在する | E-08, E-09 | ○ |
| C-06 | アカウント登録チケット送信機能が存在する | E-10, E-11 | ○ |
| C-07 | コンタクト一斉メール配信機能が存在する | E-12 | ○ |
| C-08 | ページ共有メール機能が存在する | E-13 | ○ |
| C-09 | プライベートメッセージ送信機能が存在する | E-14 | ○ |
| C-10 | フォーラム投稿通知（テーマ購読者向け）が存在する | E-15 | ○ |
| C-11 | フォーラム投稿通知（トピック購読者向け）が存在する | E-15 | ○ |
| C-12 | フォーラムモデレーター通知機能が存在する | E-15 | ○ |
| C-13 | ユーザーステータス変更通知機能が存在する | E-08, E-16 | ○ |
| C-14 | 管理者ログイン試行警告機能が存在する | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- 本プロジェクトはメール通知のみを実装しており、SMS通知やプッシュ通知は実装されていません
- メール送信コンポーネントは複数対応（Persits.MailSender, CDO.Message, CDONTS.NewMail, JMail.Message, SMTPsvg.Mailer）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての通知機能がソースコードから直接確認できる
- 注意点：
  - SMTP設定はweb_config.aspまたはカスタマー設定に依存
  - メール送信エラー時のリトライ機能は確認できず（On Error Resume Next で握りつぶし）
  - 一斉配信時のレートリミット設定はユーザー指定（iInterval, iForceReload）

## 6) レビュアーチェックリスト（最小）
- [ ] 各通知の送信先（To）が正しく設定されているか確認
- [ ] メールテンプレートの置換変数（[NL_NAME], [QS_FORM:xxx]等）が適切に定義されているか確認
- [ ] セキュリティ上の問題（メールヘッダインジェクション等）がないか確認
- [ ] 一斉配信時のパフォーマンス・負荷を考慮しているか確認
