# 通知設計書 13-ユーザーステータス変更通知

## 概要

本ドキュメントは、QuickerSite CMSにおける「ユーザーステータス変更通知」機能の通知設計について記述する。Intranetユーザー（コンタクト）のステータスが変更された際に、該当ユーザーに対してカスタマイズ可能なメッセージを含むメール通知を自動送信する機能である。

### 本通知の処理概要

**業務上の目的・背景**：Intranetシステムにおいて、ユーザーの権限レベル（ステータス）が変更された際に、対象ユーザーに適切な通知を行うことが目的である。例えば、アカウントの承認、権限の昇格/降格、アカウントの一時停止などの状態変更をユーザーに通知することで、サイト利用に関する混乱を防ぎ、円滑なコミュニケーションを実現する。

**通知の送信タイミング**：管理者がコンタクト情報を保存（`contact.Save`関数）し、ステータスが変更された場合に送信される。ただし、`cs_silent`（サイレント）ステータスへの変更時は通知されない。

**通知の受信者**：ステータスが変更されたコンタクト本人のメールアドレス（`contact.sEmail`）に送信される。

**通知内容の概要**：ステータスごとにカスタマイズされた件名と本文が送信される。件名と本文は`tblCustomerIntranetMessage`テーブルで管理され、ステータスレベルごとに異なるメッセージを設定可能。

**期待されるアクション**：受信者は通知メールを確認し、自身のアカウント状態の変更を認識する。新たに付与された権限でサイトにアクセスするか、制限された場合はその理由を理解することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無（`On Error Resume Next`によりエラーは無視される） |

### 送信先決定ロジック

1. `contact.Save`関数内でステータスの変更を検知（`copyStatus <> iStatus`）
2. 新しいステータスが`cs_silent`でないことを確認
3. 該当ステータスの`tblCustomerIntranetMessage`設定を取得
4. 設定が有効（`bEnabled = True`）かつ本文が空でない場合に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `customer.webmasterEmail`（顧客設定のウェブマスターメール） |
| 送信元名称 | `customer.siteName`（サイト名） |
| 件名 | `tblCustomerIntranetMessage.sSubject`（ステータス別カスタム件名） |
| 形式 | HTML |

### 本文テンプレート

ステータスごとに`tblCustomerIntranetMessage`テーブルで管理されるカスタムテンプレート:

```
{tblCustomerIntranetMessage.sBody}
```

デフォルトでは空であり、管理者が各ステータスに対してカスタマイズする。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | テンプレート変数は定義されていない |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作（管理画面） | コンタクト保存（`cls_contact.Save`関数） | `copyStatus <> iStatus` AND `iStatus <> cs_silent` | コンタクトのステータスが変更された時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `copyStatus = iStatus` | ステータスに変更がない場合 |
| `iStatus = cs_silent` | 新しいステータスがサイレントの場合 |
| `iMess.bEnabled = False` | 該当ステータスの通知が無効化されている場合 |
| `isLeeg(iMess.sBody)` | 該当ステータスの通知本文が未設定の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンタクト保存] --> B{ステータス変更あり?}
    B -->|No| Z[終了]
    B -->|Yes| C{iStatus<>cs_silent?}
    C -->|No| Z
    C -->|Yes| D[iMess設定取得]
    D --> E{bEnabled?}
    E -->|No| Z
    E -->|Yes| F{sBodyあり?}
    F -->|No| Z
    F -->|Yes| G[メール作成]
    G --> H[件名・本文設定]
    H --> I[メール送信]
    I --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblContact | コンタクト情報の取得・保存 | ステータス値、メールアドレス |
| tblCustomerIntranetMessage | ステータス別通知設定の取得 | 件名、本文、有効フラグ |

### テーブル別参照項目詳細

#### tblContact

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| iStatus | 現在のステータス | コンタクトID指定 |
| sEmail | 通知送信先メールアドレス | コンタクトID指定 |

#### tblCustomerIntranetMessage

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| iStatus | ステータスレベル | `WHERE iCustomerID={顧客ID} AND iStatus={新ステータス}` |
| bEnabled | 通知有効フラグ | 同上 |
| sSubject | 通知メール件名 | 同上 |
| sBody | 通知メール本文 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| tblContact | UPDATE | ステータス更新（通知処理の前提） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | `On Error Resume Next`により無視して継続 |
| 設定未取得 | ステータスに対応する設定が存在しない | 通知処理がスキップされる |
| メールアドレス未設定 | `sEmail`が空 | 通知処理が実行されるが送信失敗 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限なし。ステータス変更が行われた時点で即座に送信される。

## セキュリティ考慮事項

- 通知メールにはパスワードなどの機密情報は含まれない
- ステータス変更は管理者権限が必要な操作である
- メール本文は管理者がカスタマイズするため、不適切な内容が設定されないよう注意が必要

## 備考

- ステータスレベルは以下の定数で定義される：
  - `cs_silent` (0): サイレント - 通知対象外
  - `cs_read` (1): 読み取り権限
  - `cs_write` (2): 書き込み権限
  - 等
- `copyStatus`は`cls_contact.Pick`関数でDBから読み込まれた時点のステータスを保持
- 管理画面の「Intranet Messages」設定で各ステータスに対する通知内容をカスタマイズ可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ステータス管理とメッセージ設定の構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラスのプロパティ（iStatus, copyStatus, sEmail等） |
| 1-2 | customerIntranetMessage.asp | `asp/includes/customerIntranetMessage.asp` | cls_customerImessクラス定義 |

**読解のコツ**: `copyStatus`はPick関数内（行64）で設定され、保存前の元のステータスを保持する。

#### Step 2: エントリーポイントを理解する

コンタクトの保存処理がステータス変更通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contact.asp | `asp/includes/contact.asp` | cls_contact.Save関数が通知処理のエントリーポイント |

**主要処理フロー**:
1. **行153-159**: Save関数の冒頭でチェック処理
2. **行161-182**: DBへのコンタクト情報保存
3. **行211-224**: ステータス変更通知の送信処理

#### Step 3: ステータス変更通知処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contact.asp | `asp/includes/contact.asp` | 行211-224のステータス変更通知ロジック |

**主要処理フロー**:
- **行211**: `if copyStatus<>iStatus and iStatus<>cs_silent then` - 送信条件チェック
- **行212-214**: cls_customerImessオブジェクト作成、ステータス別設定取得
- **行215**: `if iMess.bEnabled and not isLeeg(iMess.sBody) then` - 有効チェック
- **行216-222**: メール作成・送信

#### Step 4: メッセージ設定クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customerIntranetMessage.asp | `asp/includes/customerIntranetMessage.asp` | Pick関数とSave関数 |

**主要処理フロー**:
- **行10-23**: Pick関数でステータス別設定を取得
- **行27-48**: Save関数で設定を保存（管理画面から使用）

### プログラム呼び出し階層図

```
bs_contacts.asp [管理画面]
    │
    └─ cls_contact.getRequestValues()
           │
           └─ cls_contact.Save() [行153]
                  │
                  ├─ Check() [入力検証]
                  │
                  ├─ [DBへの保存処理 - 行161-182]
                  │
                  └─ [ステータス変更通知 - 行211-224]
                         │
                         ├─ 条件チェック (copyStatus<>iStatus)
                         │
                         ├─ cls_customerImess.Pick(iStatus)
                         │      └─ tblCustomerIntranetMessageから設定取得
                         │
                         └─ cls_mail_message.send()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

管理画面フォーム ─────▶ cls_contact.Save() ─────▶ tblContactへUPDATE
    │                      │
    │                      ▼
    │              copyStatus <> iStatus?
    │                      │
    │                      ▼
    │              cls_customerImess.Pick()
    │              [ステータス別設定取得]
    │                      │
    │                      ▼
    │              bEnabled AND sBody?
    │                      │
    │                      ▼
    └─────────────▶ cls_mail_message.send() ───▶ ユーザーへメール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| contact.asp | `asp/includes/contact.asp` | ソース | コンタクトクラス定義、ステータス変更通知の主要ロジック |
| customerIntranetMessage.asp | `asp/includes/customerIntranetMessage.asp` | ソース | ステータス別メッセージ設定クラス |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| bs_contacts.asp | `asp/bs_contacts.asp` | ソース | コンタクト管理画面（エントリーポイント） |
