# 通知設計書 14-管理者ログイン試行警告

## 概要

本ドキュメントは、QuickerSite CMSにおける「管理者ログイン試行警告」機能の通知設計について記述する。管理画面（Admin/Backsite）への不正ログイン試行が規定回数を超えた場合に、管理者宛にIPアドレス情報を含む警告メールを自動送信する機能である。

### 本通知の処理概要

**業務上の目的・背景**：CMSの管理画面はサイト全体のコンテンツや設定を管理する重要なセクションである。不正アクセスの試行を早期に検知し、管理者に警告することで、セキュリティインシデントの未然防止や迅速な対応を可能にする。ブルートフォース攻撃や不正アクセスの兆候を管理者に通知することが目的である。

**通知の送信タイミング**：管理画面（Admin/Backsite）へのログイン試行が規定回数（`QS_number_of_allowed_attempts_to_login`）を超えた時点で送信される。同一IPからの重複メール送信は`application("mailSent"&UserIP)`で制御される。

**通知の受信者**：システム設定の管理者メールアドレス（`C_ADMINEMAIL`）に送信される。

**通知内容の概要**：不正アクセス試行の警告メッセージ、試行者のIPアドレス、エラー詳細、訪問者情報（ブラウザ、リファラー等）が含まれる。

**期待されるアクション**：管理者は通知メールを確認し、IPアドレスをブロックする、セキュリティ設定を見直す、アクセスログを確認する等のセキュリティ対策を講じることが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（緊急） |
| リトライ | 無（エラー発生時も処理継続） |

### 送信先決定ロジック

1. ログイン試行回数が規定回数を超過したことを検知
2. 同一IPに対して既にメールを送信済みでないことを確認（`application("mailSent"&UserIP)<>"true"`）
3. `C_ADMINEMAIL`が設定されている場合に送信
4. メール送信後、`application("mailSent"&UserIP)="true"`をセット

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `customer.webmasterEmail`（顧客設定のウェブマスターメール） |
| 送信元名称 | `customer.siteName`（サイト名） |
| 件名 | `"Error op " & customer.siteName` |
| 形式 | HTML |

### 本文テンプレート

Admin画面への試行（`lockAdmin`関数）:
```html
<p>Someone has tried to get access to the ADMIN area more then {QS_number_of_allowed_attempts_to_login} times. His/Her IP is now blocked.</p>
<hr />
<p>Page Error:</p>
Error Number: {エラー番号}<br />
Error Description: {エラー説明}<br />
Error Source: {エラーソース}<br />
Session Variables: {セッション変数一覧}<br />
<hr />
<p>Visitor details:</p>
{訪問者詳細情報}
```

Backsite画面への試行（`lockBSAdmin`関数）:
```html
<p>Someone has tried to get access to the BACKSITE area more then {QS_number_of_allowed_attempts_to_login} times. His/Her IP is now blocked.</p>
<hr />
{エラー詳細}
<hr />
<p>Visitor details:</p>
{訪問者詳細情報}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| `{QS_number_of_allowed_attempts_to_login}` | 許可されたログイン試行回数 | 設定定数 | Yes |
| `{エラー番号}` | ASPエラー番号 | `err.number` | Yes |
| `{エラー説明}` | ASPエラー説明 | `err.Description` | Yes |
| `{訪問者詳細情報}` | IP、ブラウザ情報等 | `getVisitorDetails()` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | Admin画面ログイン失敗 | `adminLoginCount > QS_number_of_allowed_attempts_to_login - 1` | Admin画面への規定回数超過 |
| システムイベント | Backsite画面ログイン失敗 | `bsLoginCount > QS_number_of_allowed_attempts_to_login - 1` | Backsite画面への規定回数超過 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `C_ADMINEMAIL`が未設定 | 管理者メールアドレスが設定されていない場合 |
| `application("mailSent"&UserIP)="true"` | 同一IPに対して既にメール送信済みの場合 |
| `C_ADMINPASSWORD`が未設定 | Admin機能が無効化されている場合（Admin画面のみ） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ログイン試行] --> B{パスワード正しい?}
    B -->|Yes| C[ログイン成功]
    B -->|No| D[試行回数カウント]
    D --> E{規定回数超過?}
    E -->|No| F[エラー表示]
    E -->|Yes| G{メール送信済み?}
    G -->|Yes| H[IPブロック・エラー表示]
    G -->|No| I[警告メール送信]
    I --> J[送信済みフラグセット]
    J --> H
    C --> K[試行回数リセット]
    K --> L[終了]
    F --> L
    H --> M[処理中断]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ログイン試行回数はApplicationオブジェクトで管理 |

### アプリケーション変数

| 変数名 | 用途 | データ型 |
|--------|------|---------|
| `adminLoginCount&{UserIP}` | Admin画面のIPごとの試行回数 | Integer |
| `bsLoginCount&{UserIP}` | Backsite画面のIPごとの試行回数 | Integer |
| `mailSent&{UserIP}` | IPごとのメール送信済みフラグ | String ("true"/"") |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | DBを使用せず、Applicationオブジェクトで管理 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メール送信失敗 | SMTPサーバー接続エラー | エラーを無視して処理継続（IPブロックは実行） |
| 設定エラー | `C_ADMINEMAIL`未設定 | メール送信をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 同一IPあたり | 1通（フラグで制御） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限なし。ログイン試行超過が検知された時点で即座に送信される。

## セキュリティ考慮事項

- 攻撃者のIPアドレスがメール本文に含まれるため、セキュリティ対策に活用可能
- `C_ADMINPASSWORD`が未設定の場合、Admin画面自体が無効化される
- IPブロック後も`application`変数でフラグが保持されるため、アプリケーション再起動までブロック継続
- セッション変数がメールに含まれるため、機密情報の漏洩に注意が必要

## 備考

- `QS_number_of_allowed_attempts_to_login`はweb_config.aspで設定される定数
- Admin画面とBacksite画面で別々にカウントされる
- `lockAdmin`関数はAdmin画面（最上位管理者）へのアクセス、`lockBSAdmin`関数はBacksite画面（通常管理者）へのアクセスを監視
- ログイン成功時に試行回数はリセットされる（`application("adminLoginCount"&UserIP)=0`等）
- IPブロック後はエラーを発生させて処理を中断（`Response.End`）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログイン試行回数の管理方法とApplication変数の使用を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogonEdit.asp | `asp/includes/LogonEdit.asp` | cls_LogonEditクラスのプロパティとApplication変数の使用 |

**読解のコツ**: `application("adminLoginCount"&UserIP)`のようにIPアドレスをキーに含めてユーザーごとの試行回数を管理している。

#### Step 2: エントリーポイントを理解する

ログイン処理とロック判定がエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogonEdit.asp | `asp/includes/LogonEdit.asp` | logonAdmin関数、lockAdmin関数、lockBSAdmin関数 |

**主要処理フロー**:
1. **行55-66**: logonAdmin関数でパスワード検証
2. **行61-63**: パスワード不正時にlockAdmin呼び出し
3. **行68-85**: lockAdmin関数でログイン試行制限と通知処理
4. **行86-98**: lockBSAdmin関数でBacksite用の同様処理

#### Step 3: ログイン試行制限処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogonEdit.asp | `asp/includes/LogonEdit.asp` | lockAdmin関数（行68-85） |

**主要処理フロー**:
- **行69-73**: `C_ADMINPASSWORD`未設定時の処理
- **行74**: 試行回数の超過チェック
- **行75-80**: エラー発生と警告メール送信
- **行77-80**: 重複メール送信防止
- **行82-83**: エラー発生とIPブロック

#### Step 4: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | functions.asp | `asp/includes/functions.asp` | dumpError関数とErrorReport関数 |

**主要処理フロー**:
- **行497-515**: dumpError関数でエラー情報整形
- **行486-496**: ErrorReport関数でメール送信

### プログラム呼び出し階層図

```
bs_default.asp / admin画面
    │
    └─ cls_LogonEdit.Class_Initialize()
           │
           └─ logonAdmin() [行55]
                  │
                  ├─ パスワード検証
                  │
                  ├─ [成功時] 認証フラグセット、試行回数リセット
                  │
                  └─ [失敗時] lockAdmin() / lockBSAdmin() [行61]
                         │
                         ├─ 試行回数チェック
                         │
                         ├─ [超過時] Err.Raise()
                         │       │
                         │       └─ dumpError() [行79]
                         │              │
                         │              └─ ErrorReport() [行510]
                         │                     │
                         │                     └─ cls_mail_message.send()
                         │
                         └─ [超過時] Response.End
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ログインフォーム ─────▶ logonAdmin() ─────────▶ 認証結果
    │                      │
    │                      ▼
    │              パスワード検証失敗
    │                      │
    │                      ▼
    │              lockAdmin() / lockBSAdmin()
    │                      │
    │                      ▼
    │              application("adminLoginCount"&UserIP)
    │              試行回数カウント
    │                      │
    │                      ▼
    │              規定回数超過?
    │                      │
    │                      ▼
    │              Err.Raise() ─────────▶ エラー情報
    │                      │
    │                      ▼
    │              dumpError()
    │                      │
    │                      ▼
    └─────────────▶ ErrorReport() ───────▶ 管理者へ警告メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogonEdit.asp | `asp/includes/LogonEdit.asp` | ソース | ログイン管理クラス、ログイン試行制限の主要ロジック |
| functions.asp | `asp/includes/functions.asp` | ソース | dumpError、ErrorReport関数（エラー通知） |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| web_config.asp | `asp/config/web_config.asp` | 設定 | QS_number_of_allowed_attempts_to_login、C_ADMINEMAIL定義 |
