# 通知設計書 3-フォーム送信通知

## 概要

本ドキュメントは、QuickerSiteシステムにおけるフォーム送信通知機能の設計を記述する。Webフォームが送信された際に、設定された宛先（管理者等）にフォーム内容をメール送信する機能である。

### 本通知の処理概要

フォーム送信通知は、ウェブサイト訪問者がフォームを送信した際に、フォーム設定で指定された宛先（管理者やサポート担当者等）に対して、入力されたフォームデータをメールで送信する機能である。添付ファイル対応、送信者情報・サーバー情報の自動付加など、業務に必要な情報を網羅的に含める。

**業務上の目的・背景**：ウェブサイトの問い合わせフォーム、資料請求フォーム、アンケートフォーム等からの送信内容を、担当者が迅速に確認し対応するため。CRMやカスタマーサポート業務の起点となる重要な機能であり、顧客対応のスピードと品質に直結する。

**通知の送信タイミング**：訪問者がフォームの送信ボタンをクリックし、バリデーション（必須項目、メール形式、CAPTCHA、ファイルサイズ等）を通過した直後に送信される。フォームデータのデータベース保存と同時に、メール送信が実行される。

**通知の受信者**：フォーム設定（tblForm.sTo）に登録されたメールアドレス宛に送信される。改行区切りで複数の宛先を設定可能。送信者がメールフィールドに入力した場合、そのアドレスがFrom/Reply-Toとして使用される。

**通知内容の概要**：送信ID、送信日時、カタログ情報（該当時）、全フォームフィールドの入力値、添付ファイルURL/添付、訪問者詳細情報（IP、ブラウザ、リファラー等）、管理者向けカスタムメッセージ（sAutoResponseWebmaster）。

**期待されるアクション**：受信者（管理者・担当者）はフォーム内容を確認し、問い合わせへの回答、資料送付、営業フォローアップ等の適切なアクションを行う。必要に応じて社内システムへのデータ入力や案件管理を行う。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

1. フォーム設定（tblForm.sTo）から宛先メールアドレスリストを取得
2. 改行（vbcrlf）で分割して複数宛先に対応
3. 各宛先に対してCheckEmailSyntaxでメール形式を検証
4. 有効なメールアドレスにのみ送信
5. フォームフィールドでbUseForSending=trueのフィールド値がFrom/Reply-Toに設定される

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | bUseForSending=trueのフィールド値、またはシステムデフォルト |
| 送信元名称 | 同上 |
| 件名 | sSubject（[QS_FORM:フィールド名]による動的置換可能） |
| 形式 | HTML |

### 本文テンプレート

```html
[sAutoResponseWebmaster（管理者向けカスタムメッセージ）]<br />
ID: [送信ID]<br />
[日付]: [送信日時]<br /><br />

[カタログ情報（該当時のみ）]
[カタログ名]: [カタログ名]<br />
[アイテム名]: [アイテムタイトル]<br /><br />

[フィールド名1]: [入力値1]<br />
[フィールド名2]: [入力値2]<br />
...

<hr />
<p><b><u>Visitor & Server Data:</u></b></p>
[訪問者詳細情報]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| アップロードファイル | 任意 | bAttachFiles=true | フォームでアップロードされたファイル |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| [QS_FORM:フィールド名] | フォームフィールドの入力値 | upload.Form (encrypt(fFieldKey)) | No |
| [QS_FORM:SUBMISSIONID] | 送信ID | submission.iId | No |
| ID: [送信ID] | 送信識別番号 | submission.iId | Yes |
| [日付] | 送信日時 | formatTimeStamp(now()) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | フォーム送信ボタンクリック | bSendEmail=true、バリデーション通過 | form.asp内build関数で処理 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| bSendEmail=false | フォーム設定でメール送信が無効 |
| バリデーションエラー | 必須項目未入力、メール形式エラー、CAPTCHAエラー等 |
| sToが空または無効 | 宛先メールアドレスが設定されていない |
| ファイルサイズ超過 | iMaxFileSizeを超えるファイルがアップロードされた |
| 許可されていないファイル形式 | allowedFileTypesに含まれない拡張子 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[フォーム送信] --> B[CSRF検証]
    B --> C[フォームデータ取得]
    C --> D[CAPTCHAチェック]
    D -->|失敗| E[エラー表示]
    D -->|成功| F[フィールドバリデーション]
    F -->|失敗| E
    F -->|成功| G[ファイルバリデーション]
    G -->|失敗| E
    G -->|成功| H[Submissionレコード作成]
    H --> I[フィールド値保存]
    I --> J[スクリプト実行（該当時）]
    J --> K{bSendEmail=true?}
    K -->|No| L[フィードバック/リダイレクト]
    K -->|Yes| M[件名の変数置換]
    M --> N[本文作成]
    N --> O[添付ファイル準備]
    O --> P[宛先ループ]
    P --> Q[cls_mail_message作成]
    Q --> R[メール送信]
    R --> S{次の宛先?}
    S -->|Yes| P
    S -->|No| L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblForm | フォーム設定情報 | 宛先、件名、各種フラグ |
| tblFormField | フォームフィールド定義 | フィールド名、型、バリデーション設定 |
| tblCatalog | カタログ情報 | フォーム連携時 |
| tblItem | アイテム情報 | フォーム連携時 |

### テーブル別参照項目詳細

#### tblForm

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sTo | 送信先メールアドレス | 改行区切りで複数指定可能 |
| sSubject | メール件名 | 変数置換対応 |
| bSendEmail | メール送信フラグ | true時のみ送信 |
| bAttachFiles | 添付ファイルフラグ | true時にファイル添付 |
| bCaptcha | CAPTCHAフラグ | true時にCAPTCHA検証 |
| sAutoResponseWebmaster | 管理者向けカスタムメッセージ | 本文先頭に挿入 |

#### tblFormField

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sName | フィールド名 | 本文表示・変数置換 |
| sType | フィールド型 | 表示形式の決定 |
| bMandatory | 必須フラグ | バリデーション |
| bUseForSending | 送信元として使用 | From/Reply-To設定 |
| iMaxFileSize | 最大ファイルサイズ | ファイルバリデーション |
| sAllowedExtensions | 許可拡張子 | ファイルバリデーション |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| tblFormSubmission | INSERT | 送信レコード作成 |
| tblFormFieldValue | INSERT | フィールド値保存 |

#### tblFormSubmission

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | iFormID | フォームID | 送信元フォーム |
| INSERT | iItemID | アイテムID | カタログ連携時 |
| INSERT | dCreatedTS | now() | 送信日時 |

#### tblFormFieldValue

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | iFormFieldId | フィールドID | フォームフィールド参照 |
| INSERT | iSubmissionId | 送信ID | Submission参照 |
| INSERT | sValue | 入力値 | ファイルの場合はファイル名 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| CAPTCHAエラー | 画像認証の入力ミス | err_captchaエラー表示 |
| 必須項目未入力 | bMandatory=trueのフィールドが空 | err_mandatoryエラー表示 |
| メール形式エラー | 不正なメールアドレス形式 | err_emailエラー表示 |
| ファイルサイズ超過 | iMaxFileSizeを超過 | err_fileSizeエラー表示 |
| ファイル形式エラー | 許可されていない拡張子 | err_fileTypeエラー表示 |
| 送信失敗 | SMTPエラー等 | On Error Resume Nextで継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（フォーム送信に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

フォーム送信アクションに連動するため、24時間いつでも送信可能。

## セキュリティ考慮事項

- CSRF対策：QS_secCodeHiddenによるトークン検証（checkCSRF_Upload）
- CAPTCHA：bCaptcha=true時に画像認証を要求
- XSS対策：sanitize関数による入力値のサニタイズ
- ファイルアップロード：allowedFileTypesによる拡張子制限、ファイルサイズ制限
- ハニーポット：隠しフィールド「your message」によるボット対策
- SQLインジェクション対策：パラメータ化されたクエリ使用

## 備考

- フォームデータは送信後もtblFormSubmission、tblFormFieldValueに保存され、管理画面から参照可能
- sScriptUponSubmission設定により、送信後にカスタムスクリプトを実行可能
- アップロードされたファイルは一時フォルダに保存後、指定の場所に移動される
- 一時フォルダは処理完了後に自動削除される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォーム送信通知で使用されるクラスとデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスの構造（行2-60） |
| 1-2 | form.asp | `asp/includes/form.asp` | プロパティ定義とフラグ（行3-5） |

**読解のコツ**: bSendEmail、bAutoResponder、bAttachFilesなどのフラグがメール送信動作を制御する。

#### Step 2: エントリーポイントを理解する

フォーム送信処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form.asp | `asp/includes/form.asp` | build関数（行250-804）がメイン処理 |

**主要処理フロー**:
1. **行269-274**: CSRF検証とハニーポットチェック
2. **行285-295**: CAPTCHAバリデーション
3. **行296-373**: フィールドバリデーションループ
4. **行376-380**: Submission作成
5. **行441-517**: bSendEmail=true時のメール送信処理

#### Step 3: メール送信処理を理解する

管理者への通知メール送信の詳細。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp | `asp/includes/form.asp` | 行441-517のメール送信ブロック |

**主要処理フロー**:
- **行443-446**: 件名の変数置換（insertSubmissionID）
- **行452-456**: 本文ヘッダー作成（ID、日付）
- **行458-461**: カタログ情報追加（該当時）
- **行466-496**: フィールドループで本文構築
- **行497-515**: 宛先ループでメール送信

#### Step 4: 添付ファイル処理を理解する

ファイルアップロードと添付の処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | form.asp | `asp/includes/form.asp` | 行317-372のファイル処理 |
| 4-2 | form.asp | `asp/includes/form.asp` | 行447-449の添付ファイル準備 |
| 4-3 | form.asp | `asp/includes/form.asp` | 行501-503のattachments設定 |

### プログラム呼び出し階層図

```
default.asp / page.asp
    |
    +-- cls_form.build(action, align, buttonType, itemID)
           |
           +-- FreeASPUpload [ファイルアップロード処理]
           |
           +-- checkCSRF_Upload() [CSRF検証]
           |
           +-- Session("CAPTCHA")比較 [CAPTCHA検証]
           |
           +-- cls_submission.save() [送信レコード作成]
           |
           +-- insertSubmissionID() [変数置換]
           |
           +-- treatConstants() [定数展開]
           |
           +-- cls_mail_message
                  |
                  +-- attachments設定
                  |
                  +-- send() [メール送信]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザフォーム          form.asp build()
(POSTデータ)       ->     |
                          v
FreeASPUpload      ->     CSRF/CAPTCHA検証
(ファイル)                |
                          v
tblForm            ->     フィールドバリデーション
(フォーム設定)            |
                          v
tblFormField       ->     Submission作成
(フィールド定義)          |
                          v
                          フィールド値保存       ->    tblFormSubmission
                          |                            tblFormFieldValue
                          v
                          メール本文構築
                          |
                          v
                          添付ファイル準備
                          |
                          v
                          cls_mail_message.send() ->   管理者メールボックス
                          |                            (sTo宛)
                          v
                          フィードバック/リダイレクト -> ブラウザ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| form.asp | `asp/includes/form.asp` | ソース | フォームクラス・送信処理の実装 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| submission.asp | `asp/includes/submission.asp` | ソース | 送信レコードクラス |
| formField.asp | `asp/includes/formField.asp` | ソース | フォームフィールドクラス |
| freeaspupload.asp | `asp/includes/freeaspupload.asp` | ソース | ファイルアップロード処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
