# 通知設計書 4-フォーム自動返信

## 概要

本ドキュメントは、QuickerSiteシステムにおけるフォーム自動返信機能の設計を記述する。フォーム送信者に対して自動返信メールを送信する機能である。

### 本通知の処理概要

フォーム自動返信は、ウェブサイト訪問者がフォームを送信した際に、送信者のメールアドレスに対して自動返信メールを送信する機能である。件名・本文テンプレートはカスタマイズ可能で、フォームフィールドの動的置換にも対応している。送信確認や受付完了の連絡として利用される。

**業務上の目的・背景**：フォーム送信者に対して即座に受付確認を行い、顧客体験を向上させるため。問い合わせが正常に受け付けられたことを伝え、送信者の不安を解消する。また、案内事項や次のステップを伝えることで、スムーズな顧客対応を実現する。

**通知の送信タイミング**：訪問者がフォームの送信ボタンをクリックし、バリデーションを通過した直後に送信される。管理者への通知メール（フォーム送信通知）と同一トランザクション内で、順次処理される。

**通知の受信者**：フォームフィールドでbAutoResponder=trueに設定されたフィールド（通常はメールアドレスフィールド）に入力された値が送信先となる。複数のbAutoResponder=trueフィールドがある場合は、それぞれに送信される。

**通知内容の概要**：カスタマイズされた件名（sAutoResponseSubject）、カスタマイズされた本文（sAutoResponse）、オプションで送信内容のコピー（[QS_COPYSUBMISSION]）。フォームフィールド値による動的置換が可能。

**期待されるアクション**：送信者はメールを受け取り、問い合わせが正常に受け付けられたことを確認する。自動返信に含まれる案内に従い、必要なアクションを行う。メールが届かない場合は、入力したアドレスの誤りを疑い、再度送信を行う。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

1. フォーム設定（tblForm）でbAutoResponder=trueを確認
2. フォームフィールド（tblFormField）でbAutoResponder=trueのフィールドを特定
3. 該当フィールドに入力された値（メールアドレス）を送信先として使用
4. 入力値が空の場合は送信をスキップ

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | sAutoResponseFromEmail（デフォルト: customer.webmasterEmail） |
| 送信元名称 | sAutoResponseFromName（デフォルト: customer.sitename） |
| 件名 | sAutoResponseSubject（[QS_FORM:フィールド名]による動的置換可能） |
| 形式 | HTML |

### 本文テンプレート

```html
[sAutoResponse（カスタマイズされた自動返信本文）]

<!-- オプション: [QS_COPYSUBMISSION]が含まれている場合 -->
[送信内容のコピー]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 自動返信には添付ファイルを含まない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| [QS_FORM:フィールド名] | フォームフィールドの入力値 | upload.Form (encrypt(fFieldKey)) | No |
| [QS_FORM:SUBMISSIONID] | 送信ID | submission.iId | No |
| [QS_COPYSUBMISSION] | 送信内容のコピー | submission.sCopyValues | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | フォーム送信ボタンクリック | bAutoResponder=true、バリデーション通過 | form.asp内build関数で処理 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| bAutoResponder=false | フォーム設定で自動返信が無効 |
| バリデーションエラー | 必須項目未入力、メール形式エラー、CAPTCHAエラー等 |
| 自動返信先フィールドが空 | bAutoResponder=trueのフィールドに値がない |
| sAutoResponseが空 | 自動返信本文が設定されていない（check関数でエラー） |
| sAutoResponseSubjectが空 | 自動返信件名が設定されていない（check関数でエラー） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[フォーム送信完了] --> B{bAutoResponder=true?}
    B -->|No| C[終了]
    B -->|Yes| D[件名の変数置換]
    D --> E[本文の変数置換]
    E --> F[定数展開・URL自動リンク]
    F --> G[[QS_COPYSUBMISSION]置換]
    G --> H[フィールドループ開始]
    H --> I{bAutoResponder=true?}
    I -->|No| J[次のフィールドへ]
    I -->|Yes| K{フィールド値あり?}
    K -->|No| J
    K -->|Yes| L[cls_mail_message作成]
    L --> M[送信元設定]
    M --> N[宛先設定（フィールド値）]
    N --> O[件名・本文設定]
    O --> P[メール送信]
    P --> J
    J --> Q{次のフィールド?}
    Q -->|Yes| H
    Q -->|No| C
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblForm | フォーム設定情報 | 自動返信設定 |
| tblFormField | フォームフィールド定義 | bAutoResponderフラグ |

### テーブル別参照項目詳細

#### tblForm

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| bAutoResponder | 自動返信有効フラグ | true時のみ処理 |
| sAutoResponse | 自動返信本文テンプレート | 変数置換対応 |
| sAutoResponseSubject | 自動返信件名テンプレート | 変数置換対応 |
| sAutoResponseFromName | 送信元名 | デフォルト: customer.sitename |
| sAutoResponseFromEmail | 送信元メールアドレス | デフォルト: customer.webmasterEmail |

#### tblFormField

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| bAutoResponder | 自動返信対象フラグ | true時に送信先として使用 |
| sName | フィールド名 | 変数置換のキー |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 自動返信処理自体ではDBを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定エラー | sAutoResponseが空 | check関数でerr_mandatoryエラー（保存時） |
| 設定エラー | sAutoResponseSubjectが空 | check関数でerr_mandatoryエラー（保存時） |
| 設定エラー | sAutoResponseFromEmailが空 | check関数でerr_mandatoryエラー（保存時） |
| 設定エラー | sAutoResponseFromEmailが不正形式 | check関数でerr_emailエラー（保存時） |
| 送信失敗 | SMTPエラー等 | On Error Resume Nextで継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（フォーム送信に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

フォーム送信アクションに連動するため、24時間いつでも送信可能。

## セキュリティ考慮事項

- メールアドレス検証：bAutoResponder対象フィールドの入力値チェック（check関数での設定検証）
- XSS対策：sanitize関数による入力値のサニタイズ
- 定数展開：treatConstants関数による安全な展開
- スパム対策：CAPTCHA、ハニーポット（フォーム送信通知と共通）
- 個人情報：送信者のメールアドレスがログに残る可能性あり

## 備考

- bAutoResponder設定は管理画面のフォーム設定で行う
- フィールドレベルのbAutoResponderは、どのフィールドを送信先として使用するかを指定
- 複数のbAutoResponder=trueフィールドがある場合、それぞれに個別に送信される
- [QS_COPYSUBMISSION]を使用すると、送信内容のコピーを自動返信に含めることが可能
- 送信元のFromName、FromEmailは別途設定可能で、企業名やサポート窓口として表示できる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

自動返信で使用されるフォーム設定項目を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスのプロパティ定義（行3-5） |
| 1-2 | form.asp | `asp/includes/form.asp` | bAutoResponder関連プロパティ（行4） |

**読解のコツ**: sAutoResponse、sAutoResponseSubject、sAutoResponseFromName、sAutoResponseFromEmailが自動返信の設定項目。

#### Step 2: バリデーションを理解する

設定時のバリデーションロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form.asp | `asp/includes/form.asp` | check関数（行64-130）の自動返信関連チェック |

**主要処理フロー**:
1. **行82-104**: bAutoResponder=true時のバリデーション
2. **行83-86**: sAutoResponseが空チェック
3. **行87-90**: sAutoResponseSubjectが空チェック
4. **行91-94**: sAutoResponseFromNameが空チェック
5. **行95-103**: sAutoResponseFromEmailの形式チェック

#### Step 3: 送信処理を理解する

自動返信メール送信の詳細。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp | `asp/includes/form.asp` | build関数内の自動返信処理（行518-547） |

**主要処理フロー**:
- **行518**: bAutoResponder条件チェック
- **行519-522**: 件名・本文の変数置換（insertSubmissionID、LinkURLs、treatConstants）
- **行523-526**: フィールドごとの[QS_FORM:フィールド名]置換
- **行528-530**: [QS_COPYSUBMISSION]置換
- **行532-546**: bAutoResponderフィールドへの送信ループ

#### Step 4: 送信内容コピー機能を理解する

[QS_COPYSUBMISSION]の実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | form.asp | `asp/includes/form.asp` | 行528-530の置換処理 |
| 4-2 | submission.asp | `asp/includes/submission.asp` | sCopyValuesプロパティ |

### プログラム呼び出し階層図

```
cls_form.build(action, align, buttonType, itemID)
    |
    +-- [フォーム送信通知処理] (bSendEmail)
    |
    +-- bAutoResponder チェック
           |
           +-- insertSubmissionID() [送信ID置換]
           |
           +-- LinkURLs() [URL自動リンク]
           |
           +-- treatConstants() [定数展開]
           |
           +-- フィールドループ [変数置換]
           |
           +-- submission.sCopyValues [送信内容コピー]
           |
           +-- bAutoResponderフィールドループ
                  |
                  +-- cls_mail_message
                         |
                         +-- send() [自動返信送信]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

tblForm                   form.asp build()
(bAutoResponder=true)  -> |
                          v
sAutoResponseSubject   -> 変数置換処理
sAutoResponse             |
                          v
                          [QS_FORM:*]置換
                          |
                          v
                          [QS_COPYSUBMISSION]置換
                          |
tblFormField           -> v
(bAutoResponder=true)     フィールドループ
                          |
フォーム入力値         -> v
(メールアドレス)          cls_mail_message.send()  ->  送信者メールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| form.asp | `asp/includes/form.asp` | ソース | フォームクラス・自動返信処理の実装 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| submission.asp | `asp/includes/submission.asp` | ソース | 送信レコードクラス（sCopyValues） |
| formField.asp | `asp/includes/formField.asp` | ソース | フォームフィールドクラス（bAutoResponder） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
