# 通知設計書 5-パスワードリセット通知

## 概要

本ドキュメントは、QuickerSiteシステムにおけるパスワードリセット通知機能の設計を記述する。ユーザーがパスワードを忘れた際に、新しいパスワードをメールで送信するIntranetログイン用のパスワードリカバリー機能である。

### 本通知の処理概要

パスワードリセット通知は、Intranetユーザーがパスワードを忘れた場合に、新しいランダムパスワードを生成してユーザーのメールアドレスに送信する機能である。データベース上のパスワードも同時に更新され、ユーザーは新しいパスワードでログインできるようになる。

**業務上の目的・背景**：Intranetユーザーがパスワードを忘れた場合の自己解決手段を提供し、管理者の負担を軽減するため。ユーザーがログインできない状態を迅速に解消し、業務の継続性を確保する。セキュリティを維持しながら、利便性の高いパスワードリカバリーを実現する。

**通知の送信タイミング**：ユーザーがパスワード忘れフォーム（process_forgotPW.asp）でメールアドレスを入力し、CAPTCHAを正しく入力して送信ボタンをクリックした直後。メールアドレスがtblContactに登録されている場合のみ送信される。

**通知の受信者**：パスワードリセットを要求したユーザー本人。tblContact.sEmailに登録されているメールアドレスに送信される。メールアドレスが登録されていない場合はエラーメッセージが表示され、送信されない。

**通知内容の概要**：新しく生成されたパスワード、サイト名、オプションでカスタマイズされた本文テンプレート（customer.intranetPWEmail）。テンプレートには[QS_intranet:contactemail]と[QS_intranet:contactpassword]の置換変数が使用可能。

**期待されるアクション**：ユーザーは受信したメールに記載された新しいパスワードを使用してIntranetにログインする。ログイン後、セキュリティのためにパスワードを変更することが推奨される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

1. ユーザーがパスワード忘れフォームにメールアドレスを入力
2. CAPTCHA検証を実施
3. logon.resetPW関数で入力されたメールアドレスをtblContactから検索
4. 該当するユーザーが存在する場合、そのsEmailに送信
5. ユーザーが存在しない場合はerr_emailNotFoundエラーを表示

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システムデフォルト（customer.webmasterEmail） |
| 送信元名称 | システムデフォルト（customer.siteName） |
| 件名 | l("password") & " " & customer.siteName |
| 形式 | HTML |

### 本文テンプレート

```html
<!-- customer.intranetPWEmailに[QS_intranet:contactemail]が含まれる場合 -->
[カスタマイズされたテンプレート（定数展開後）]
<!-- [QS_intranet:contactemail]と[QS_intranet:contactpassword]が置換される -->

<!-- customer.intranetPWEmailに[QS_intranet:contactemail]が含まれない場合 -->
[カスタマイズされたテンプレート（定数展開後、URL自動リンク）]<br /><br />
Email: [ユーザーメールアドレス]<br /><br />
[l("password")]: [新しいパスワード]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | パスワードリセット通知には添付ファイルを含まない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| [QS_intranet:contactemail] | ユーザーのメールアドレス | tblContact.sEmail | No |
| [QS_intranet:contactpassword] | 新しく生成されたパスワード | GeneratePassWord() | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | パスワード忘れフォーム送信 | CAPTCHA正常、ユーザー存在 | process_forgotPW.asp |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CAPTCHAエラー | 画像認証が正しくない場合 |
| メールアドレス未登録 | 入力されたメールアドレスがtblContactに存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[パスワード忘れフォーム表示] --> B[メールアドレス入力]
    B --> C[CAPTCHA入力]
    C --> D[送信ボタンクリック]
    D --> E{CAPTCHA検証}
    E -->|失敗| F[err_captchaエラー表示]
    E -->|成功| G[logon.resetPW呼び出し]
    G --> H{メールアドレス検索}
    H -->|存在しない| I[err_emailNotFoundエラー表示]
    H -->|存在する| J[新パスワード生成]
    J --> K[DBパスワード更新]
    K --> L[cls_mail_message作成]
    L --> M[テンプレート置換]
    M --> N[メール送信]
    N --> O[ログイン画面へリダイレクト]
    O --> P[fb_emailFoundメッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblContact | ユーザー情報の取得 | sEmailでの検索 |

### テーブル別参照項目詳細

#### tblContact

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sEmail | ユーザーメールアドレス | 入力値と一致するレコード検索 |
| iId | ユーザーID | パスワード更新対象の特定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| tblContact | UPDATE | パスワードの更新 |

#### tblContact更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | sPw | GeneratePassWord() | 新しいランダムパスワード |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| CAPTCHAエラー | 画像認証の入力ミス | err_captchaエラー表示 |
| メール未登録エラー | 入力メールアドレスがDBに存在しない | err_emailNotFoundエラー表示 |
| 送信失敗 | SMTPエラー等 | On Error Resume Nextで継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（CAPTCHAで制御） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

パスワードリセット要求に連動するため、24時間いつでも送信可能。

## セキュリティ考慮事項

- CAPTCHA：ボットによる大量リセット攻撃の防止
- パスワード即時更新：リセット要求時にDBのパスワードが即座に更新される
- ランダムパスワード生成：GeneratePassWord関数による8文字のランダム文字列
- 旧パスワード無効化：新パスワード生成時に旧パスワードは使用不可になる
- メールアドレス存在確認：存在しないメールアドレスへの送信は行わない
- リダイレクト：処理完了後はログイン画面にリダイレクトされ、フォームの再送信を防止

## 備考

- パスワードはプレーンテキストでDBに保存される（sPwカラム）
- customer.intranetPWEmailでメール本文をカスタマイズ可能
- テンプレートに[QS_intranet:contactemail]が含まれるかどうかで処理分岐
- 成功時はfb_emailFoundフィードバックメッセージが表示される
- 処理はlogon.resetPW関数（contact.asp内のresetPWサブルーチン）で実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

パスワードリセット画面とフォーム処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process_forgotPW.asp | `asp/process_forgotPW.asp` | フォーム処理のエントリーポイント（行1-31） |

**主要処理フロー**:
1. **行2**: pageAction=cForgotPW条件チェック
2. **行3**: CAPTCHAセッション比較
3. **行5**: logon.resetPW呼び出し
4. **行6**: 成功時のリダイレクト
5. **行8**: 失敗時のエラー設定

#### Step 2: パスワードリセット処理を理解する

実際のパスワードリセットとメール送信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contact.asp | `asp/includes/contact.asp` | resetPWサブルーチン（行288-306） |

**主要処理フロー**:
- **行289**: GeneratePassWord()で新パスワード生成
- **行291**: tblContact.sPw更新
- **行293-305**: メール送信処理
- **行296-300**: テンプレート置換（[QS_intranet:contactemail]、[QS_intranet:contactpassword]）
- **行302**: 置換なしテンプレートの場合の本文構築

#### Step 3: メール送信を理解する

cls_mail_messageを使用した送信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mail_message.asp | `asp/includes/mail_message.asp` | メール送信クラス（行2-175） |

### プログラム呼び出し階層図

```
default.asp (pageAction=cForgotPW)
    |
    +-- process_forgotPW.asp
           |
           +-- Session("captcha")比較 [CAPTCHA検証]
           |
           +-- logon.resetPW(sEmail)
                  |
                  +-- cls_contact.resetPW [contact.asp内]
                         |
                         +-- GeneratePassWord() [新パスワード生成]
                         |
                         +-- db.execute() [DB更新]
                         |
                         +-- cls_mail_message
                                |
                                +-- treatConstants() [定数展開]
                                |
                                +-- LinkURLs() [URL自動リンク]
                                |
                                +-- send() [メール送信]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パスワード忘れフォーム    process_forgotPW.asp
(sEmail, captcha)   ->    |
                          v
Session("captcha")  ->    CAPTCHA検証
                          |
                          v
                          logon.resetPW(sEmail)
                          |
tblContact          <->   メールアドレス検索/パスワード更新
(sEmail, sPw)             |
                          v
customer.intranetPW  ->   テンプレート置換
Email                     |
                          v
                          cls_mail_message.send()  ->  ユーザーメールボックス
                          |
                          v
                          リダイレクト            ->  ログイン画面
                                                      (fb_emailFoundメッセージ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_forgotPW.asp | `asp/process_forgotPW.asp` | ソース | パスワード忘れフォーム・処理 |
| contact.asp | `asp/includes/contact.asp` | ソース | contactクラス・resetPWサブルーチン |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| logon.asp | `asp/includes/logon.asp` | ソース | ログオンクラス（resetPW呼び出し） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
