# 通知設計書 6-アカウント登録チケット送信

## 概要

本ドキュメントは、QuickerSiteシステムにおけるアカウント登録チケット送信機能の設計を記述する。新規ユーザー登録時にアクティベーションリンクを含むメールを送信し、ユーザーはリンクをクリックしてアカウントを有効化する機能である。

### 本通知の処理概要

アカウント登録チケット送信は、Intranetへの新規ユーザー登録フローにおいて、メールアドレスの所有権を確認するためのアクティベーションリンクを含むメールを送信する機能である。ユーザーはこのリンクをクリックすることで、プロフィール登録画面に進み、アカウントを有効化できる。

**業務上の目的・背景**：不正なメールアドレスでの登録を防止し、正当なユーザーのみがIntranetにアクセスできるようにするため。メールアドレスの所有権確認（オプトイン）により、スパムアカウントの作成を抑制し、セキュリティと信頼性を確保する。

**通知の送信タイミング**：ユーザーが新規登録フォーム（process_register.asp）でメールアドレスを入力し、CAPTCHAを正しく入力して送信ボタンをクリックした直後。メールアドレスの形式検証と重複チェックを通過した場合に送信される。

**通知の受信者**：新規登録を要求したユーザー本人。入力されたメールアドレスに送信される。既に同一メールアドレスでアクティベーション待ちまたは登録済みの場合は、エラーメッセージが表示され送信されない。

**通知内容の概要**：アクティベーションリンク（[QS_Intranet:ActivationLink]）を含むカスタマイズ可能な本文（customer.sMailTicket）。ユーザーはリンクをクリックしてプロフィール登録画面に進む。

**期待されるアクション**：ユーザーは受信したメール内のアクティベーションリンクをクリックし、プロフィール登録画面でニックネーム、パスワード等を設定してアカウントを有効化する。リンクは一度のみ有効。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

1. ユーザーが登録フォームにメールアドレスを入力
2. CAPTCHA検証を実施
3. メールアドレス形式チェック
4. 同一メールでのアクティベーション待ちチェック（tblContactRegistration）
5. 同一メールでの登録済みチェック（tblContact、iStatus > cs_silent）
6. 全てのチェックを通過した場合、入力されたメールアドレスに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システムデフォルト（customer.webmasterEmail） |
| 送信元名称 | システムデフォルト（customer.siteName） |
| 件名 | customer.sSubjectMailTicket（定数展開対応） |
| 形式 | HTML |

### 本文テンプレート

```html
[customer.sMailTicket（定数展開後）]

<!-- [QS_Intranet:ActivationLink]が以下のURLに置換される -->
https://[サイトURL]/default.asp?pageAction=[cProfile]&ac=[sTicket]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アクティベーションメールには添付ファイルを含まない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| [QS_Intranet:ActivationLink] | アクティベーションURL | activationlinkプロパティ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 新規登録フォーム送信 | CAPTCHA正常、重複なし、形式正常 | process_register.asp |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CAPTCHAエラー | 画像認証が正しくない場合 |
| メール形式エラー | 有効なメールアドレス形式でない場合 |
| アクティベーション待ち | 同一メールアドレスがtblContactRegistrationに存在（err_activationlink） |
| 登録済み | 同一メールアドレスがtblContactに存在（iStatus > cs_silent）（err_doubleemail） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[新規登録フォーム表示] --> B[メールアドレス入力]
    B --> C[CAPTCHA入力]
    C --> D[送信ボタンクリック]
    D --> E[CSRF検証]
    E --> F{メールアドレス形式チェック}
    F -->|不正| G[err_emailエラー表示]
    F -->|正常| H{CAPTCHA検証}
    H -->|失敗| I[err_captchaエラー表示]
    H -->|成功| J{アクティベーション待ちチェック}
    J -->|存在| K[err_activationlinkエラー表示]
    J -->|なし| L{登録済みチェック}
    L -->|存在| M[err_doubleemailエラー表示]
    L -->|なし| N[チケットレコード作成]
    N --> O[sTicket生成]
    O --> P[訪問者詳細記録]
    P --> Q[sendTicket呼び出し]
    Q --> R[cls_mail_message作成]
    R --> S[テンプレート置換]
    S --> T[メール送信]
    T --> U[ログイン画面へリダイレクト]
    U --> V[fb_activationlinkメッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblContactRegistration | アクティベーション待ちの重複チェック | sEmailで検索 |
| tblContact | 登録済みユーザーの重複チェック | sEmail、iStatusで検索 |

### テーブル別参照項目詳細

#### tblContactRegistration

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sEmail | アクティベーション待ちチェック | 入力値と一致 |

#### tblContact

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sEmail | 登録済みチェック | 入力値と一致、iStatus > cs_silent |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| tblContactRegistration | INSERT | アクティベーションチケット作成 |

#### tblContactRegistration

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | sEmail | 入力されたメールアドレス | 小文字に変換 |
| INSERT | sTicket | GeneratePassWord x 2 | 16文字のランダム文字列 |
| INSERT | sVisitorDetails | getVisitorDetails() | IP、ブラウザ等の情報 |
| INSERT | iCustomerID | cId | サイトID |
| INSERT | dCreatedTS | now() | 作成日時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メール形式エラー | 不正なメールアドレス形式 | err_emailエラー表示 |
| CAPTCHAエラー | 画像認証の入力ミス | err_captchaエラー表示 |
| アクティベーション待ち重複 | 同一メールがtblContactRegistrationに存在 | err_activationlinkエラー表示 |
| 登録済み重複 | 同一メールがtblContactに存在 | err_doubleemailエラー表示 |
| 送信失敗 | SMTPエラー等 | On Error Resume Nextで継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（CAPTCHAで制御） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

新規登録要求に連動するため、24時間いつでも送信可能。

## セキュリティ考慮事項

- CSRF対策：QS_secCodeHiddenによるトークン検証
- CAPTCHA：ボットによる大量登録攻撃の防止
- チケット生成：GeneratePassWord x 2 = 16文字のランダム文字列
- メールアドレス小文字変換：大文字小文字の違いによる重複登録防止
- 重複チェック：アクティベーション待ちと登録済みの両方をチェック
- 訪問者情報記録：不正登録の調査用にIP等を記録

## 備考

- チケットは一度使用されると無効になる
- customer.sMailTicketでメール本文をカスタマイズ可能
- customer.sSubjectMailTicketで件名をカスタマイズ可能
- customer.sExplTicketでフォーム説明文をカスタマイズ可能
- customer.sLabelRegisterで登録ボタンのラベルをカスタマイズ可能
- 成功時はfb_activationlinkフィードバックメッセージが表示される
- アクティベーションリンクはdefault.asp?pageAction=[cProfile]&ac=[sTicket]形式

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

新規登録画面とフォーム処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process_register.asp | `asp/process_register.asp` | フォーム処理のエントリーポイント（行1-31） |

**主要処理フロー**:
1. **行2**: pageAction=cRegister条件チェック
2. **行3**: CSRF検証
3. **行4-5**: ticketオブジェクト作成、sEmail設定
4. **行6**: saveAndSend()呼び出し
5. **行7**: 成功時のリダイレクト

#### Step 2: チケットクラスを理解する

チケット生成とメール送信のロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ticket.asp | `asp/includes/ticket.asp` | cls_ticketクラス（行2-119） |
| 2-2 | ticket.asp | `asp/includes/ticket.asp` | check関数（行35-70） |
| 2-3 | ticket.asp | `asp/includes/ticket.asp` | SaveAndSend関数（行72-99） |
| 2-4 | ticket.asp | `asp/includes/ticket.asp` | sendTicket関数（行107-115） |

**主要処理フロー（check関数）**:
- **行37-44**: メールアドレス形式チェック
- **行46-56**: CAPTCHAセッション検証
- **行58-64**: アクティベーション待ち重複チェック
- **行65-69**: 登録済み重複チェック

**主要処理フロー（SaveAndSend関数）**:
- **行73-78**: check()呼び出しとバリデーション
- **行79-93**: チケットレコード作成・保存
- **行88**: sTicket生成（GeneratePassWord x 2）
- **行96**: sendTicket()呼び出し

**主要処理フロー（sendTicket関数）**:
- **行108-110**: cls_mail_message作成
- **行111**: 件名設定（treatConstants）
- **行112**: 本文設定（[QS_Intranet:ActivationLink]置換）
- **行113**: send()呼び出し

#### Step 3: アクティベーションリンク生成を理解する

リンクURLの構築。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ticket.asp | `asp/includes/ticket.asp` | activationlinkプロパティ（行116-118） |

### プログラム呼び出し階層図

```
default.asp (pageAction=cRegister)
    |
    +-- process_register.asp
           |
           +-- checkCSRF() [CSRF検証]
           |
           +-- cls_ticket.sEmail設定
           |
           +-- cls_ticket.saveAndSend()
                  |
                  +-- check()
                  |      |
                  |      +-- CheckEmailSyntax() [形式チェック]
                  |      |
                  |      +-- Session("CAPTCHA")比較 [CAPTCHA検証]
                  |      |
                  |      +-- db.execute() [重複チェック x 2]
                  |
                  +-- db.GetDynamicRS [レコード作成]
                  |
                  +-- GeneratePassWord() x 2 [チケット生成]
                  |
                  +-- getVisitorDetails() [訪問者情報]
                  |
                  +-- sendTicket()
                         |
                         +-- cls_mail_message
                                |
                                +-- treatConstants() [定数展開]
                                |
                                +-- replace([QS_Intranet:ActivationLink]) [リンク置換]
                                |
                                +-- send() [メール送信]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

新規登録フォーム          process_register.asp
(sEmail, captcha)   ->    |
                          v
Session("captcha")  ->    CSRF/CAPTCHA検証
                          |
                          v
tblContactRegistration -> 重複チェック（アクティベーション待ち）
                          |
                          v
tblContact          ->    重複チェック（登録済み）
                          |
                          v
GeneratePassWord()  ->    チケット生成
                          |
                          v
getVisitorDetails() ->    訪問者情報記録
                          |
                          v
                          DB保存              ->    tblContactRegistration
                          |
customer.sMailTicket ->   テンプレート置換
                          |
                          v
                          cls_mail_message.send()  ->  ユーザーメールボックス
                          |
                          v
                          リダイレクト            ->  ログイン画面
                                                      (fb_activationlink)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_register.asp | `asp/process_register.asp` | ソース | 新規登録フォーム・処理 |
| ticket.asp | `asp/includes/ticket.asp` | ソース | チケットクラス・メール送信 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
