# 通知設計書 7-コンタクト一斉メール配信

## 概要

本ドキュメントは、QuickerSiteシステムにおけるコンタクト一斉メール配信機能の設計を記述する。管理画面から選択したコンタクト（Intranetユーザー）に対して一斉メールを送信する機能である。

### 本通知の処理概要

コンタクト一斉メール配信は、管理者がバックエンド画面（bs_massMailing2.asp）から選択した複数のコンタクト（登録ユーザー）に対して、カスタマイズしたメールを一斉送信する機能である。フィールド値の動的置換機能があり、パーソナライズされたメール配信が可能。CC送信にも対応している。

**業務上の目的・背景**：登録ユーザーへの一斉連絡（お知らせ、キャンペーン、メンテナンス通知等）を効率的に行うため。ニュースレターとは異なり、Intranetに登録されたユーザーを対象とし、より詳細なユーザー情報（カスタムフィールド）を活用したパーソナライズが可能。

**通知の送信タイミング**：管理者が管理画面で宛先コンタクトを選択し、件名・本文を入力して送信ボタンをクリックした際に、即座に一斉送信される。バッチ処理ではなく、選択された全コンタクトに順次送信される。

**通知の受信者**：管理画面でチェックボックス選択されたコンタクト（tblContact）。sEmailが有効なコンタクトのみが対象。同一メールアドレスへの重複送信は自動的に防止される。

**通知内容の概要**：管理者が入力した件名・本文。本文・件名にはコンタクトフィールドの動的置換（[フィールド名]形式）が可能。メールアドレス、パスワード、カスタムフィールドの値を埋め込める。

**期待されるアクション**：受信者はメール内容を確認し、必要なアクションを行う。管理者は送信完了後に配信件数を確認し、送信履歴を管理できる。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ループ処理） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

1. 管理者が管理画面でコンタクトをチェックボックス選択
2. 選択されたコンタクトID（iContactIDM）をカンマ区切りで受け取る
3. 各コンタクトのsEmailを取得
4. 重複メールアドレスはDictionaryオブジェクトで管理し除外
5. sEmailが空でないコンタクトにのみ送信
6. CC送信先（ccEmails）が設定されている場合は、各コンタクトへの送信後にCC送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システムデフォルト（customer.webmasterEmail） |
| 送信元名称 | システムデフォルト（customer.siteName） |
| 件名 | 管理者入力（hSubject）、動的置換対応 |
| 形式 | HTML |

### 本文テンプレート

```html
[管理者が入力した本文（hBody）]

<!-- 以下の置換変数が使用可能 -->
[[l("email")]] -> コンタクトのメールアドレス
[sPw] -> コンタクトのパスワード
[カスタムフィールド名] -> 該当フィールドの値
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 一斉メール配信には添付ファイルを含まない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| [[l("email")]] | コンタクトのメールアドレス | contact.sEmail | No |
| [sPw] | コンタクトのパスワード | contact.sPw | No |
| [カスタムフィールド名] | コンタクトフィールドの値 | contact.fields(field) | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 一斉メール送信ボタンクリック | コンタクト選択済み | bs_massMailing2.asp |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| sEmailが空 | メールアドレスが設定されていないコンタクトはスキップ |
| 重複メールアドレス | 同一メールアドレスへの二重送信を防止 |
| エラー発生 | On Error Resume Nextでスキップし次へ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[一斉メール画面表示] --> B[コンタクト選択]
    B --> C[件名・本文入力]
    C --> D[CC入力（オプション）]
    D --> E[送信ボタンクリック]
    E --> F[contactDict初期化]
    F --> G[コンタクトループ開始]
    G --> H[コンタクト情報取得]
    H --> I{sEmail有効?}
    I -->|No| J[次のコンタクトへ]
    I -->|Yes| K{重複チェック}
    K -->|重複| J
    K -->|新規| L[件名・本文の変数置換]
    L --> M[メール送信]
    M --> N[送信済みリスト追加]
    N --> O{CC設定あり?}
    O -->|Yes| P[CC送信ループ]
    O -->|No| J
    P --> J
    J --> Q{次のコンタクト?}
    Q -->|Yes| G
    Q -->|No| R[送信履歴保存]
    R --> S[完了画面へリダイレクト]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblContact | コンタクト情報の取得 | sEmail、sPw、fields |
| tblContactField | コンタクトフィールド定義 | フィールド名取得 |
| tblContactValues | コンタクトフィールド値 | フィールド値取得 |

### テーブル別参照項目詳細

#### tblContact

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sEmail | 送信先メールアドレス | 選択されたiId |
| sPw | パスワード（置換用） | 選択されたiId |
| fields | カスタムフィールド値 | fieldsプロパティ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| tblMail | INSERT | 送信履歴保存 |
| tblMailContact | INSERT | 送信先コンタクト記録 |

#### tblMail

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | sSubject | 件名 | mailobj.sSubject |
| INSERT | sBody | 本文 | mailobj.sBody |
| INSERT | sBodyBGColor | 背景色 | mailobj.sBodyBGColor |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | iMailID | メールID | mailobj.iId |
| INSERT | sEmail | 送信先メールアドレス | emailKey |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンタクト取得エラー | 無効なコンタクトID | On Error Resume Nextでスキップ |
| 送信失敗 | SMTPエラー等 | ErrorReportでログ記録、次へ継続 |
| 変数置換エラー | 無効なフィールド名等 | On Error Resume Nextで継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（同期処理） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

管理者が手動で実行するため、時間帯制限はシステム側では設定されていない。

## セキュリティ考慮事項

- 管理者認証：バックエンドアクセス権限が必要
- パスワード置換：[sPw]でパスワードをメールに含めることが可能（セキュリティリスク注意）
- 重複送信防止：Dictionaryオブジェクトによる重複排除
- エラーログ：ErrorReport関数でエラー内容を記録
- 送信履歴：tblMail、tblMailContactに履歴保存

## 備考

- スクリプトタイムアウトは10000秒に設定（大量送信対応）
- 送信完了後はbs_massMailingFB.aspにリダイレクトされ、送信件数が表示される
- CC送信先は複数指定可能（カンマ区切り）
- カスタムフィールドの日付型は専用の変換処理（convertDateToPicker）を使用
- 送信元（From/ReplyTo）は未設定のためシステムデフォルトが使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

一斉メール送信処理のメインファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 送信処理のメインロジック（行1-83） |

**主要処理フロー**:
1. **行7**: スクリプトタイムアウト設定
2. **行8-11**: 初期化（contactDict、theMail）
3. **行16-17**: CC・コンタクトID取得
4. **行20-63**: コンタクトループ処理
5. **行65-79**: 送信履歴保存
6. **行80**: 完了画面へリダイレクト

#### Step 2: 変数置換処理を理解する

コンタクトフィールドの動的置換。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 行26-41の置換処理 |

**主要処理フロー**:
- **行26-27**: 件名・本文の初期設定
- **行28-31**: メールアドレス、パスワードの置換
- **行32-40**: カスタムフィールドのループ置換
- **行33-39**: フィールドタイプ別の変換処理

#### Step 3: 送信・履歴保存を理解する

メール送信と履歴の永続化。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 行42-56の送信処理 |
| 3-2 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 行65-79の履歴保存 |

### プログラム呼び出し階層図

```
bs_massMailing.asp (フォーム画面)
    |
    +-- bs_massMailing2.asp (送信処理)
           |
           +-- cls_mail_message初期化
           |
           +-- コンタクトループ
           |      |
           |      +-- cls_contact.pick() [コンタクト取得]
           |      |
           |      +-- contactDict.Exists() [重複チェック]
           |      |
           |      +-- replace() [変数置換]
           |      |
           |      +-- theMail.send() [メール送信]
           |      |
           |      +-- CC送信ループ
           |
           +-- cls_mail.save() [送信履歴保存]
           |
           +-- tblMailContact INSERT [送信先記録]
           |
           +-- リダイレクト -> bs_massMailingFB.asp
```

### データフロー図

```
[入力]                    [処理]                         [出力]

管理画面フォーム          bs_massMailing2.asp
(hSubject, hBody,         |
 iContactIDM, ccEmails) ->|
                          v
                          コンタクトループ
                          |
tblContact           ->   コンタクト情報取得
(sEmail, sPw, fields)     |
                          v
tblContactField      ->   変数置換処理
(sFieldname)              |
                          v
                          重複チェック
                          |
                          v
                          cls_mail_message.send()  ->  コンタクトメールボックス
                          |
                          v
                          CC送信（オプション）    ->  CC宛先メールボックス
                          |
                          v
                          送信履歴保存           ->  tblMail, tblMailContact
                          |
                          v
                          リダイレクト           ->  完了画面
                                                     (送信件数表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_massMailing2.asp | `asp/bs_massMailing2.asp` | ソース | 一斉メール送信処理 |
| bs_massMailing.asp | `asp/bs_massMailing.asp` | ソース | 一斉メール入力フォーム |
| bs_massMailingFB.asp | `asp/bs_massMailingFB.asp` | ソース | 送信完了画面 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| contact.asp | `asp/includes/contact.asp` | ソース | コンタクトクラス定義 |
| mail.asp | `asp/includes/mail.asp` | ソース | メール履歴クラス定義 |
