# 通知設計書 8-ページ共有メール

## 概要

本ドキュメントは、QuickerSiteシステムにおけるページ共有メール機能の設計を記述する。Webページの内容をメールで共有する機能であり、CAPTCHAによるスパム対策を実装している。

### 本通知の処理概要

ページ共有メールは、ウェブサイトの訪問者が閲覧中のページ内容を他者にメールで共有できる機能である。訪問者が宛先メールアドレスを入力し、CAPTCHAを通過すると、現在表示中のページの内容がHTML形式のメールとして送信される。

**業務上の目的・背景**：ウェブサイトのコンテンツを訪問者間で簡単に共有できるようにし、バイラルマーケティング効果を促進するため。「友達に教える」「このページを共有」といった機能として、ユーザーエンゲージメントと情報拡散を支援する。

**通知の送信タイミング**：訪問者がページ共有フォーム（mailPage.asp）で宛先メールアドレスを入力し、CAPTCHAを正しく入力して送信ボタンをクリックした直後。バリデーションを通過した場合のみ送信される。

**通知の受信者**：訪問者が入力したメールアドレス宛に送信される。メールアドレスの形式チェックを実施し、不正な形式の場合はエラーメッセージを表示。入力されたメールアドレスはセッションに保存され、次回の入力を省略可能。

**通知内容の概要**：共有対象ページのタイトル、ページ本文（HTML形式）、サイトCSS適用。件名には「[ページタイトル] on [サイトURL]」形式が使用される。

**期待されるアクション**：受信者はメールを開封し、共有されたページ内容を確認する。興味があればサイトにアクセスして詳細を確認する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

1. 訪問者がフォームにメールアドレスを入力
2. CAPTCHA検証を実施
3. メールアドレス形式チェック（CheckEmailSyntax）
4. 全てのチェックを通過した場合、入力されたメールアドレスに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システムデフォルト（customer.webmasterEmail） |
| 送信元名称 | システムデフォルト（customer.siteName） |
| 件名 | "[ページタイトル] [l("on")] [customer.sUrl]" |
| 形式 | HTML |

### 本文テンプレート

```html
<!-- pagetoemailbodyが空の場合（デフォルト） -->
<html>
<head>
  <title>[ページタイトル]</title>
  [サイトCSS]
</head>
<body class="main">
  <table style="FONT-FAMILY:Arial;FONT-SIZE:10pt;" align="left" width="555">
    <tr>
      <td style="FONT-FAMILY:Arial;FONT-SIZE:10pt;">
        <b>[ページタイトル]</b>
        <hr />
        [ページ本文]
      </td>
    </tr>
  </table>
</body>
</html>

<!-- pagetoemailbodyが設定されている場合 -->
[pagetoemailbody（カスタムテンプレート）]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | ページ共有メールには添付ファイルを含まない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pageTitle | ページタイトル | selectedPage.showTitle / pageTitle変数 | Yes |
| pagebody | ページ本文 | pagebody変数 | Yes |
| css() | サイトCSS | css()関数 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ページ共有フォーム送信 | CAPTCHA正常、メール形式正常 | mailPage.asp |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CAPTCHAエラー | 画像認証が正しくない、または空の場合 |
| メール形式エラー | 有効なメールアドレス形式でない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ページ共有フォーム表示] --> B[メールアドレス入力]
    B --> C[CAPTCHA入力]
    C --> D[送信ボタンクリック]
    D --> E[CSRF検証]
    E --> F{CAPTCHA検証}
    F -->|失敗| G[err_captchaエラー表示]
    F -->|成功| H{メールアドレス形式チェック}
    H -->|不正| I[err_emailエラー表示]
    H -->|正常| J[メールアドレスをセッション保存]
    J --> K{pagetoemailbody設定?}
    K -->|あり| L[カスタムテンプレート使用]
    K -->|なし| M[デフォルトテンプレート構築]
    L --> N[本文のブロック置換]
    M --> N
    N --> O[cls_mail_message作成]
    O --> P[件名設定]
    P --> Q[メール送信]
    Q --> R[送信完了画面表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblPage | ページ情報の取得 | selectedPage経由 |

### テーブル別参照項目詳細

#### tblPage

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sTitle（showTitle） | ページタイトル | 件名・本文に使用 |
| sValue（pagebody） | ページ本文 | 本文に使用 |
| iId | ページID | ページ特定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ページ共有ではDBを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| CAPTCHAエラー | 画像認証の入力ミスまたは空 | err_captchaエラー表示 |
| メール形式エラー | 不正なメールアドレス形式 | err_emailエラー表示 |
| 送信失敗 | SMTPエラー等 | エラー処理なし（送信試行のみ） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（CAPTCHAで制御） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

ページ共有要求に連動するため、24時間いつでも送信可能。

## セキュリティ考慮事項

- CSRF対策：QS_secCodeHiddenによるトークン検証（checkCSRF）
- CAPTCHA：ボットによるスパム送信の防止
- メールアドレス検証：CheckEmailSyntax関数による形式チェック
- セッション保存：メールアドレスをセッション変数（QS_CMS_email）に保存し、次回入力を省略
- コンテンツ：ページ本文がそのまま送信されるため、機密情報を含むページの共有に注意

## 備考

- 送信完了後は「Page is sent」メッセージを表示
- ポップアップウィンドウとして表示される（window.close()で閉じる）
- pagetoemailbody変数でカスタムテンプレートを設定可能
- selectedPage.replaceBlocksでページ内のブロック要素が置換される
- sApplication（カスタムアプリケーション）が設定されているページはResponse.Endで処理中断
- trimEmail（trim関数）でメールアドレスの前後の空白を除去

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

ページ共有フォームと送信処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mailPage.asp | `mailPage.asp` | フォーム表示と送信処理（行1-52） |

**主要処理フロー**:
1. **行17**: btnAction="sendPage"条件チェック
2. **行18**: メールアドレス取得（trim処理）
3. **行19**: CSRF検証
4. **行20**: セッションにメールアドレス保存
5. **行22-24**: CAPTCHA検証
6. **行25-27**: メールアドレス形式チェック
7. **行29-48**: メール送信処理

#### Step 2: 本文構築を理解する

ページ内容のメール本文への変換。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mailPage.asp | `mailPage.asp` | 行29-41の本文構築処理 |

**主要処理フロー**:
- **行30**: pagetoemailbody空チェック
- **行32-33**: HTMLヘッダー構築（タイトル、CSS）
- **行35**: ページタイトルとページ本文の結合
- **行37**: HTMLフッター構築
- **行38**: ヘッダー、本文、フッターの結合
- **行40**: カスタムテンプレート使用時

#### Step 3: メール送信を理解する

cls_mail_messageを使用した送信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mailPage.asp | `mailPage.asp` | 行42-49のメール送信処理 |

**主要処理フロー**:
- **行43**: cls_mail_message作成
- **行44**: 宛先設定
- **行45**: 件名設定（replaceBlocks適用）
- **行46**: 本文設定（replaceBlocks適用）
- **行47**: send()呼び出し
- **行49**: mailSent=trueフラグ設定

### プログラム呼び出し階層図

```
mailPage.asp
    |
    +-- begin.asp [共通初期化]
    |
    +-- process.asp [ページ処理]
    |
    +-- checkCSRF() [CSRF検証]
    |
    +-- Session("CAPTCHA")比較 [CAPTCHA検証]
    |
    +-- CheckEmailSyntax() [メール形式チェック]
    |
    +-- 本文構築
    |      |
    |      +-- css() [サイトCSS取得]
    |      |
    |      +-- pageTitle/pagebody [ページ内容]
    |
    +-- cls_mail_message
           |
           +-- selectedPage.replaceBlocks() [ブロック置換]
           |
           +-- send() [メール送信]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ページ共有フォーム        mailPage.asp
(sEmail, captcha)   ->    |
                          v
Session("captcha")  ->    CSRF/CAPTCHA検証
                          |
                          v
                          メールアドレス検証
                          |
                          v
                          セッション保存        ->    Session("QS_CMS_email")
                          |
tblPage             ->    ページ内容取得
(selectedPage)            |
                          v
                          本文構築
                          |
                          v
                          cls_mail_message.send()  ->  宛先メールボックス
                          |
                          v
                          送信完了画面表示      ->  ブラウザ
                                                     (window.close())
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mailPage.asp | `mailPage.asp` | ソース | ページ共有フォーム・送信処理 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| process.asp | `asp/process.asp` | ソース | ページ処理 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（replaceBlocks） |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
