# 通知設計書 9-プライベートメッセージ送信

## 概要

本ドキュメントは、QuickerSiteシステムにおけるプライベートメッセージ送信機能の設計を記述する。Intranetユーザー間でプライベートメッセージを送信する機能であり、送信者へのCC機能も備えている。

### 本通知の処理概要

プライベートメッセージ送信は、Intranetにログインしているユーザーが、他のIntranetユーザーに対してプライベートメッセージをメールで送信できる機能である。受信設定（bGetEmailsFromSite）が有効なユーザーにのみ送信可能で、送信者自身にCCを送ることもできる。

**業務上の目的・背景**：Intranetコミュニティ内でのユーザー間コミュニケーションを促進するため。フォーラムやコメント以外の、プライベートな連絡手段を提供する。実際のメールアドレスを公開せずに、ニックネームベースでのコンタクトを可能にする。

**通知の送信タイミング**：送信者がプライベートメッセージフォーム（fs_mailcontact.asp）でメッセージ本文を入力し、CAPTCHAを正しく入力して送信ボタンをクリックした直後。バリデーションを通過した場合のみ送信される。

**通知の受信者**：選択された宛先ユーザー（bGetEmailsFromSite=trueのユーザーのみ）。宛先ユーザーのsEmailに送信される。送信者自身にCCを送る場合は、送信者のsEmailにも送信される。

**通知内容の概要**：送信者のニックネーム、サイトURL、メッセージ本文（URL自動リンク化）。件名は「Private message from [送信者ニックネーム] ([サイトURL])」形式。

**期待されるアクション**：受信者はプライベートメッセージを確認し、必要に応じてIntranet上で返信するか、直接メールで返信する（Reply-Toが送信者メールアドレスに設定）。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

1. 送信者がIntranetにログインしていることを確認
2. 宛先ユーザーのbGetEmailsFromSiteがtrueであることを確認
3. 宛先ユーザーのsEmailに送信
4. CC設定がtrueの場合、送信者のsEmailにも送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | logon.contact.sEmail（送信者のメールアドレス） |
| 送信元名称 | logon.contact.sNickName（送信者のニックネーム） |
| 件名 | "Private message from [送信者ニックネーム] ([サイトURL])" |
| 形式 | HTML |

### 本文テンプレート

```html
[メッセージ本文（URL自動リンク化済み）]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | プライベートメッセージには添付ファイルを含まない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| [送信者ニックネーム] | 送信者のニックネーム | logon.contact.sNickName | Yes |
| [サイトURL] | サイトのURL | customer.surl | Yes |
| [メッセージ本文] | 送信者が入力したメッセージ | Request.Form("body") | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | プライベートメッセージ送信ボタンクリック | CAPTCHA正常、本文あり、認証済み | fs_mailcontact.asp |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 未認証 | Intranetにログインしていない場合（Response.End） |
| bGetEmailsFromSite=false | 宛先ユーザーがメール受信を許可していない場合（Response.End） |
| CAPTCHAエラー | 画像認証が正しくない場合 |
| 本文が空 | メッセージ本文が入力されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ニックネームクリック] --> B{Intranet認証済み?}
    B -->|No| C[処理終了]
    B -->|Yes| D{宛先bGetEmailsFromSite?}
    D -->|false| C
    D -->|true| E[プライベートメッセージフォーム表示]
    E --> F[メッセージ入力]
    F --> G[CC設定（オプション）]
    G --> H[CAPTCHA入力]
    H --> I[送信ボタンクリック]
    I --> J{CAPTCHA検証}
    J -->|失敗| K[err_captchaエラー表示]
    J -->|成功| L{本文チェック}
    L -->|空| M[err_mandatoryエラー表示]
    L -->|あり| N[cls_mail_message作成]
    N --> O[宛先・送信元設定]
    O --> P[件名・本文設定]
    P --> Q[メール送信（宛先）]
    Q --> R{CC設定あり?}
    R -->|Yes| S[CC送信（送信者）]
    R -->|No| T[完了画面へリダイレクト]
    S --> T
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| tblContact | 宛先・送信者のユーザー情報 | sEmail、sNickName、bGetEmailsFromSite |

### テーブル別参照項目詳細

#### tblContact（宛先ユーザー）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sEmail | 宛先メールアドレス | iId指定 |
| sNickName | 宛先ニックネーム | 表示用 |
| bGetEmailsFromSite | メール受信許可フラグ | アクセス制御 |

#### tblContact（送信者 - logon.contact）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sEmail | 送信元・CC先メールアドレス | ログインセッション |
| sNickName | 送信者ニックネーム | 件名・送信元名 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | プライベートメッセージではDBを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 未認証エラー | Intranetにログインしていない | Response.Endで処理終了 |
| 受信不可エラー | 宛先ユーザーがbGetEmailsFromSite=false | Response.Endで処理終了 |
| CAPTCHAエラー | 画像認証の入力ミス | err_captchaエラー表示 |
| 本文空エラー | メッセージ本文が空 | err_mandatoryエラー表示 |
| 送信失敗 | SMTPエラー等 | エラー処理なし |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（CAPTCHAで制御） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

ユーザーアクションに連動するため、24時間いつでも送信可能。

## セキュリティ考慮事項

- 認証必須：Intranetログインユーザーのみが送信可能
- 受信許可チェック：bGetEmailsFromSite=trueのユーザーにのみ送信可能
- CAPTCHA：スパム送信の防止
- メールアドレス非公開：ニックネームベースでのコンタクト（実アドレスはReply-Toのみ）
- 本文検証：空メッセージの送信防止
- URL自動リンク：linkURLS関数でURLをリンク化（XSSリスク注意）

## 備考

- 送信完了後はfb_mailsentメッセージが表示される
- ポップアップウィンドウとして表示される（bPopupFullWidthNoReloadクラス使用）
- CC送信は送信者自身へのメモ機能として使用
- 送信元（From/Reply-To）は送信者のメールアドレスとニックネーム
- 宛先ユーザーは直接メールで返信可能
- 本文はlinkURLS関数でURL自動リンク化される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

プライベートメッセージフォームと送信処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fs_mailcontact.asp | `asp/fs_mailcontact.asp` | フォーム表示と送信処理（行1-34） |

**主要処理フロー**:
1. **行6**: Intranet認証チェック
2. **行7**: bGetEmailsFromSiteチェック
3. **行8**: postbackフラグチェック
4. **行9-11**: CAPTCHA検証
5. **行11-12**: 本文空チェック
6. **行14-29**: メール送信処理
7. **行30**: 完了画面へリダイレクト

#### Step 2: アクセス制御を理解する

ユーザー間メッセージの送受信制御。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contact.asp | `asp/includes/contact.asp` | sClickNickNameプロパティ（行438-448） |

**主要処理フロー**:
- **行442-443**: bGetEmailsFromSite確認とリンク生成
- **行443**: bPopupFullWidthNoReloadクラスでポップアップ表示

#### Step 3: メール送信を理解する

cls_mail_messageを使用した送信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_mailcontact.asp | `asp/fs_mailcontact.asp` | 行14-29のメール送信処理 |

**主要処理フロー**:
- **行15-16**: cls_mail_message作成、宛先設定
- **行17-18**: 宛先ニックネーム、件名設定
- **行19-21**: 本文設定（linkURLS）、送信元設定
- **行22**: send()呼び出し
- **行24-27**: CC送信処理

### プログラム呼び出し階層図

```
[ニックネームリンク] (contact.asp sClickNickName)
    |
    +-- fs_mailcontact.asp (ポップアップ)
           |
           +-- logon.authenticatedIntranet [認証チェック]
           |
           +-- contact.bGetEmailsFromSite [受信許可チェック]
           |
           +-- Session("CAPTCHA")比較 [CAPTCHA検証]
           |
           +-- cls_mail_message
                  |
                  +-- linkURLS() [URL自動リンク]
                  |
                  +-- send() [メール送信（宛先）]
                  |
                  +-- send() [メール送信（CC、オプション）]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ニックネームリンク        fs_mailcontact.asp
(iContactID)        ->    |
                          v
logon.contact       ->    認証チェック
(認証情報)                |
                          v
tblContact          ->    受信許可チェック
(bGetEmailsFromSite)      |
                          v
フォーム入力              CAPTCHA/本文検証
(body, cc, captcha) ->    |
                          v
logon.contact       ->    送信元情報設定
(sEmail, sNickName)       |
                          v
contact             ->    宛先情報設定
(sEmail, sNickName)       |
                          v
                          cls_mail_message.send()  ->  宛先メールボックス
                          |
                          v
                          CC送信（オプション）    ->  送信者メールボックス
                          |
                          v
                          リダイレクト           ->  完了画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_mailcontact.asp | `asp/fs_mailcontact.asp` | ソース | プライベートメッセージフォーム・送信処理 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス定義 |
| contact.asp | `asp/includes/contact.asp` | ソース | コンタクトクラス（sClickNickName） |
| logon.asp | `asp/includes/logon.asp` | ソース | ログオンクラス（認証情報） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
