---
generated_at: 2026-01-23 23:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-ニュースレター配信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **配信時間帯制限**：システム仕様としての時間帯制限の有無を確認
  2. **1日あたり上限**：レート制限の具体的な設定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/newsletter.asp` 行2-171（cls_newsletterクラス全体）
- E-02: `asp/bs_newsletterMailingSend.asp` 行1-93（配信制御処理）
- E-03: `asp/includes/mail_message.asp` 行2-175（cls_mail_messageクラス全体）
- E-04: `asp/includes/newsletter.asp` 行139-170（send関数）
- E-05: `asp/includes/newsletter.asp` 行7-13（デフォルトテンプレート）
- E-06: `asp/bs_newsletterMailingSend.asp` 行29-64（購読者ループ処理）
- E-07: `asp/bs_newsletterMailingSend.asp` 行40-53（ログ記録処理）
- E-08: `asp/includes/newsletter.asp` 行161-166（テンプレート変数置換）
- E-09: `asp/bs_newsletterMailingSend.asp` 行4（セキュリティチェック）
- E-10: `asp/includes/newsletter.asp` 行78-91（checkメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレターはHTMLメール形式で送信される | E-03行64, E-05 | ○ |
| C-02 | 受信者名・メールアドレスの動的置換機能あり | E-08（行161-165） | ○ |
| C-03 | 購読解除リンクが自動挿入される | E-08（行166） | ○ |
| C-04 | 送信方式はバッチ形式（同期） | E-02行25-74 | ○ |
| C-05 | デフォルト送信間隔は10件/15秒 | E-02行12-18（iInterval=10, iIntervalS=15） | ○ |
| C-06 | bActive=trueの購読者のみ対象 | E-06（行29のSQLクエリ） | ○ |
| C-07 | 重複メールアドレスは除外される | E-06行39（allEmails.existsチェック） | ○ |
| C-08 | 送信元アドレスのデフォルトはcustomer.webmasterEmail | E-01行10 | ○ |
| C-09 | 送信元名称のデフォルトはcustomer.webmaster | E-01行9 | ○ |
| C-10 | 件名のデフォルトは"Subject line" | E-01行8 | ○ |
| C-11 | テンプレート変数[NL_NAME]が使用可能 | E-08行161, 164 | ○ |
| C-12 | テンプレート変数[NL_EMAIL]が使用可能 | E-08行162, 165 | ○ |
| C-13 | テンプレート変数[NL_UNSUBSCRIBELINK]が使用可能 | E-08行166 | ○ |
| C-14 | 管理者による手動トリガーで送信開始 | E-02行88（フォームsubmit） | ○ |
| C-15 | META REFRESHで自動リロード | E-02行85 | ○ |
| C-16 | ログ機能が有効時に開封トラッキング可能 | E-07行40-56 | ○ |
| C-17 | 配信完了時に送信日時を記録 | E-02行67-69 | ○ |
| C-18 | エラー時はOn Error Resume Nextでスキップ | E-01行5, E-03行15 | ○ |
| C-19 | リトライ機能はない | E-02, E-01（リトライコードなし） | ○ |
| C-20 | セキュリティチェックにsecondAdmin.bNewsletter使用 | E-09 | ○ |
| C-21 | 購読解除キーは24文字のランダムキー | E-01行166（k=rs("sKey")）, E-02行49 | ○ |
| C-22 | CSRF対策としてQS_secCodeHiddenを使用 | E-02行88 | ○ |
| C-23 | sUnsubscribeTextが空の場合は保存エラー | E-10行84-87 | ○ |
| C-24 | 添付ファイルはサポートされない | E-04（addAttachment呼び出しなし） | ○ |
| C-25 | 本文はtreatConstants関数で定数展開される | E-04行148 | ○ |
| C-26 | サイト定数の展開はキャッシュされる | E-04行147-153（bConstantsLoaded） | ○ |
| C-27 | 配信時間帯の制限はシステム側で設定されていない | **根拠なし** | △ |
| C-28 | 1日あたりの送信上限は制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **配信時間帯制限**：コード上に時間帯チェックのロジックは見つからないが、明示的な「制限なし」の記述も確認できない
  - 候補：運用マニュアル / システム設定ファイル / 要件定義書
- **1日あたり送信上限**：コード上にカウンターやリミットチェックは見つからないが、SMTPサーバー側の制限は未確認
  - 候補：SMTPサーバー設定 / インフラ設計書 / 外部サービス仕様書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 主要機能の説明は全てソースコードで確認可能
- **1: 中リスク** - 配信レート制限の設計意図（なぜ10件/15秒がデフォルトか）の根拠不明
- **0: 低リスク** - セキュリティ関連の記述はコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] send関数（newsletter.asp 行139-170）の動作を実環境で確認
- [ ] META REFRESH による自動リロード動作の確認
- [ ] 開封トラッキング用ピクセルのURL生成ロジック確認（行51）
- [ ] SMTPサーバー設定（mail_message.asp 行37-51）が本番環境と一致するか確認
- [ ] 購読解除リンクのURLパス（行166）が正しいか確認
