---
generated_at: 2026-01-24 00:18:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-フォーラム投稿通知（テーマ購読者向け）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/post.asp` 行168-233（投稿保存時の通知処理全体）
- E-02: `asp/includes/post.asp` 行170（isNew判定）
- E-03: `asp/includes/post.asp` 行175-196（テーマ購読者への通知処理）
- E-04: `asp/includes/post.asp` 行176-180（テーマ購読者取得SQL）
- E-05: `asp/includes/post.asp` 行182-195（購読者ループ・送信処理）
- E-06: `asp/includes/post.asp` 行199-217（トピック購読者への通知処理）
- E-07: `asp/includes/post.asp` 行201-205（トピック購読者取得SQL）
- E-08: `asp/includes/post.asp` 行219-233（モデレーター通知）
- E-09: `asp/includes/post.asp` 行729-748（preparenotifyReply関数）
- E-10: `asp/includes/post.asp` 行749-773（preparenotifyTopic関数）
- E-11: `asp/includes/theme.asp` 行34-38（通知テンプレートのデフォルト値）
- E-12: `asp/includes/theme.asp` 行697-726（subscribeToTheme関数）
- E-13: `asp/includes/theme.asp` 行658-683（subscribeToTopic関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規投稿時のみ通知（isNew判定） | E-02行170（if isNew then） | ○ |
| C-02 | テーマ購読者への新規トピック通知 | E-03行175-196 | ○ |
| C-03 | iSubLevel=QS_theme_sublevel_themeの場合のみテーマ通知 | E-03行175 | ○ |
| C-04 | tblThemeSubscriptionから購読者取得 | E-04行176-178 | ○ |
| C-05 | 投稿者自身を除外（iContactID<>logon.contact.iId） | E-04行179 | ○ |
| C-06 | sEmailが空でないユーザーのみ | E-04行180 | ○ |
| C-07 | トピック購読者への新規コメント通知 | E-06行199-217 | ○ |
| C-08 | iSubLevel>QS_theme_sublevel_noneの場合のみトピック通知 | E-06行199 | ○ |
| C-09 | iPostID<>0（返信）の場合のみトピック通知 | E-06行200 | ○ |
| C-10 | tblThemeTopicSubscriptionから購読者取得 | E-07行202-203 | ○ |
| C-11 | cls_mail_messageを使用 | E-05行183（new cls_mail_message） | ○ |
| C-12 | theme.sSubjectNotificationでコメント通知件名 | E-05行185 | ○ |
| C-13 | theme.sTopicSubjectNotificationでトピック通知件名 | E-05行188 | ○ |
| C-14 | preparenotifyReply関数でコメント通知本文生成 | E-09行729-748 | ○ |
| C-15 | preparenotifyTopic関数でトピック通知本文生成 | E-10行749-773 | ○ |
| C-16 | [QS_theme:postsubject]変数置換 | E-09行736, E-10行757 | ○ |
| C-17 | [QS_theme:Replyer]変数置換 | E-09行732-734 | ○ |
| C-18 | [QS_theme:Poster]変数置換 | E-10行752-755 | ○ |
| C-19 | [QS_theme:reply]変数置換 | E-09行737 | ○ |
| C-20 | [QS_theme:post]変数置換 | E-10行759-761 | ○ |
| C-21 | [QS_theme:postlink]変数置換 | E-09行738, E-10行768 | ○ |
| C-22 | bNeedsToBeValidated時に専用メッセージ追加 | E-09行745-747, E-10行770-772 | ○ |
| C-23 | モデレーター通知（bForwardPostsToModerator） | E-08行220 | ○ |
| C-24 | デフォルト通知テンプレート定義 | E-11行34-38 | ○ |
| C-25 | sAnName対応（匿名投稿者名） | E-09行731-734, E-10行752-755 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **1: 中リスク** - 購読者が多い場合の同期送信によるパフォーマンス影響

## 6) レビュアーチェックリスト（最小）
- [ ] iSubLevelの各レベル定義を確認
- [ ] 購読者が多い場合のパフォーマンスを検証
- [ ] テンプレート変数のXSS対策を確認（quotrep, filterJS）
- [ ] モデレーター通知の必要性を確認
- [ ] 検証待ち投稿（bNeedsToBeValidated）の通知内容を確認
