---
generated_at: 2026-01-23 23:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-フォーラム投稿通知（トピック購読者向け）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様**：明示的なリトライ実装の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/post.asp` 行199-217（トピック購読者向け通知送信処理）
- E-02: `asp/includes/post.asp` 行201-205（購読者取得SQL）
- E-03: `asp/includes/post.asp` 行729-748（preparenotifyReply関数）
- E-04: `asp/includes/theme.asp` 行34-38（デフォルトテンプレート定義）
- E-05: `asp/includes/theme.asp` 行658-696（subscribeToTopic/unsubscribeFromTopic関数）
- E-06: `asp/includes/mail_message.asp` 行14-174（send関数）
- E-07: `asp/includes/contact.asp` 行324-337（bHasSubscribedToTopic関数）
- E-08: `asp/includes/post.asp` 行170（isNew条件分岐）
- E-09: `asp/includes/post.asp` 行204（投稿者除外条件）
- E-10: `asp/includes/theme.asp` 行38（iSubLevel定義）
- E-11: `asp/includes/mail_message.asp` 行23-24（送信元設定）
- E-12: `asp/includes/post.asp` 行774-783（prepareLink関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トピック購読者向けに返信通知を送信する | E-01 | ○ |
| C-02 | tblThemeTopicSubscriptionテーブルで購読管理 | E-02, E-05 | ○ |
| C-03 | 投稿者本人は通知対象から除外される | E-09 | ○ |
| C-04 | 新規投稿時のみ通知が送信される | E-08 | ○ |
| C-05 | iPostID<>0の条件で返信を判定 | E-01 | ○ |
| C-06 | theme.sSubjectNotificationが件名に使用される | E-01, E-04 | ○ |
| C-07 | sBodyNotificationがテンプレートとして使用される | E-03, E-04 | ○ |
| C-08 | [QS_theme:postsubject]で元トピック件名を置換 | E-03 | ○ |
| C-09 | [QS_theme:Replyer]で返信者名を置換 | E-03 | ○ |
| C-10 | [QS_theme:reply]で返信内容を置換 | E-03 | ○ |
| C-11 | [QS_theme:postlink]でリンクURLを置換 | E-03, E-12 | ○ |
| C-12 | cls_mail_messageクラスでメール送信 | E-06 | ○ |
| C-13 | customer.webmasterEmailが送信元アドレス | E-11 | ○ |
| C-14 | iSubLevel > QS_theme_sublevel_noneの条件 | E-01, E-10 | ○ |
| C-15 | 有効なメールアドレスのみに送信 | E-02 | ○ |
| C-16 | HTMLメール形式で送信 | E-06 | ○ |
| C-17 | アバター画像が本文に含まれる | E-03 | ○ |
| C-18 | リトライ処理は実装されていない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **リトライ仕様について**：`On Error Resume Next`によるエラー無視は確認できるが、明示的な「リトライなし」の設計意図を示す根拠は見つからなかった
  - 候補：設計書 / 要件定義書 / コメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 大部分の主張がソースコードで確認可能
- リトライ仕様の記述は推測に基づくため要確認

## 6) レビュアーチェックリスト（最小）

- [ ] `asp/includes/post.asp` 行199-217の処理フローが正確に記述されているか
- [ ] テンプレート変数の置換処理が全て網羅されているか
- [ ] 送信条件（iSubLevel、isNew、iPostID）の記述が正確か
- [ ] エラー処理の記述が実装と一致するか
