---
generated_at: 2026-01-23 23:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-フォーラムモデレーター通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できています

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/post.asp` 行219-233（モデレーター通知送信処理）
- E-02: `asp/includes/post.asp` 行220（送信条件：bForwardPostsToModerator AND 投稿者<>モデレーター）
- E-03: `asp/includes/post.asp` 行222（宛先：theme.contact.sEmail）
- E-04: `asp/includes/post.asp` 行223-230（返信/新規トピックの分岐処理）
- E-05: `asp/includes/post.asp` 行224-225（返信時のテンプレート展開）
- E-06: `asp/includes/post.asp` 行227-229（新規トピック時のテンプレート展開）
- E-07: `asp/includes/theme.asp` 行33（bForwardPostsToModeratorデフォルト値=True）
- E-08: `asp/includes/theme.asp` 行78（bForwardPostsToModeratorのDB読み込み）
- E-09: `asp/includes/theme.asp` 行654-657（contact関数でモデレーター取得）
- E-10: `asp/includes/post.asp` 行729-748（preparenotifyReply関数）
- E-11: `asp/includes/post.asp` 行749-773（preparenotifyTopic関数）
- E-12: `asp/includes/post.asp` 行225, 229（getVisitorDetailsの追加）
- E-13: `asp/includes/mail_message.asp` 行14-174（send関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モデレーターに投稿を転送する機能 | E-01 | ○ |
| C-02 | bForwardPostsToModeratorで転送有効/無効を制御 | E-02, E-07, E-08 | ○ |
| C-03 | 投稿者がモデレーター本人の場合は通知しない | E-02 | ○ |
| C-04 | theme.contact.sEmailに送信 | E-03, E-09 | ○ |
| C-05 | 返信時はpreparenotifyReplyを使用 | E-04, E-05, E-10 | ○ |
| C-06 | 新規トピック時はpreparenotifyTopicを使用 | E-04, E-06, E-11 | ○ |
| C-07 | 件名に"moderatornotification"が含まれる | E-05, E-06 | ○ |
| C-08 | 訪問者詳細情報が本文に追加される | E-12 | ○ |
| C-09 | cls_mail_messageでメール送信 | E-01, E-13 | ○ |
| C-10 | 新規投稿時のみ通知（isNew条件） | E-01 | ○ |
| C-11 | iPostID<>0で返信を判定 | E-04 | ○ |
| C-12 | bForwardPostsToModeratorのデフォルト値はTrue | E-07 | ○ |
| C-13 | テンプレート変数[QS_theme:*]が置換される | E-10, E-11 | ○ |
| C-14 | 添付ファイルはリンクとして表示 | E-10, E-11 | ○ |
| C-15 | モデレーター未設定時は通知されない | E-02, E-09 | ○ |
| C-16 | HTMLメール形式で送信 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対して根拠が確認されました。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `asp/includes/post.asp` 行219-233のモデレーター通知処理が正確に記述されているか
- [ ] 送信条件（bForwardPostsToModerator, 投稿者<>モデレーター）の記述が正確か
- [ ] 返信/新規トピックのテンプレート使い分けが正しく記述されているか
- [ ] getVisitorDetails追加の記述が実装と一致するか
