---
generated_at: 2026-01-23 23:52:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ユーザーステータス変更通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できています

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/contact.asp` 行211-224（ステータス変更通知処理）
- E-02: `asp/includes/contact.asp` 行211（送信条件：copyStatus<>iStatus AND iStatus<>cs_silent）
- E-03: `asp/includes/contact.asp` 行212-214（cls_customerImess.Pick呼び出し）
- E-04: `asp/includes/contact.asp` 行215（有効フラグと本文チェック）
- E-05: `asp/includes/contact.asp` 行216-222（メール作成・送信）
- E-06: `asp/includes/contact.asp` 行64（copyStatus設定：Pick関数内）
- E-07: `asp/includes/customerIntranetMessage.asp` 行1-51（cls_customerImessクラス全体）
- E-08: `asp/includes/customerIntranetMessage.asp` 行10-23（Pick関数）
- E-09: `asp/includes/customerIntranetMessage.asp` 行16-19（sSubject, sBody取得）
- E-10: `asp/includes/mail_message.asp` 行14-174（send関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ステータス変更時にユーザーに通知を送信 | E-01 | ○ |
| C-02 | copyStatus<>iStatusで変更を検知 | E-02, E-06 | ○ |
| C-03 | cs_silentステータスへの変更は通知しない | E-02 | ○ |
| C-04 | tblCustomerIntranetMessageから設定を取得 | E-03, E-08 | ○ |
| C-05 | bEnabled=Trueの場合のみ送信 | E-04 | ○ |
| C-06 | sBodyが空の場合は送信しない | E-04 | ○ |
| C-07 | sSubjectが件名として使用される | E-05, E-09 | ○ |
| C-08 | sBodyが本文として使用される | E-05, E-09 | ○ |
| C-09 | contact.sEmailに送信 | E-05 | ○ |
| C-10 | cls_mail_messageでメール送信 | E-05, E-10 | ○ |
| C-11 | cls_customerImessクラスでメッセージ設定を管理 | E-07 | ○ |
| C-12 | ステータス別にメッセージをカスタマイズ可能 | E-08 | ○ |
| C-13 | copyStatusはPick関数で設定される | E-06 | ○ |
| C-14 | HTMLメール形式で送信 | E-10 | ○ |
| C-15 | Save関数内で通知処理が実行される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対して根拠が確認されました。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `asp/includes/contact.asp` 行211-224のステータス変更通知処理が正確に記述されているか
- [ ] 送信条件（copyStatus<>iStatus, iStatus<>cs_silent）の記述が正確か
- [ ] cls_customerImessクラスの役割が正しく記述されているか
- [ ] bEnabledとsBodyのチェックロジックが実装と一致するか
