---
generated_at: 2026-01-23 23:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-管理者ログイン試行警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できています

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/LogonEdit.asp` 行68-85（lockAdmin関数）
- E-02: `asp/includes/LogonEdit.asp` 行86-98（lockBSAdmin関数）
- E-03: `asp/includes/LogonEdit.asp` 行74（試行回数超過チェック：adminLoginCount）
- E-04: `asp/includes/LogonEdit.asp` 行87（試行回数超過チェック：bsLoginCount）
- E-05: `asp/includes/LogonEdit.asp` 行76-77（Err.Raiseでエラー発生）
- E-06: `asp/includes/LogonEdit.asp` 行77-80（重複メール送信防止：mailSentフラグ）
- E-07: `asp/includes/LogonEdit.asp` 行79, 92（dumpError呼び出し）
- E-08: `asp/includes/LogonEdit.asp` 行82-83, 95-96（Response.EndでIPブロック）
- E-09: `asp/includes/LogonEdit.asp` 行69-73（C_ADMINPASSWORD未設定時の処理）
- E-10: `asp/includes/LogonEdit.asp` 行41, 59（ログイン成功時の試行回数リセット）
- E-11: `asp/includes/functions.asp` 行497-515（dumpError関数）
- E-12: `asp/includes/functions.asp` 行486-496（ErrorReport関数）
- E-13: `asp/includes/functions.asp` 行487（C_ADMINEMAIL設定チェック）
- E-14: `asp/includes/functions.asp` 行492（getVisitorDetails追加）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理画面へのログイン試行制限機能 | E-01, E-02 | ○ |
| C-02 | adminLoginCountで試行回数をカウント | E-03 | ○ |
| C-03 | bsLoginCountでBacksite試行回数をカウント | E-04 | ○ |
| C-04 | 規定回数超過時にErr.Raiseでエラー発生 | E-05 | ○ |
| C-05 | mailSentフラグで重複メール送信を防止 | E-06 | ○ |
| C-06 | dumpError関数でエラー情報を整形 | E-07, E-11 | ○ |
| C-07 | ErrorReport関数でメール送信 | E-12 | ○ |
| C-08 | C_ADMINEMAILに送信 | E-13 | ○ |
| C-09 | getVisitorDetailsで訪問者情報を追加 | E-14 | ○ |
| C-10 | Response.EndでIPブロック・処理中断 | E-08 | ○ |
| C-11 | C_ADMINPASSWORD未設定時は機能無効化 | E-09 | ○ |
| C-12 | ログイン成功時に試行回数リセット | E-10 | ○ |
| C-13 | Admin画面とBacksite画面で別々にカウント | E-03, E-04 | ○ |
| C-14 | Application変数でIPごとに管理 | E-03, E-06 | ○ |
| C-15 | HTMLメール形式で送信 | E-12 | ○ |
| C-16 | エラー番号・説明・ソースがメールに含まれる | E-11 | ○ |
| C-17 | セッション変数がメールに含まれる | E-11 | ○ |
| C-18 | 同一IPへは1回のみメール送信 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対して根拠が確認されました。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `asp/includes/LogonEdit.asp` のlockAdmin関数（行68-85）が正確に記述されているか
- [ ] `asp/includes/LogonEdit.asp` のlockBSAdmin関数（行86-98）が正確に記述されているか
- [ ] 試行回数の超過チェック条件が正確か
- [ ] 重複メール送信防止のロジックが実装と一致するか
- [ ] `asp/includes/functions.asp` のErrorReport関数（行486-496）が正確に記述されているか
