---
generated_at: 2026-01-23 23:48:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ニュースレター購読解除通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_unsubscribe.asp` 行1-48（購読解除処理全体）
- E-02: `asp/process_unsubscribe.asp` 行2（キー長チェック）
- E-03: `asp/process_unsubscribe.asp` 行5（購読者検索SQL）
- E-04: `asp/process_unsubscribe.asp` 行9-10（カテゴリ取得）
- E-05: `asp/process_unsubscribe.asp` 行21-26（bActive更新）
- E-06: `asp/process_unsubscribe.asp` 行27-34（通知メール送信）
- E-07: `asp/process_unsubscribe.asp` 行30-31（件名設定）
- E-08: `asp/process_unsubscribe.asp` 行32（本文設定）
- E-09: `asp/process_unsubscribe.asp` 行13-17（フィードバック変数置換）
- E-10: `asp/includes/mail_message.asp` 行2-175（メール送信クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 購読解除リンククリック時に管理者へ通知 | E-06行27-34 | ○ |
| C-02 | sNotifEmailが設定されている場合のみ送信 | E-06行27 | ○ |
| C-03 | 解除者のメールアドレスと名前を含む | E-08行32 | ○ |
| C-04 | 送信方式は同期 | E-01（非同期処理なし） | ○ |
| C-05 | 件名は"Unsubscribe from email list '[カテゴリ名]': [メールアドレス]" | E-07行31 | ○ |
| C-06 | 本文は"email: [メール]<br />name: [名前]" | E-08行32 | ○ |
| C-07 | キー長が24文字でない場合はリダイレクト | E-02（len(request.querystring("e"))=24） | ○ |
| C-08 | sKeyで購読者を検索 | E-03行5（sKey='...'条件） | ○ |
| C-09 | カテゴリが存在しない場合はリダイレクト | E-04行10（convertGetal(QS_nl.iId)<>0） | ○ |
| C-10 | 既に購読解除済みの場合はリダイレクト | E-05行21（not convertBool(rsE("bActive"))） | ○ |
| C-11 | bActiveをfalseに更新 | E-05行25 | ○ |
| C-12 | cls_mail_messageを使用して送信 | E-06行29（new cls_mail_message） | ○ |
| C-13 | 購読者レコードは削除されない | E-01（DELETEなし、UPDATEのみ） | ○ |
| C-14 | フィードバック文で[NL_NAME]置換 | E-09行13, 16 | ○ |
| C-15 | フィードバック文で[NL_EMAIL]置換 | E-09行14, 17 | ○ |
| C-16 | cleanup関数でキーをサニタイズ | E-03行5（cleanup(request.querystring("e"))） | ○ |
| C-17 | left関数で24文字に制限 | E-03行5（left(...,24)） | ○ |
| C-18 | quotrep関数でエスケープ | E-08行32, E-09行13-17 | ○ |
| C-19 | sNotifEmailが空の場合は通知スキップ | E-06行27（not isLeeg条件） | ○ |
| C-20 | カテゴリ名は件名に含まれる | E-07行31（QS_nl.sName） | ○ |
| C-21 | 送信元はシステムデフォルト | E-10行23-24（fromemail, fromname未設定時） | ○ |
| C-22 | HTML形式で送信 | E-10行17（wrapInHTML） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **0: 低リスク** - 処理が単純でエラーケースも適切にカバー

## 6) レビュアーチェックリスト（最小）
- [ ] 購読解除キーの24文字制限が適切か確認（総当たり攻撃対策として十分か）
- [ ] sNotifEmailの設定方法（管理画面）を確認
- [ ] 通知メールの件名・本文が運用上適切か確認
- [ ] quotrep関数のエスケープ処理がHTMLインジェクション対策として十分か確認
