---
generated_at: 2026-01-23 23:52:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-フォーム送信通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/form.asp` 行2-60（cls_formクラス定義）
- E-02: `asp/includes/form.asp` 行250-804（build関数）
- E-03: `asp/includes/form.asp` 行441-517（bSendEmail処理ブロック）
- E-04: `asp/includes/form.asp` 行269-274（CSRF・ハニーポット）
- E-05: `asp/includes/form.asp` 行285-295（CAPTCHAバリデーション）
- E-06: `asp/includes/form.asp` 行296-373（フィールドバリデーション）
- E-07: `asp/includes/form.asp` 行317-372（ファイルバリデーション）
- E-08: `asp/includes/form.asp` 行376-380（Submission作成）
- E-09: `asp/includes/form.asp` 行452-461（本文ヘッダー作成）
- E-10: `asp/includes/form.asp` 行466-496（フィールドループ）
- E-11: `asp/includes/form.asp` 行497-515（宛先ループ）
- E-12: `asp/includes/form.asp` 行493-495（bUseForSending）
- E-13: `asp/includes/form.asp` 行501-503（attachments設定）
- E-14: `asp/includes/mail_message.asp` 行2-175（メール送信クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム送信時に管理者にメール送信 | E-03行441-517 | ○ |
| C-02 | bSendEmail=true時のみ送信 | E-03行441 | ○ |
| C-03 | 添付ファイル対応（bAttachFiles） | E-13行501-503 | ○ |
| C-04 | 送信者情報・サーバー情報を含む | E-03行510（sVisitorDetails） | ○ |
| C-05 | 改行区切りで複数宛先対応 | E-11行452（split(sTo,vbcrlf)） | ○ |
| C-06 | CheckEmailSyntaxでメール形式検証 | E-11行499 | ○ |
| C-07 | bUseForSendingでFrom/Reply-To設定 | E-12行493-495 | ○ |
| C-08 | [QS_FORM:フィールド名]で変数置換 | E-10行467 | ○ |
| C-09 | [QS_FORM:SUBMISSIONID]で送信ID置換 | E-03行443（insertSubmissionID） | ○ |
| C-10 | CSRF検証（checkCSRF_Upload） | E-04行274 | ○ |
| C-11 | CAPTCHAバリデーション | E-05行285-295 | ○ |
| C-12 | 必須項目バリデーション | E-06行303-306 | ○ |
| C-13 | メール形式バリデーション | E-06行309-314 | ○ |
| C-14 | ファイルサイズバリデーション | E-07行322-324 | ○ |
| C-15 | ファイル形式バリデーション | E-07行330-336 | ○ |
| C-16 | ハニーポット（your message） | E-04行270-272 | ○ |
| C-17 | 送信ID含む（submission.iId） | E-09行454 | ○ |
| C-18 | 送信日時含む | E-09行456 | ○ |
| C-19 | カタログ情報含む（該当時） | E-09行458-461 | ○ |
| C-20 | sAutoResponseWebmaster本文先頭 | E-03行510 | ○ |
| C-21 | フィールド値をループで本文構築 | E-10行466-496 | ○ |
| C-22 | ファイルはURL形式で本文に含む | E-10行474-476 | ○ |
| C-23 | チェックボックスはYes/No変換 | E-10行486 | ○ |
| C-24 | Submission作成（tblFormSubmission） | E-08行376-380 | ○ |
| C-25 | フィールド値保存（tblFormFieldValue） | E-02行383-423 | ○ |
| C-26 | スクリプト実行（sScriptUponSubmission） | E-02行427-439 | ○ |
| C-27 | 一時フォルダ自動削除 | E-02行549-551 | ○ |
| C-28 | sanitize関数でサニタイズ | E-10行467、490 | ○ |
| C-29 | linkUrls関数でURL自動リンク化 | E-10行490 | ○ |
| C-30 | treatConstants関数で定数展開 | E-03行445-446 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **1: 中リスク** - ファイルアップロード処理のセキュリティは追加レビュー推奨

## 6) レビュアーチェックリスト（最小）
- [ ] allowedFileTypesの設定内容を確認（危険な拡張子が含まれていないか）
- [ ] CAPTCHAの実装が適切か確認（セッション管理）
- [ ] sanitize関数のエスケープ処理がXSS対策として十分か確認
- [ ] 一時フォルダの権限設定が適切か確認
- [ ] sScriptUponSubmissionのセキュリティリスクを確認（任意コード実行）
