---
generated_at: 2026-01-23 23:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-フォーム自動返信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/form.asp` 行3-5（cls_formプロパティ定義）
- E-02: `asp/includes/form.asp` 行64-130（check関数）
- E-03: `asp/includes/form.asp` 行82-104（bAutoResponderバリデーション）
- E-04: `asp/includes/form.asp` 行518-547（自動返信処理ブロック）
- E-05: `asp/includes/form.asp` 行519-522（変数置換処理）
- E-06: `asp/includes/form.asp` 行523-526（フィールド置換ループ）
- E-07: `asp/includes/form.asp` 行528-530（[QS_COPYSUBMISSION]置換）
- E-08: `asp/includes/form.asp` 行532-546（送信ループ）
- E-09: `asp/includes/form.asp` 行20-24（デフォルト値設定）
- E-10: `asp/includes/mail_message.asp` 行2-175（メール送信クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bAutoResponder=true時のみ自動返信送信 | E-04行518 | ○ |
| C-02 | bAutoResponderフィールドの値が送信先 | E-08行533（cFields(fFieldKey).bAutoResponder） | ○ |
| C-03 | 入力値が空の場合は送信スキップ | E-08行534（not isLeeg条件） | ○ |
| C-04 | 送信元アドレスはsAutoResponseFromEmail | E-08行538 | ○ |
| C-05 | 送信元名称はsAutoResponseFromName | E-08行537 | ○ |
| C-06 | デフォルトFromEmailはcustomer.webmasterEmail | E-09行22 | ○ |
| C-07 | デフォルトFromNameはcustomer.sitename | E-09行23 | ○ |
| C-08 | 件名はsAutoResponseSubject | E-08行540 | ○ |
| C-09 | 本文はsAutoResponse | E-08行541 | ○ |
| C-10 | [QS_FORM:フィールド名]で変数置換 | E-06行524-525 | ○ |
| C-11 | [QS_FORM:SUBMISSIONID]で送信ID置換 | E-05行519-520（insertSubmissionID） | ○ |
| C-12 | [QS_COPYSUBMISSION]で送信内容コピー | E-07行528-530 | ○ |
| C-13 | sAutoResponse空時はerr_mandatory | E-03行83-86 | ○ |
| C-14 | sAutoResponseSubject空時はerr_mandatory | E-03行87-90 | ○ |
| C-15 | sAutoResponseFromName空時はerr_mandatory | E-03行91-94 | ○ |
| C-16 | sAutoResponseFromEmail空時はerr_mandatory | E-03行95-98 | ○ |
| C-17 | sAutoResponseFromEmail不正形式時はerr_email | E-03行99-102 | ○ |
| C-18 | LinkURLs関数でURL自動リンク | E-05行521 | ○ |
| C-19 | treatConstants関数で定数展開 | E-05行522 | ○ |
| C-20 | 複数bAutoResponderフィールド時は各々に送信 | E-08行532-546（ループ処理） | ○ |
| C-21 | HTML形式で送信 | E-10行17（wrapInHTML） | ○ |
| C-22 | 添付ファイルなし | E-08（attachments設定なし） | ○ |
| C-23 | sanitize関数でサニタイズ | E-06行524-525（sanitize呼び出し） | ○ |
| C-24 | cls_mail_messageを使用 | E-08行536（new cls_mail_message） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **0: 低リスク** - 設定バリデーションが適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] sAutoResponseのHTMLコンテンツが適切にエスケープされているか確認
- [ ] 複数のbAutoResponderフィールドがある場合の動作を確認
- [ ] [QS_COPYSUBMISSION]の出力形式を確認（HTMLとして適切か）
- [ ] 送信元アドレスのSPF/DKIM設定を確認（なりすまし対策）
