---
generated_at: 2026-01-23 23:58:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-パスワードリセット通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_forgotPW.asp` 行1-31（パスワード忘れフォーム処理）
- E-02: `asp/process_forgotPW.asp` 行2-9（フォーム処理ロジック）
- E-03: `asp/process_forgotPW.asp` 行3（CAPTCHA検証）
- E-04: `asp/process_forgotPW.asp` 行5（logon.resetPW呼び出し）
- E-05: `asp/includes/contact.asp` 行288-306（resetPWサブルーチン）
- E-06: `asp/includes/contact.asp` 行289（GeneratePassWord呼び出し）
- E-07: `asp/includes/contact.asp` 行291（DB更新）
- E-08: `asp/includes/contact.asp` 行293-305（メール送信処理）
- E-09: `asp/includes/contact.asp` 行296-300（テンプレート置換）
- E-10: `asp/includes/contact.asp` 行302（代替本文構築）
- E-11: `asp/includes/mail_message.asp` 行2-175（メール送信クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワード忘れ時に新パスワードをメール送信 | E-05行288-306 | ○ |
| C-02 | CAPTCHA検証を実施 | E-03行3 | ○ |
| C-03 | logon.resetPWで処理実行 | E-04行5 | ○ |
| C-04 | メールアドレス未登録時はerr_emailNotFound | E-02行8 | ○ |
| C-05 | CAPTCHA失敗時はerr_captcha | E-03行4 | ○ |
| C-06 | 新パスワードはGeneratePassWord()で生成 | E-06行289 | ○ |
| C-07 | tblContact.sPwを更新 | E-07行291 | ○ |
| C-08 | 件名は"[l("password")] [customer.siteName]" | E-08行296 | ○ |
| C-09 | [QS_intranet:contactemail]で置換 | E-09行298 | ○ |
| C-10 | [QS_intranet:contactpassword]で置換 | E-09行299 | ○ |
| C-11 | テンプレート有無で処理分岐 | E-09行297（instr条件） | ○ |
| C-12 | 置換なしテンプレート時はEmail/パスワード追記 | E-10行302 | ○ |
| C-13 | treatConstants関数で定数展開 | E-09行298, E-10行302 | ○ |
| C-14 | LinkURLs関数でURL自動リンク | E-10行302 | ○ |
| C-15 | cls_mail_messageを使用 | E-08行294（new cls_mail_message） | ○ |
| C-16 | 成功時はfb_emailFoundでリダイレクト | E-02行6 | ○ |
| C-17 | customer.intranetPWEmailでカスタマイズ可能 | E-09、E-10 | ○ |
| C-18 | パスワードはプレーンテキストで保存 | E-07行291（sPw=...直接代入） | ○ |
| C-19 | 送信先はsEmail | E-08行295 | ○ |
| C-20 | 送信元はシステムデフォルト | E-11行23-24（未設定時のデフォルト） | ○ |
| C-21 | HTML形式で送信 | E-11行17（wrapInHTML） | ○ |
| C-22 | 旧パスワードは即時無効化 | E-07行291（UPDATE実行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク** - パスワードがプレーンテキストで保存されている（セキュリティリスク）
- **1: 中リスク** - パスワードリセット要求の回数制限がない

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードのプレーンテキスト保存についてセキュリティレビュー
- [ ] GeneratePassWord関数のランダム性を確認
- [ ] パスワードリセット要求の悪用防止策（レート制限等）を検討
- [ ] customer.intranetPWEmailの設定内容を確認
- [ ] CAPTCHA実装のセキュリティを確認
