---
generated_at: 2026-01-24 00:02:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-アカウント登録チケット送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_register.asp` 行1-31（新規登録フォーム処理）
- E-02: `asp/process_register.asp` 行2-9（フォーム処理ロジック）
- E-03: `asp/includes/ticket.asp` 行2-119（cls_ticketクラス全体）
- E-04: `asp/includes/ticket.asp` 行35-70（check関数）
- E-05: `asp/includes/ticket.asp` 行72-99（SaveAndSend関数）
- E-06: `asp/includes/ticket.asp` 行107-115（sendTicket関数）
- E-07: `asp/includes/ticket.asp` 行116-118（activationlinkプロパティ）
- E-08: `asp/includes/ticket.asp` 行88（sTicket生成）
- E-09: `asp/includes/ticket.asp` 行46-56（CAPTCHA検証）
- E-10: `asp/includes/ticket.asp` 行58-64（アクティベーション待ちチェック）
- E-11: `asp/includes/ticket.asp` 行65-69（登録済みチェック）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクティベーションリンクを含むメール送信 | E-06行112 | ○ |
| C-02 | CAPTCHA検証を実施 | E-09行46-56 | ○ |
| C-03 | メールアドレス形式チェック | E-04行37-44 | ○ |
| C-04 | アクティベーション待ち重複チェック | E-10行58-64 | ○ |
| C-05 | 登録済み重複チェック（iStatus > cs_silent） | E-11行65-69 | ○ |
| C-06 | 重複時はerr_activationlink | E-10行62-63 | ○ |
| C-07 | 登録済み重複時はerr_doubleemail | E-11行67-68 | ○ |
| C-08 | CAPTCHA失敗時はerr_captcha | E-09行50-51、54-55 | ○ |
| C-09 | メール形式エラー時はerr_email | E-04行39-42 | ○ |
| C-10 | sTicketはGeneratePassWord x 2 | E-08行88 | ○ |
| C-11 | 訪問者詳細をgetVisitorDetails()で記録 | E-05行91 | ○ |
| C-12 | 件名はcustomer.sSubjectMailTicket | E-06行111 | ○ |
| C-13 | 本文はcustomer.sMailTicket | E-06行112 | ○ |
| C-14 | [QS_Intranet:ActivationLink]を置換 | E-06行112 | ○ |
| C-15 | アクティベーションURLはdefault.asp?pageAction=&ac= | E-07行117 | ○ |
| C-16 | treatConstants関数で定数展開 | E-06行111-112 | ○ |
| C-17 | cls_mail_messageを使用 | E-06行109（new cls_mail_message） | ○ |
| C-18 | 成功時はfb_activationlinkでリダイレクト | E-02行7 | ○ |
| C-19 | CSRF検証（checkCSRF） | E-02行3 | ○ |
| C-20 | メールアドレス小文字変換 | E-04行44（sEmail=lcase(sEmail)） | ○ |
| C-21 | tblContactRegistrationにレコード作成 | E-05行82-93 | ○ |
| C-22 | dCreatedTS設定 | E-05行84 | ○ |
| C-23 | iCustomerID設定 | E-05行92 | ○ |
| C-24 | sendTicket()でメール送信 | E-05行96 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **1: 中リスク** - チケット有効期限の設定がない（無期限で有効）

## 6) レビュアーチェックリスト（最小）
- [ ] チケットの有効期限を設定することを検討
- [ ] GeneratePassWord関数のランダム性を確認（16文字で十分か）
- [ ] customer.sMailTicketの設定内容を確認
- [ ] 訪問者情報（sVisitorDetails）の保存が適切か確認
- [ ] アクティベーションリンクのURLが正しいか確認
