---
generated_at: 2026-01-24 00:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-コンタクト一斉メール配信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_massMailing2.asp` 行1-83（一斉メール送信処理全体）
- E-02: `asp/bs_massMailing2.asp` 行7（スクリプトタイムアウト設定）
- E-03: `asp/bs_massMailing2.asp` 行8-11（初期化処理）
- E-04: `asp/bs_massMailing2.asp` 行16-17（CC・コンタクトID取得）
- E-05: `asp/bs_massMailing2.asp` 行20-63（コンタクトループ処理）
- E-06: `asp/bs_massMailing2.asp` 行26-41（変数置換処理）
- E-07: `asp/bs_massMailing2.asp` 行42-56（送信処理）
- E-08: `asp/bs_massMailing2.asp` 行47-56（CC送信ループ）
- E-09: `asp/bs_massMailing2.asp` 行65-79（送信履歴保存）
- E-10: `asp/bs_massMailing2.asp` 行80（リダイレクト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 選択したコンタクトに一斉メール送信 | E-05行20-63 | ○ |
| C-02 | フィールド値の動的置換機能 | E-06行26-41 | ○ |
| C-03 | CC送信対応 | E-08行47-56 | ○ |
| C-04 | 重複メールアドレス除外 | E-05行24（contactDict.Exists） | ○ |
| C-05 | sEmailが空のコンタクトはスキップ | E-05行23（not isLeeg条件） | ○ |
| C-06 | [l("email")]でメールアドレス置換 | E-06行28 | ○ |
| C-07 | [sPw]でパスワード置換 | E-06行29-31 | ○ |
| C-08 | カスタムフィールドの置換 | E-06行32-40 | ○ |
| C-09 | 日付型フィールドはconvertDateToPicker使用 | E-06行35-36 | ○ |
| C-10 | スクリプトタイムアウト10000秒 | E-02行7 | ○ |
| C-11 | contactDictで重複管理 | E-03行8 | ○ |
| C-12 | On Error Resume Nextでエラー継続 | E-05行25, E-09行65 | ○ |
| C-13 | ErrorReportでエラーログ | E-07行58 | ○ |
| C-14 | tblMailに送信履歴保存 | E-09行66-69 | ○ |
| C-15 | tblMailContactに送信先記録 | E-09行71-79 | ○ |
| C-16 | 送信完了後リダイレクト | E-10行80 | ○ |
| C-17 | 送信件数をcontactDict.Countで表示 | E-10行80（counter=...） | ○ |
| C-18 | CCはCheckEmailSyntaxで検証 | E-08行50 | ○ |
| C-19 | CC送信先はカンマ区切り | E-04行16（split(..., ",")） | ○ |
| C-20 | コンタクトIDはカンマ区切り | E-04行17（split(..., ",")） | ○ |
| C-21 | cls_mail_messageを使用 | E-03行11（new cls_mail_message） | ○ |
| C-22 | cls_contact.pickでコンタクト取得 | E-05行22（contact.pick） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク** - [sPw]でパスワードをメールに含めることが可能（セキュリティリスク）
- **1: 中リスク** - 大量送信時のSMTPサーバー負荷

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード置換機能（[sPw]）のセキュリティリスクを評価
- [ ] 大量送信時のタイムアウトとSMTPサーバー負荷を確認
- [ ] CC送信先の検証ロジックを確認
- [ ] 送信履歴の保持期間とデータ量を確認
- [ ] ErrorReport関数のログ出力先を確認
