---
generated_at: 2026-01-24 00:08:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ページ共有メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `mailPage.asp` 行1-52（ページ共有処理全体）
- E-02: `mailPage.asp` 行17-49（送信処理ブロック）
- E-03: `mailPage.asp` 行18-20（メールアドレス処理）
- E-04: `mailPage.asp` 行22-24（CAPTCHA検証）
- E-05: `mailPage.asp` 行25-27（メールアドレス形式チェック）
- E-06: `mailPage.asp` 行29-41（本文構築）
- E-07: `mailPage.asp` 行42-49（メール送信）
- E-08: `mailPage.asp` 行51（送信完了画面）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページ内容をメールで共有 | E-02行17-49 | ○ |
| C-02 | CAPTCHAによるスパム対策 | E-04行22-24 | ○ |
| C-03 | CAPTCHA失敗時はerr_captchaエラー | E-04行24 | ○ |
| C-04 | メールアドレス形式チェック | E-05行25-27 | ○ |
| C-05 | メール形式エラー時はerr_email | E-05行27 | ○ |
| C-06 | セッションにメールアドレス保存 | E-03行20 | ○ |
| C-07 | 件名は"[タイトル] on [URL]" | E-07行45 | ○ |
| C-08 | HTML形式で送信 | E-06行32-38（HTML構造） | ○ |
| C-09 | pagetoemailbodyでカスタムテンプレート可能 | E-06行30、40 | ○ |
| C-10 | デフォルトテンプレート構築 | E-06行32-38 | ○ |
| C-11 | css()でサイトCSS適用 | E-06行32 | ○ |
| C-12 | replaceBlocksでブロック置換 | E-07行45-46 | ○ |
| C-13 | cls_mail_messageを使用 | E-07行43（new cls_mail_message） | ○ |
| C-14 | CSRF検証（checkCSRF） | E-03行19 | ○ |
| C-15 | 送信完了後に完了画面表示 | E-08行51 | ○ |
| C-16 | window.close()で閉じる | E-08行51（onClick="...window.close()"） | ○ |
| C-17 | trimでメールアドレス空白除去 | E-03行18（trim(Request.Form)） | ○ |
| C-18 | sApplicationでResponse.End | E-01行11、14 | ○ |
| C-19 | ポップアップウィンドウ表示 | E-01行13（window.focus()） | ○ |
| C-20 | mailSentフラグで状態管理 | E-02行15、49 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **1: 中リスク** - 機密情報を含むページの共有リスク

## 6) レビュアーチェックリスト（最小）
- [ ] CAPTCHA実装のセキュリティを確認
- [ ] 機密情報を含むページの共有制限を検討
- [ ] pagetoemailbodyの設定方法を確認
- [ ] replaceBlocks関数の動作を確認（XSSリスク）
- [ ] セッション変数（QS_CMS_email）の有効期限を確認
