---
generated_at: 2026-01-24 00:12:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-プライベートメッセージ送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで裏付けられているため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/fs_mailcontact.asp` 行1-34（プライベートメッセージ処理全体）
- E-02: `asp/fs_mailcontact.asp` 行6（Intranet認証チェック）
- E-03: `asp/fs_mailcontact.asp` 行7（bGetEmailsFromSiteチェック）
- E-04: `asp/fs_mailcontact.asp` 行8-12（CAPTCHA・本文検証）
- E-05: `asp/fs_mailcontact.asp` 行14-29（メール送信処理）
- E-06: `asp/fs_mailcontact.asp` 行24-27（CC送信処理）
- E-07: `asp/fs_mailcontact.asp` 行30（完了画面リダイレクト）
- E-08: `asp/includes/contact.asp` 行438-448（sClickNickNameプロパティ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Intranetユーザー間でプライベートメッセージを送信 | E-01行1-34 | ○ |
| C-02 | Intranet認証チェック | E-02行6（authenticatedIntranet） | ○ |
| C-03 | bGetEmailsFromSite=trueのユーザーのみ送信可能 | E-03行7 | ○ |
| C-04 | 未認証時はResponse.End | E-02行6 | ○ |
| C-05 | bGetEmailsFromSite=false時はResponse.End | E-03行7 | ○ |
| C-06 | CAPTCHA検証を実施 | E-04行9-11 | ○ |
| C-07 | CAPTCHA失敗時はerr_captchaエラー | E-04行11 | ○ |
| C-08 | 本文空チェック | E-04行11-12 | ○ |
| C-09 | 本文空の場合はerr_mandatoryエラー | E-04行12 | ○ |
| C-10 | cls_mail_messageを使用 | E-05行15（new cls_mail_message） | ○ |
| C-11 | 宛先は選択されたユーザーのsEmail | E-05行16 | ○ |
| C-12 | 送信元は送信者のsEmail | E-05行20-21 | ○ |
| C-13 | 件名は「Private message from [ニックネーム] ([URL])」 | E-05行18 | ○ |
| C-14 | 本文はlinkURLS関数でURL自動リンク化 | E-05行19 | ○ |
| C-15 | CC設定がtrueの場合は送信者にもCC送信 | E-06行24-27 | ○ |
| C-16 | 送信完了後はfb_mailsentメッセージ表示 | E-07行30 | ○ |
| C-17 | ポップアップウィンドウとして表示 | E-08行443（bPopupFullWidthNoReload） | ○ |
| C-18 | ニックネームリンクからポップアップ起動 | E-08行442-443 | ○ |
| C-19 | Reply-Toが送信者メールアドレスに設定 | E-05行20-21 | ○ |
| C-20 | HTML形式でメール送信 | E-05行19（HTMLボディ設定） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで確認できたため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで検証済み
- **1: 中リスク** - linkURLS関数によるURL自動リンク化のXSSリスク

## 6) レビュアーチェックリスト（最小）
- [ ] Intranet認証のセキュリティを確認
- [ ] bGetEmailsFromSiteフラグの設定方法を確認
- [ ] linkURLS関数のXSS対策を確認
- [ ] CAPTCHA実装の有効性を確認
- [ ] 送信元（From/Reply-To）のなりすましリスクを評価
