---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 48
  claims_with_evidence: 42
  claims_without_evidence: 6
confidence_derived: 0.88
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：42 / 48、根拠なし：6
- 優先レビュー（高）
  1. **パスワードリセット手順**：業務要件で言及があるが、具体的な運用フローは未確認
  2. **エラーメッセージ一覧**：一部のエラーメッセージのみ確認、網羅性に課題
  3. **統計リセット機能の詳細**：画面設計書に記載あるが詳細手順は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要、技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 全200画面の定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 全120機能の定義
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 52件の業務要件
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移の定義
- E-07: `docs/code-to-docs/画面設計書/1-バックサイトログイン画面.md` - ログイン画面仕様
- E-08: `docs/code-to-docs/画面設計書/5-バックサイトホーム.md` - ホーム画面仕様
- E-09: `docs/code-to-docs/画面設計書/23-フォーム一覧.md` - フォーム一覧仕様
- E-10: `docs/code-to-docs/画面設計書/42-ニュースレター一覧.md` - ニュースレター仕様
- E-11: `docs/code-to-docs/画面設計書/52-連絡先ホーム.md` - 連絡先管理仕様
- E-12: `docs/code-to-docs/画面設計書/71-テンプレート一覧.md` - テンプレート管理仕様

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuickerSiteはWindows Server（IIS）向けCMSである | E-01, E-06 | ○ |
| C-02 | ASP/VBScriptで実装されている | E-01 | ○ |
| C-03 | ログイン画面でパスワードとCAPTCHA認証を使用 | E-07 | ○ |
| C-04 | ログイン試行回数に制限がある | E-07, E-04 (BR-001) | ○ |
| C-05 | CAPTCHA認証は大文字・小文字を区別しない | E-07 | ○ |
| C-06 | デフォルトパスワードは"admin" | E-07 | ○ |
| C-07 | バックサイトホームでページツリー表示される | E-08 | ○ |
| C-08 | ページタイプは4種類（Content Item, List Page, Container, External URL） | E-02, E-08 | ○ |
| C-09 | フォーム一覧から送信データ確認・Excel出力が可能 | E-09 | ○ |
| C-10 | フォームにCAPTCHA機能がある | E-04 (BR-042) | ○ |
| C-11 | ニュースレターの作成・配信機能がある | E-10, E-04 (BR-019-021) | ○ |
| C-12 | 購読者のCSVインポートが可能 | E-10, E-04 (BR-020) | ○ |
| C-13 | 連絡先にステータス（権限レベル）がある | E-11 | ○ |
| C-14 | 会員ステータスは5段階 | E-11 | ○ |
| C-15 | テンプレート一覧から編集・複製・削除が可能 | E-12 | ○ |
| C-16 | デフォルトテンプレートの設定機能がある | E-12, E-03 (機能No.30) | ○ |
| C-17 | ZIPファイルからテンプレートインポート可能 | E-12, E-03 (機能No.28) | ○ |
| C-18 | ギャラリー機能がある | E-02, E-03 (機能No.56-58) | ○ |
| C-19 | カタログ機能がある | E-02, E-03 (機能No.45-52) | ○ |
| C-20 | ゲストブック機能がある | E-02, E-03 (機能No.61-64) | ○ |
| C-21 | 投票（Poll）機能がある | E-02, E-03 (機能No.59-60) | ○ |
| C-22 | アクセス統計機能がある | E-03 (機能No.91-93), E-04 (BR-033) | ○ |
| C-23 | リファラー追跡機能がある | E-02, E-03 (機能No.92) | ○ |
| C-24 | セカンド管理者機能がある | E-04 (BR-004), E-07 | ○ |
| C-25 | 権限による表示制御がある | E-07, E-08, E-09, E-10, E-11, E-12 | ○ |
| C-26 | CSRF対策が実装されている | E-04 (BR-043), E-05 | ○ |
| C-27 | CKEditorをWYSIWYGエディタとして使用 | E-01 | ○ |
| C-28 | アセットマネージャー機能がある | E-03 (機能No.37-38) | ○ |
| C-29 | 複数ファイルの一括アップロードが可能 | E-03 (機能No.38), E-02 | ○ |
| C-30 | ページパスワード保護機能がある | E-04 (BR-002, BR-040) | ○ |
| C-31 | サイトマップ自動生成機能がある | E-01, E-03 (機能No.115) | ○ |
| C-32 | RSSフィード機能がある | E-01, E-03 (機能No.114) | ○ |
| C-33 | 多言語対応がある | E-01, E-03 (機能No.120), E-04 (BR-047) | ○ |
| C-34 | Cookie警告機能がある（GDPR対応） | E-01, E-03 (機能No.34), E-04 (BR-037) | ○ |
| C-35 | ショッピングカート機能がある | E-01, E-03 (機能No.77-81), E-04 (BR-044) | ○ |
| C-36 | 予約カレンダー機能がある | E-03 (機能No.74-76), E-04 (BR-030) | ○ |
| C-37 | フォーラム/掲示板機能がある | E-03 (機能No.89-90), E-04 (BR-023-024) | ○ |
| C-38 | メール送信機能がある | E-03 (機能No.86-87), E-04 (BR-031-032) | ○ |
| C-39 | 管理者ダッシュボードで顧客サイト一覧を表示 | E-02, E-06 | ○ |
| C-40 | テンプレートのプレビュー機能がある | E-12 | ○ |
| C-41 | ニュースレター複製機能がある | E-10 | ○ |
| C-42 | フォーム複製機能がある | E-09 | ○ |
| C-43 | パスワードリセット手順がある | E-04 (BR-041) | △ |
| C-44 | エラーメッセージ一覧が網羅的 | E-07（一部のみ） | △ |
| C-45 | 統計リセット機能の詳細手順 | E-03 (機能No.93) | △ |
| C-46 | サポート連絡先情報 | **根拠なし** | △ |
| C-47 | 具体的なファイルサイズ上限値 | **根拠なし** | △ |
| C-48 | 具体的なセッションタイムアウト時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パスワードリセット機能の具体的なUI・操作手順**
  - 業務要件BR-041で暗号化機能については言及があるが、パスワードリセット用の管理画面は画面一覧に明示的に含まれていない
  - 候補：process_forgotPW.asp / サイト管理者への直接依頼

- **エラーメッセージの完全一覧**
  - 各画面設計書に記載されているエラーメッセージは確認できたが、システム全体のエラーメッセージマスターは存在しない
  - 候補：messages.asp / 各画面設計書のメッセージ仕様セクション

- **サポート連絡先情報**
  - 運用マニュアルで「システム管理者に連絡」と記載しているが、具体的な連絡先は環境依存
  - 候補：サイト運用者による設定 / インストール時の設定

- **ファイルサイズ上限・セッションタイムアウト**
  - これらはサーバー設定（IIS設定、web.config）に依存するため、コードからは特定不可
  - 候補：web.config / IIS管理者設定

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|-------------|------|------|
| 0（低リスク） | 基本操作手順 | 画面設計書に基づき正確に記載 |
| 0（低リスク） | 機能一覧 | 機能一覧CSVとの整合性確認済み |
| 1（中リスク） | パスワードリセット | 具体的な手順の根拠が不足 |
| 1（中リスク） | エラー対処法 | 一部のエラーのみカバー |
| 0（低リスク） | 業務フロー | 業務要件一覧に基づき構成 |
| 0（低リスク） | 権限制御 | 複数の画面設計書で確認済み |

## 6) レビュアーチェックリスト（最小）

- [ ] ログイン手順が実際のシステムと一致するか確認
- [ ] 各機能のメニュー位置が正確か確認
- [ ] 権限による表示制御の記載が正確か確認
- [ ] エラーメッセージの記載漏れがないか確認
- [ ] スクリーンショットの追加が必要か検討
- [ ] サポート連絡先情報を環境に応じて追記
- [ ] ファイルサイズ上限等の環境依存設定を追記
- [ ] 日常業務の流れが実際の運用と合致するか確認
