# QuickerSite CMS 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】コンテンツ配信機能（ページ・ニュースレターの作成・配信）](#4-step1コンテンツ配信機能ページニュースレターの作成配信)
5. [【STEP2-3】フォーム管理機能（問い合わせ・アンケートの受付）](#5-step2-3フォーム管理機能問い合わせアンケートの受付)
6. [【STEP3-4】メディア管理機能（ファイル・画像の共有）](#6-step3-4メディア管理機能ファイル画像の共有)
7. [【STEP4-5】データ管理・処理完了（管理者向け）](#7-step4-5データ管理処理完了管理者向け)

**【サポート機能】**
8. [ギャラリー・カタログ機能](#8-ギャラリーカタログ機能)
9. [テンプレート管理機能](#9-テンプレート管理機能)
10. [統計・分析機能](#10-統計分析機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 QuickerSite CMSとは

QuickerSiteは、Windows Server（IIS）向けに構築されたオールインワンのCMS（コンテンツ管理システム）です。ASP/VBScriptで実装されており、Webサイトのページ作成・編集・公開、フォーム管理、ニュースレター配信、画像ギャラリー、カタログ管理など、Webサイト運営に必要な機能を包括的に提供します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ページ管理** | ページの作成・編集・削除、階層構造の管理、公開/非公開設定 |
| **コンテンツ配信** | ニュースレターの作成・配信、購読者管理、配信履歴確認 |
| **フォーム管理** | 問い合わせフォームの作成、送信データの確認・エクスポート |
| **メディア管理** | 画像・ファイルのアップロード、ギャラリー作成、カタログ管理 |
| **テンプレート管理** | サイトデザインの変更、テンプレートの作成・編集 |
| **ユーザー管理** | 会員情報の管理、アクセス権限の設定 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】管理者がコンテンツ（ページ・ニュースレター）を作成・配信   │
│      ↓                                                          │
│  【STEP 2】訪問者がサイトを閲覧し、フォームから問い合わせ           │
│      ↓                                                          │
│  【STEP 3】訪問者がファイルをダウンロード、またはフォーム送信       │
│      ↓                                                          │
│  【STEP 4】管理者が送信データを確認・処理                         │
│      ↓                                                          │
│  【STEP 5】必要に応じて回答、または次のコンテンツ作成へ             │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **サイト管理者** | ページ作成・編集、ニュースレター配信、フォーム管理、テンプレート変更、統計確認 |
| **システム管理者（Admin）** | 顧客サイトの一括管理、システム設定、アップグレード |
| **セカンド管理者** | 制限された権限での管理作業（権限に応じた機能のみ利用可能） |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| ページ管理 | Webページの作成・編集・削除・階層管理 | STEP 1 |
| ニュースレター | メールマガジンの作成・配信・購読者管理 | STEP 1 |
| フォーム管理 | 問い合わせフォームの作成・データ管理 | STEP 2-3 |
| ギャラリー | 画像ギャラリーの作成・管理 | STEP 1, 3 |
| カタログ | 商品・サービスカタログの管理 | STEP 1, 3 |
| テンプレート | サイトデザインテンプレートの管理 | 随時 |
| 統計 | アクセス統計の確認 | 随時 |
| 連絡先管理 | 会員情報の管理・一括メール送信 | STEP 4-5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| サイト管理者 | サイト全体の管理権限を持つユーザー。全機能にアクセス可能 |
| システム管理者（Admin） | 複数の顧客サイトを管理するスーパーユーザー |
| セカンド管理者 | 制限された権限を持つサブ管理者。機能ごとにアクセス権限を設定可能 |
| イントラネットユーザー | 会員制エリアにアクセスできる登録ユーザー |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでQuickerSiteのバックサイト（管理画面）ログインページにアクセスします
   - URL：`https://[サイトURL]/backsite/` または `https://[サイトURL]/asp/bs_login.asp`

2. ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| パスワード | サイト管理者パスワード（最大50文字） |
| CAPTCHA | 画像に表示された文字列（4文字） |

3. 「ログイン」ボタンをクリックします

4. 認証に成功すると、バックサイトホーム（ページ一覧画面）が表示されます

**注意事項：**
- ログイン試行回数には制限があります。複数回失敗すると一時的にアクセスがブロックされます
- CAPTCHA認証は大文字・小文字を区別しません
- デフォルトパスワード（"admin"）を使用している場合は、初回ログイン時に強制的にパスワード変更画面に遷移します

### 2.2 システム管理者（Admin）としてのログイン

システム管理者（Admin）は別のログイン画面を使用します：

1. URL：`https://[サイトURL]/asp/ad_login.asp` にアクセス
2. パスワードとCAPTCHAを入力
3. 「ログイン」ボタンをクリック
4. 管理者ダッシュボード（顧客サイト一覧）が表示されます

### 2.3 ログアウト方法

1. 画面右上のメニューまたはヘッダー部分にある「Logoff」リンクをクリックします
2. ログオフ処理が実行され、ログイン画面に戻ります
3. セッションが終了し、セキュリティが確保されます

### 2.4 パスワードを忘れた場合

パスワードを忘れた場合は、システム管理者に連絡してパスワードのリセットを依頼してください。セキュリティ上、自動リセット機能は提供されていません。

---

## 3. トップページ（TOP画面）

### 3.1 サイト管理者向けTOP画面（バックサイトホーム）

ログイン後に表示されるバックサイトホーム画面では、以下の機能を利用できます：

**ナビゲーションメニュー：**

| メニュー | 説明 |
|---------|------|
| Pages（ページ一覧） | サイトのページ管理画面（現在表示中） |
| New page（新規ページ） | 新しいページを作成する |
| Constants（定数） | サイト変数・定数の管理 |
| ASP/VBScripts | カスタムスクリプトの管理（権限がある場合のみ表示） |
| Search（検索） | バックサイト内のコンテンツ検索 |
| Validations（検証） | HTML検証待ちページの確認（該当ページがある場合のみ表示） |

**ページツリー表示：**
- サイト内のページが階層構造（ツリー形式）で表示されます
- ページタイトルをクリックすると編集画面に遷移します
- 各ページの右側にあるアイコンで以下の操作が可能です：
  - **移動アイコン**：ページの階層位置を変更
  - **コピーアイコン**：ページを複製
  - **パスワードアイコン**：ページにパスワード保護を設定

**フリーページ一覧：**
- メニューに属さない独立したページ（フリーページ）が下部に一覧表示されます

### 3.2 システム管理者向けTOP画面（管理者ダッシュボード）

システム管理者としてログインした場合は、管理者ダッシュボードが表示されます：

**表示内容：**
- 登録済み顧客サイトの一覧
- 各サイトの統計情報概要
- システム全体の設定メニュー

**主な機能：**
- 顧客サイトの管理・編集
- 新規サイトの作成
- システムアップグレード
- 多言語ラベルの管理

---

## 4. 【STEP1】コンテンツ配信機能（ページ・ニュースレターの作成・配信）

> **業務フローでの位置**: 管理者がサイト訪問者に向けてコンテンツを作成・配信するステップです。

### 4.1 新規ページを作成する

1. バックサイトホーム画面で「New page」リンクをクリックします
2. ページ作成画面が表示されます

**ページタイプの選択：**

| ページタイプ | 説明 |
|-------------|------|
| Content Item | 通常のコンテンツページ（WYSIWYGエディタで編集） |
| List Page | リスト形式のページ（ブログ・ニュース一覧など） |
| Container | 子ページを持つコンテナページ |
| External URL | 外部サイトへのリダイレクト |

3. ページタイプを選択し、必要な情報を入力します
4. 「保存」ボタンをクリックしてページを作成します

### 4.2 ページを編集する

1. バックサイトホームのページツリーから編集したいページをクリックします
2. 編集画面が表示されます
3. WYSIWYGエディタ（CKEditor）でコンテンツを編集します
4. 「保存」ボタンをクリックして変更を保存します

**編集画面の主な機能：**
- テキストの書式設定（太字、斜体、下線など）
- 画像・ファイルの挿入（アセットマネージャー経由）
- リンクの挿入
- テーブルの作成
- HTMLソースの直接編集

### 4.3 ニュースレターを作成・配信する

**ニュースレター一覧へのアクセス：**
1. ヘッダーメニューから「Newsletter」をクリックします
2. ニュースレター一覧画面が表示されます

**新規ニュースレターの作成：**
1. 「New Newsletter」ボタンをクリックします
2. ニュースレター編集画面で以下を入力します：
   - ニュースレター名
   - 件名
   - 送信元メールアドレス・名前
   - 本文（HTMLエディタで編集）
3. 「保存」ボタンをクリックします

**ニュースレターの配信：**
1. 「New Mailing」ボタンをクリックします
2. 配信メール作成画面で以下を設定します：
   - 配信するニュースレターテンプレートを選択
   - 配信対象の購読者リストを選択
3. プレビューで内容を確認します
4. 「送信」ボタンをクリックして配信を実行します

**購読者の管理：**
1. 「Subscribers」ボタンをクリックします
2. 購読者一覧画面で以下の操作が可能です：
   - 購読者の追加・編集・削除
   - CSVファイルからの一括インポート
   - 購読者のカテゴリ分け

### 4.4 配信履歴の確認

1. ニュースレター一覧画面で「Mailing History」ボタンをクリックします
2. 過去の配信履歴が一覧表示されます
3. 各配信の詳細（送信日時、送信先数など）を確認できます

---

## 5. 【STEP2-3】フォーム管理機能（問い合わせ・アンケートの受付）

> **業務フローでの位置**: サイト訪問者からの問い合わせやアンケート回答を受け付け、データを管理するステップです。

### 5.1 フォーム一覧を確認する

1. ヘッダーメニューから「Forms」をクリックします
2. 登録済みフォームの一覧が表示されます

**一覧画面で利用できる機能：**

| アイコン/リンク | 機能 |
|----------------|------|
| フォーム名 | フォーム編集画面へ遷移 |
| コンテナアイコン | フォームフィールド設定画面へ遷移 |
| 虫眼鏡アイコン | フォームのプレビュー表示 |
| テーブルアイコン | 送信データの表示 |
| Excelアイコン | 送信データのExcelエクスポート |
| コピーアイコン | フォームの複製 |

### 5.2 新規フォームを作成する

1. フォーム一覧画面で「新規フォーム」リンクをクリックします
2. フォーム編集画面で以下を設定します：
   - フォーム名
   - 送信先メールアドレス
   - 自動応答メールの設定
   - 送信完了後のリダイレクト先
3. 「保存」ボタンをクリックします

### 5.3 フォームフィールドを設定する

1. フォーム一覧からコンテナアイコンをクリックします
2. フォームフィールド一覧画面が表示されます
3. 「新規フィールド」をクリックして入力項目を追加します

**設定可能なフィールドタイプ：**
- テキスト入力
- テキストエリア（複数行）
- セレクトボックス
- ラジオボタン
- チェックボックス
- 日付入力
- ファイルアップロード
- 必須項目の設定

### 5.4 送信データを確認・エクスポートする

**送信データの確認：**
1. フォーム一覧画面でテーブルアイコンをクリックします
2. 送信データ一覧がポップアップ表示されます
3. 各送信データの詳細を確認できます

**Excelエクスポート：**
1. フォーム一覧画面でExcelアイコンをクリックします
2. 新しいウィンドウでExcel形式のファイルがダウンロードされます
3. ダウンロードしたファイルをExcelで開いてデータを分析できます

---

## 6. 【STEP3-4】メディア管理機能（ファイル・画像の共有）

> **業務フローでの位置**: サイトで使用する画像やファイルをアップロード・管理するステップです。

### 6.1 アセットマネージャーを使用する

アセットマネージャーは、サイト内で使用するファイル（画像、ドキュメントなど）を管理するためのツールです。

**アクセス方法：**
1. ページ編集画面のWYSIWYGエディタで「画像挿入」または「リンク挿入」ボタンをクリックします
2. アセットマネージャーがポップアップ表示されます

**主な機能：**
- フォルダの作成・削除
- ファイルのアップロード（単一・複数）
- ファイルの選択・挿入
- 画像のプレビュー表示

### 6.2 ファイルをアップロードする

1. アセットマネージャーで目的のフォルダに移動します
2. 「アップロード」ボタンをクリックします
3. アップロードするファイルを選択します
4. アップロードが完了すると、ファイル一覧に表示されます

**複数ファイルの一括アップロード：**
1. 「マルチファイルアップロード」機能を使用します
2. ドラッグ＆ドロップまたはファイル選択で複数ファイルを指定します
3. 一括でアップロードが実行されます

### 6.3 画像ギャラリーを作成する

ギャラリー機能については、後述の「8. ギャラリー・カタログ機能」を参照してください。

---

## 7. 【STEP4-5】データ管理・処理完了（管理者向け）

> **業務フローでの位置**: 管理者がサイト訪問者からのデータを確認・処理し、必要に応じて対応するステップです。

### 7.1 連絡先（会員）を管理する

**連絡先ホーム画面へのアクセス：**
1. ヘッダーメニューから「Intranet」→「Contacts」を選択します
2. 連絡先ホーム画面が表示されます

**会員の検索：**
1. 検索フォームで条件を入力します：
   - カスタムフィールドによる検索
   - メールアドレス検索
   - ニックネーム検索
   - ステータス（権限レベル）による絞り込み
2. 「検索」ボタンをクリックします
3. 条件に合致する会員が一覧表示されます

**会員ステータスの種類：**

| ステータス | 説明 |
|-----------|------|
| Silent | アクセス制限あり |
| Profile | プロフィール閲覧のみ |
| Read | 読み取り専用 |
| Write | 書き込み可能 |
| Read/Write | 読み書き可能（フル権限） |

### 7.2 会員への一括メール送信

1. 連絡先ホーム画面で対象の会員をチェックボックスで選択します
2. 「選択した連絡先にメール送信」リンクをクリックします
3. 確認ダイアログで「OK」をクリックします
4. 一括メール送信画面でメール内容を入力します
5. 「送信」ボタンをクリックして配信します

### 7.3 ゲストブック投稿の管理

**ゲストブック一覧へのアクセス：**
1. ヘッダーメニューから「Guestbook」をクリックします
2. ゲストブック一覧が表示されます

**投稿の承認・管理：**
1. ゲストブック一覧から対象のゲストブックを選択します
2. 「エントリー管理」アイコンをクリックします
3. 投稿一覧で以下の操作が可能です：
   - 投稿の承認/非承認
   - 投稿の編集
   - 投稿の削除
   - 投稿への返信

---

## 8. ギャラリー・カタログ機能

### 8.1 ギャラリーを作成・管理する

**ギャラリー一覧へのアクセス：**
1. ヘッダーメニューから「Gallery」をクリックします
2. ギャラリー一覧画面が表示されます

**新規ギャラリーの作成：**
1. 「新規ギャラリー」リンクをクリックします
2. ギャラリー編集画面で以下を設定します：
   - ギャラリー名
   - 表示形式（スライドショー、サムネイル一覧など）
   - 画像のアップロード
3. 「保存」ボタンをクリックします

**ギャラリーのプレビュー：**
1. ギャラリー一覧画面でプレビューアイコンをクリックします
2. ギャラリーの表示状態を確認できます

### 8.2 カタログを作成・管理する

**カタログ一覧へのアクセス：**
1. ヘッダーメニューから「Catalog」をクリックします
2. カタログ一覧画面が表示されます

**新規カタログの作成：**
1. 「新規カタログ」リンクをクリックします
2. カタログ編集画面で基本設定を入力します
3. 「保存」ボタンをクリックします

**カタログフィールドの設定：**
1. カタログ一覧からフィールド設定アイコンをクリックします
2. カタログアイテムの属性（フィールド）を定義します

**カタログアイテムの追加：**
1. カタログ編集画面で「アイテム追加」をクリックします
2. 各フィールドに値を入力します
3. 画像やファイルを添付します
4. 「保存」ボタンをクリックします

---

## 9. テンプレート管理機能

### 9.1 テンプレート一覧を確認する

1. ヘッダーメニューから「Setup」→「Template」を選択します
2. テンプレート一覧画面が表示されます

**一覧画面で確認できる情報：**
- テンプレート名
- デフォルトテンプレートの表示（"(default)"と表示）
- 各テンプレートの操作アイコン

### 9.2 テンプレートを編集する

1. テンプレート一覧でテンプレート名または編集アイコンをクリックします
2. テンプレート編集画面が表示されます
3. HTML/CSSを編集します（CodeMirrorエディタ使用）
4. 「保存」ボタンをクリックします

**編集可能な項目：**
- テンプレート名
- HTMLテンプレート本体
- 印刷用テンプレート
- メール用テンプレート
- モバイル用テンプレート

### 9.3 デフォルトテンプレートを設定する

1. テンプレート一覧で、デフォルトにしたいテンプレートの「set as default」リンクをクリックします
2. そのテンプレートがサイト全体のデフォルトとして設定されます
3. 個別のページでテンプレートが指定されていない場合、このデフォルトテンプレートが適用されます

### 9.4 テンプレートを複製・削除する

**テンプレートの複製：**
1. コピーアイコンをクリックします
2. 確認ダイアログで「OK」をクリックします
3. "Copy of [テンプレート名]"という名前で複製されます

**テンプレートの削除：**
1. 削除アイコンをクリックします（デフォルトテンプレートには表示されません）
2. 確認ダイアログで「OK」をクリックします
3. テンプレートが削除されます

**注意事項：**
- テンプレートが1件しかない場合、削除はできません
- デフォルトテンプレートは削除できません

### 9.5 テンプレートをインポートする

**ZIPファイルからのインポート：**
1. 「Upload ZIP」リンクをクリックします
2. ZIPファイルをアップロードします
3. 解凍後、テンプレートが登録されます

**オンラインテンプレート検索：**
1. 「Browse online templates」リンクをクリックします
2. オンラインギャラリーからテンプレートを検索します
3. 目的のテンプレートをインストールします

---

## 10. 統計・分析機能

### 10.1 アクセス統計を確認する

1. ヘッダーメニューから「Stats」をクリックします
2. 統計画面が表示されます

**確認できる統計情報：**
- ページ別のヒット数
- ページ別の訪問者数
- 期間別のアクセス推移

### 10.2 リファラー（参照元）を確認する

1. 統計画面で「Referers」タブをクリックします
2. 外部サイトからの流入元一覧が表示されます
3. どのサイトから訪問者が来ているかを分析できます

### 10.3 統計のリセット

1. 統計画面で「Reset Stats」ボタンをクリックします
2. 確認ダイアログで「OK」をクリックします
3. 統計データがリセットされます

**注意事項：**
- リセットした統計データは復元できません
- 必要に応じて、リセット前にデータをエクスポートしてください

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】コンテンツの作成・配信 → 4章参照
    ↓
【STEP 2】フォームからの問い合わせ受付 → 5章参照
    ↓
【STEP 3】ファイル・画像の共有 → 6章参照
    ↓
【STEP 4】送信データの確認・処理 → 7章参照
    ↓
【STEP 5】必要に応じた対応・次のコンテンツ作成 → 4章, 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【管理者】STEP1: コンテンツの作成・配信

業務開始時に、新しいコンテンツを作成・公開します。

**日常業務の例：**

1. **ニュース記事の追加**
   - バックサイトホームで「New page」をクリック
   - リストページを選択してニュース記事を追加
   - 公開設定を確認して保存

2. **ニュースレターの配信**
   - 「Newsletter」メニューから「New Mailing」をクリック
   - 配信内容を作成し、購読者に配信

### 11.2 【管理者】STEP2: フォーム問い合わせの確認

サイト訪問者からの問い合わせを確認します。

**日常業務の例：**

1. **問い合わせデータの確認**
   - 「Forms」メニューからフォーム一覧を開く
   - テーブルアイコンをクリックして送信データを確認
   - 必要に応じてExcelにエクスポート

2. **問い合わせへの対応**
   - 送信者のメールアドレスを確認
   - 個別にメールで回答（システム外で対応）

### 11.3 【管理者】STEP3: ファイル・メディアの管理

サイトで使用するファイルを管理します。

**日常業務の例：**

1. **新しい画像のアップロード**
   - ページ編集画面からアセットマネージャーを開く
   - 適切なフォルダに画像をアップロード
   - ページに画像を挿入

2. **ギャラリーの更新**
   - 「Gallery」メニューから対象のギャラリーを選択
   - 新しい画像を追加・古い画像を削除

### 11.4 【管理者】STEP4-5: データ管理と対応完了

会員情報の管理や、業務処理の完了作業を行います。

**日常業務の例：**

1. **会員情報の更新**
   - 「Intranet」→「Contacts」から連絡先ホームを開く
   - 対象の会員を検索・編集
   - 必要に応じて一括メール送信

2. **ゲストブックの管理**
   - 新しい投稿を承認
   - スパム投稿を削除
   - 必要に応じて返信

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
1. パスワードが正しいか確認（大文字・小文字を区別）
2. CAPTCHAを正しく入力しているか確認
3. ログイン試行回数の上限に達していないか確認（しばらく待ってから再試行）
4. ブラウザのCookieが有効になっているか確認

**Q: パスワードを変更したい**

A: バックサイトの設定メニューからパスワード変更画面にアクセスして変更できます。

### 12.2 ページ管理に関するQ&A

**Q: ページが公開されません**

A: 以下を確認してください：
1. ページの「オンライン」設定がONになっているか
2. 公開日時が正しく設定されているか
3. ページにパスワード保護がかかっていないか

**Q: ページを削除してしまった**

A: 一度削除したページは復元できません。重要なページは削除前にバックアップを取ることをお勧めします。

### 12.3 フォームに関するQ&A

**Q: フォームの送信データが届かない**

A: 以下を確認してください：
1. フォームの送信先メールアドレスが正しいか
2. サーバーのSMTP設定が正しく行われているか
3. 迷惑メールフォルダに振り分けられていないか

**Q: フォームデータをバックアップしたい**

A: フォーム一覧画面のExcelアイコンからデータをエクスポートし、定期的にバックアップを保存してください。

### 12.4 ニュースレターに関するQ&A

**Q: ニュースレターが配信されません**

A: 以下を確認してください：
1. 購読者リストに登録があるか
2. SMTPサーバーの設定が正しいか
3. 購読者のメールアドレスが有効か

**Q: 購読者を一括で登録したい**

A: 「Subscribers」画面から「Import」機能を使用して、CSVファイルから一括インポートできます。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| CAPTCHA認証エラー | CAPTCHAの入力が画像と一致しない | 画像を確認して正しく入力し直す |
| ログインエラー | パスワードが正しくない | パスワードを確認して再入力 |
| アクセス権限エラー | 必要な権限がない | システム管理者に権限付与を依頼 |
| セッションタイムアウト | 長時間操作がなかった | 再度ログインする |

### 13.2 よくあるトラブルと解決方法

**トラブル: 画像がアップロードできない**

解決方法：
1. ファイルサイズを確認（上限を超えていないか）
2. ファイル形式を確認（対応形式：JPG, PNG, GIF等）
3. アップロード先フォルダの書き込み権限を確認

**トラブル: ページの保存ができない**

解決方法：
1. セッションがタイムアウトしていないか確認
2. 入力内容に禁止文字が含まれていないか確認
3. 一度ログアウトして再ログイン

**トラブル: テンプレートが反映されない**

解決方法：
1. ブラウザのキャッシュをクリア
2. デフォルトテンプレートが正しく設定されているか確認
3. 個別ページのテンプレート設定を確認

### 13.3 サポートへの連絡方法

システムの問題が解決しない場合は、システム管理者に連絡してください。

連絡時に以下の情報をお伝えください：
- 発生した問題の詳細
- エラーメッセージ（表示されている場合）
- 問題が発生した日時
- 操作手順

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-24 | 初版作成 |

---

*本マニュアルは、QuickerSite CMSのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
