---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 31
  claims_without_evidence: 4
confidence_derived: 0.89
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：31 / 35、根拠なし：4
- 優先レビュー（高）
  1. **NFT-SEC-007（SQLインジェクション対策）**：cleanUp関数の実装詳細が未確認
  2. **NFT-SEC-008（XSS対策）**：sanitize関数の実装詳細が未確認
  3. **NFT-PERF-001（レンダリング時間）**：具体的な基準値の根拠なし
  4. **NFT-SCALE-001（マルチサイト対応）**：実運用でのテスト方法の詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/asp/begin.asp` - セッションタイムアウト、スクリプトタイムアウト、ファイル拡張子フィルタリング設定
- E-02: `/asp/bs_security.asp` - 認証処理、権限設定、デフォルトパスワード制御
- E-03: `/asp/config/web_config.asp` - 各種設定パラメータ（DB、メール、管理者設定等）
- E-04: `/asp/includes/logonEdit.asp` - ログイン処理、ブルートフォース対策、セッション管理
- E-05: `/asp/includes/database.asp` - データベース接続、セキュリティ対策（DB名自動変更）
- E-06: `/asp/includes/encryption.asp` - 暗号化/復号化関数
- E-07: `/asp/includes/sha256.asp` - SHA-256ハッシュ関数
- E-08: `/asp/uploader214.asp` - アップロードセキュリティ（IP/セッション検証）
- E-09: `/showThumb.aspx` - 画像サムネイル処理、OutputCache設定
- E-10: `/web.config` - IIS設定、404エラーハンドリング
- E-11: `/asp/bs_stats.asp` - アクセス統計機能
- E-12: `/asp/bs_newsletterMailingSend.asp` - ニュースレター一括送信処理
- E-13: `/css/` - 各種スタイルシート（IE6/7対応、RTL対応等）
- E-14: `/asp/includes/functions.asp` - 汎用関数群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン試行5回でIPブロック | E-03, E-04 | ○ |
| C-02 | セッションタイムアウト30分 | E-01 | ○ |
| C-03 | パスワードSHA-256ハッシュ化 | E-07 | ○ |
| C-04 | Cookie認証モードの実装 | E-02, E-04 | ○ |
| C-05 | 危険拡張子のブロック | E-01 | ○ |
| C-06 | アップロード時IP/セッション検証 | E-08 | ○ |
| C-07 | SQLインジェクション対策 | E-14 | △ |
| C-08 | XSS対策 | E-14 | △ |
| C-09 | 管理者権限分離（secondAdmin） | E-02 | ○ |
| C-10 | デフォルトパスワード変更強制 | E-02 | ○ |
| C-11 | DBファイル名自動変更 | E-05 | ○ |
| C-12 | encrypt/decrypt関数実装 | E-06 | ○ |
| C-13 | ページレンダリング時間計測 | E-01 | ○ |
| C-14 | スクリプトタイムアウト800秒 | E-01 | ○ |
| C-15 | キャッシュ無効化ヘッダー | E-01 | ○ |
| C-16 | 画像キャッシュ900秒 | E-09 | ○ |
| C-17 | ニュースレター一括送信 | E-12 | ○ |
| C-18 | 大量コンタクト処理（250件） | E-03 | ○ |
| C-19 | エラーメール通知 | E-03 | ○ |
| C-20 | オフラインモード（C_DEV） | E-01 | ○ |
| C-21 | カスタム404エラー | E-10 | ○ |
| C-22 | IE6/IE7互換CSS | E-13 | ○ |
| C-23 | RTL言語対応CSS | E-13 | ○ |
| C-24 | 複数DB対応（Access/SQL Server/MySQL） | E-05, E-03 | ○ |
| C-25 | 複数メールコンポーネント対応 | E-03 | ○ |
| C-26 | UTF-8エンコーディング | E-01 | ○ |
| C-27 | アクセス統計記録 | E-11 | ○ |
| C-28 | 仮想ディレクトリ設定 | E-03 | ○ |
| C-29 | 統計リセット機能 | E-11 | ○ |
| C-30 | 複数サイト対応（iCustomerID） | E-03 | ○ |
| C-31 | 画像リサイズ上限2560px | E-09 | ○ |
| C-32 | WYSIWYGエディタ設定 | E-01 | ○ |
| C-33 | 多言語ラベル対応 | E-14 | ○ |
| C-34 | イントラネット認証 | E-04 | ○ |
| C-35 | パスワードリセット機能 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- **cleanUp関数の詳細実装**: SQLインジェクション対策の具体的なエスケープ処理内容が未確認
  - 候補：`/asp/includes/functions.asp` の詳細確認 / セキュリティテストの実施
- **sanitize関数の詳細実装**: XSS対策の具体的な無害化処理内容が未確認
  - 候補：`/asp/includes/functions.asp` の詳細確認 / セキュリティテストの実施
- **レンダリング時間基準値**: 3000msという基準の根拠となるSLA文書等が不在
  - 候補：要件定義書 / 性能要件書 / ユーザー調査結果
- **マルチサイト運用テスト方法**: 複数サイト同時運用時の具体的なテスト手順が不明
  - 候補：運用手順書 / テスト計画書

## 5) リスクフラグ（レビュー観点）
- **高リスク（2）**: セキュリティ関連テストケース（NFT-SEC-007, NFT-SEC-008）
  - SQLインジェクション/XSS対策の実装詳細を確認し、ペネトレーションテストの実施を推奨
- **中リスク（1）**: パフォーマンス基準値（NFT-PERF-001）
  - 3000msの基準値が適切かどうか、実運用環境でのベースライン測定が必要
- **低リスク（0）**: その他のテストケース
  - コード内に明確な根拠があり、テスト実施可能

## 6) レビュアーチェックリスト（最小）
- [ ] cleanUp関数の実装を確認し、SQLインジェクション対策が十分か検証
- [ ] sanitize関数の実装を確認し、XSS対策が十分か検証
- [ ] レンダリング時間3000msの基準値が要件として妥当か確認
- [ ] セキュリティテストケースの優先度「高」が適切か確認
- [ ] データベース接続設定のセキュリティ（接続文字列の保護等）を確認
- [ ] ファイルアップロード機能の追加セキュリティ要件がないか確認
- [ ] SMTP設定のSSL対応（QSCDO_smtpusessl）が適切に設定されるか確認
