---
generated_at: 2026-01-24 00:10:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **同時接続数・秒間リクエスト数**：アプリケーションレベルでの設定が見当たらない
  2. **RTO/RPO目標値**：明示的な設定・ドキュメントが存在しない
  3. **稼働率目標**：明示的な目標設定が存在しない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/begin.asp` - 基本設定（セッション、タイムアウト、キャッシュ制御）
- E-02: `asp/config/web_config.asp` - システム設定ファイル
- E-03: `asp/includes/sha256.asp` - パスワードハッシュ実装
- E-04: `asp/includes/encryption.asp` - 暗号化/復号化関数
- E-05: `asp/includes/database.asp` - データベース接続管理
- E-06: `asp/includes/logonEdit.asp` - 認証・ログイン管理
- E-07: `asp/includes/functions.asp` - 共通関数（sanitize, checkCSRF等）
- E-08: `asp/ad_login.asp` - 管理者ログイン（CAPTCHA含む）
- E-09: `asp/ad_security.asp` - 管理者セキュリティ
- E-10: `asp/bs_security.asp` - バックサイトセキュリティ
- E-11: `web.config` - IIS設定（404エラーハンドリング）
- E-12: `README.md` - プロジェクト概要・動作環境

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スクリプトタイムアウト800秒 | E-01 (`server.ScriptTimeout = 800`) | ○ |
| C-02 | キャッシュ無効化 | E-01 (`Response.CacheControl = "no-cache"`, `Response.Expires = -1`) | ○ |
| C-03 | レスポンスバッファリング有効 | E-01 (`Response.Buffer = true`) | ○ |
| C-04 | 文字エンコーディングUTF-8 | E-01 (`Response.CharSet = "utf-8"`) | ○ |
| C-05 | セッションタイムアウト30分 | E-01 (`session.Timeout = 30`) | ○ |
| C-06 | クッキーモード有効 | E-01 (`QS_enableCookieMode = true`) | ○ |
| C-07 | 開発モード設定 | E-02 (`C_DEV = false`) | ○ |
| C-08 | パスワードSHA-256ハッシュ化 | E-03 (SHA256関数実装) | ○ |
| C-09 | ログイン試行制限5回 | E-02 (`QS_number_of_allowed_attempts_to_login = 5`) | ○ |
| C-10 | CAPTCHA認証 | E-08 (`session("captcha")`, captcha.asp参照) | ○ |
| C-11 | セッション認証管理 | E-06, E-10 (`Session(cId & "isAUTHENTICATED")`) | ○ |
| C-12 | CSRFトークン実装 | E-07 (`QS_secCodeHidden`, `checkCSRF()`) | ○ |
| C-13 | SQLインジェクション対策 | E-07 (`cleanUp()`関数) | ○ |
| C-14 | XSS対策関数 | E-07 (`RemoveHTML()`, `RemoveJS()`, `filterJS()`) | ○ |
| C-15 | サニタイズ関数 | E-07 (`sanitize()`, `quotRep()`) | ○ |
| C-16 | 拡張子ブロック | E-01 (危険な拡張子のブロックリスト) | ○ |
| C-17 | データベースファイル名ランダム化 | E-05 (`dumpwarning`関数) | ○ |
| C-18 | ID暗号化（ROT13類似） | E-04 (`Encrypt()`, `decrypt()`関数) | ○ |
| C-19 | SMTP SSL対応 | E-02 (`QSCDO_smtpusessl`) | ○ |
| C-20 | Microsoft Accessサポート | E-02, E-05 (`QS_DBS = 1`) | ○ |
| C-21 | SQL Serverサポート | E-02, E-05 (`QS_DBS = 2`) | ○ |
| C-22 | MySQLサポート | E-05 (`QS_DBS = 3`) | ○ |
| C-23 | 複数サイト対応 | E-02 (`Application("QS_CMS_iCustomerID")`) | ○ |
| C-24 | オンラインテンプレート | E-02 (`bBrowseOnlineTemplates = true`) | ○ |
| C-25 | バージョン定数 | E-01 (`C_QS_VERSION = "4.4"`) | ○ |
| C-26 | エラーメール通知 | E-02 (`C_ADMINEMAIL`), E-07 (`dumpError()`) | ○ |
| C-27 | アクセスログ機能 | E-01 (logVisit.asp参照) | ○ |
| C-28 | オフラインモード | E-02 (`C_DEV`), E-01 (C_DEV判定処理) | ○ |
| C-29 | メールコンポーネント複数対応 | E-02 (`C_MAILCOMPONENT`) | ○ |
| C-30 | セカンド管理者機能 | E-06, E-10 (secondAdmin参照) | ○ |
| C-31 | CSRF警告通知 | E-07 (`sendCSRFWarning()`) | ○ |
| C-32 | クッキー有効期限365日 | E-06 (`dateAdd("d",365,date())`) | ○ |
| C-33 | IPアドレスブロック | E-06 (`lockAdmin()`, `lockBSAdmin()`) | ○ |
| C-34 | 言語ラベルDB管理 | E-02 (`C_DATABASE_LABELS`), E-05 | ○ |
| C-35 | アプリケーションリセット機能 | E-07 (`removeApplication()`) | ○ |
| C-36 | ページレンダリング時間計測 | E-01 (`startTimer = timer()`), bs_variables.asp | ○ |
| C-37 | HTMLエンコード使用 | E-08 (`Server.HTMLEncode()`) | ○ |
| C-38 | 404エラーハンドリング | E-11 (`<error statusCode="404">`) | ○ |
| C-39 | IIS 5以上対応 | E-12 (README.md) | ○ |
| C-40 | ASP.NET 2.0必須 | E-12 (README.md) | ○ |
| C-41 | 32bit互換モード必要 | E-12 (README.md) | ○ |
| C-42 | デフォルトパスワード「admin」 | E-12 (README.md) | ○ |
| C-43 | 同時接続数・スループット設定 | **根拠なし** | △ |
| C-44 | RTO/RPO目標値 | **根拠なし** | △ |
| C-45 | 稼働率目標 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **同時接続数・スループット制限**：アプリケーションレベルでの設定が存在しない。IISの設定に依存するため、運用ドキュメントや環境設定書が必要
  - 候補：IIS設定ドキュメント / 運用マニュアル / インフラ設計書
- **RTO/RPO目標値**：明示的なバックアップ・リカバリポリシーのドキュメントが存在しない
  - 候補：バックアップ運用手順書 / 災害復旧計画書
- **稼働率目標（SLA）**：サービスレベル目標の定義ドキュメントが存在しない
  - 候補：SLA定義書 / サービス契約書

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：性能・キャッシュ設定 - コード上で明確に確認可能
- **0（低リスク）**：セッション管理 - 標準的な実装
- **1（中リスク）**：ID暗号化方式 - ROT13類似の単純な文字置換であり、セキュリティ強度に課題あり
- **1（中リスク）**：SQLインジェクション対策 - シングルクォートエスケープのみ。パラメータ化クエリ非使用
- **0（低リスク）**：CSRF対策 - セッショントークンによる標準的な実装
- **1（中リスク）**：データベースファイル保護 - ランダム化機能あるが、初回アクセス依存
- **2（高リスク）**：可用性目標 - RTO/RPO/稼働率の明示的な定義なし

## 6) レビュアーチェックリスト（最小）
- [ ] セッションタイムアウト30分が業務要件に適合しているか確認
- [ ] ログイン試行制限5回が要件を満たしているか確認
- [ ] ID暗号化の脆弱性（単純な文字置換）が許容範囲か評価
- [ ] SQLインジェクション対策（シングルクォートエスケープ）の十分性を評価
- [ ] RTO/RPO要件を別途定義する必要があるか検討
- [ ] 稼働率目標（SLA）を別途定義する必要があるか検討
- [ ] スクリプトタイムアウト800秒が適切か確認（長時間処理の有無）
- [ ] HTTPS強制の要否を検討（コード上では明示的な強制なし）
