# 非機能要件定義書

## 概要

本ドキュメントは、QuickerSite CMS（Content Management System）の非機能要件を定義するものである。QuickerSiteは、ASP/VBScriptで構築されたWindows Server向けCMSであり、IIS 5以上で動作する。本書では、コードベースの分析に基づき、性能、可用性、セキュリティ、拡張性、保守性、運用・監視の各観点から非機能要件を定義する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 画面表示 | 推定値なし | 明示的な設定なし。`[PAGERENDERTIME]`変数でページ描画時間を計測可能 |
| API応答 | 推定値なし | RESTful APIの明示的な実装なし |
| スクリプトタイムアウト | 800秒 | `server.ScriptTimeout = 800`（begin.asp） |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | IISの設定に依存 | アプリケーションレベルでの制限設定なし |
| 秒間リクエスト数 | IISの設定に依存 | アプリケーションレベルでの制限設定なし |
| キャッシュ制御 | キャッシュ無効化 | `Response.CacheControl = "no-cache"`、`Response.Expires = -1` |

### バッファリング

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| レスポンスバッファリング | 有効 | `Response.Buffer = true`（begin.asp） |
| 文字エンコーディング | UTF-8 | `Response.CharSet = "utf-8"` |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 明示的な目標値なし | IISの稼働率に依存 |
| 計画停止時間 | 開発モード設定あり | `C_DEV=false`でオフライン切り替え可能 |
| 障害復旧時間（RTO） | 明示的な目標値なし | データベースバックアップからの復旧が必要 |
| 目標復旧時点（RPO） | 明示的な目標値なし | データベースの定期バックアップ運用に依存 |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッションタイムアウト | 30分 | `session.Timeout = 30`（begin.asp） |
| クッキーモード | 有効 | `QS_enableCookieMode = true` |
| クッキー有効期限 | 365日 | イントラネットログイン時のクッキー保持期間 |

## セキュリティ要件

### 認証・認可

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| パスワードハッシュ化 | SHA-256 | `sha256.asp`で実装。パスワードはハッシュ化して保存 |
| ログイン試行制限 | 5回 | `QS_number_of_allowed_attempts_to_login = 5`。超過時はIPアドレスをブロック |
| CAPTCHA認証 | 有効 | 管理者ログイン時にCAPTCHA検証を実施 |
| セッション認証 | 有効 | `Session(cId & "isAUTHENTICATED")`でセッション管理 |
| セカンド管理者 | サポート | 権限を制限した第二管理者アカウント機能 |

### CSRF対策

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| CSRFトークン | セッションベース | `QS_secCodeHidden`関数でトークンを生成、`checkCSRF()`で検証 |
| トークン検証 | 全POSTリクエスト | 管理画面の重要な操作に対してCSRF検証を実施 |
| 警告通知 | メール通知 | CSRF攻撃検知時に管理者へメール通知（`sendCSRFWarning()`） |

### 入力検証・サニタイズ

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| SQLインジェクション対策 | シングルクォートエスケープ | `cleanUp()`関数で`'`を`''`に置換 |
| XSS対策 | HTMLタグ除去 | `RemoveHTML()`、`RemoveJS()`、`filterJS()`関数で危険なスクリプト除去 |
| サニタイズ | 特殊文字エスケープ | `sanitize()`関数（`quotRep()`のラッパー） |
| HTMLエンコード | 部分的に実装 | `Server.HTMLEncode()`を一部で使用 |

### ファイルアクセス制御

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 拡張子ブロック | 危険な拡張子をブロック | php, exe, jsp, py, js, bat, aspx等のリクエストをブロック（begin.asp） |
| データベースファイル保護 | ファイル名ランダム化 | 初回アクセス時にMDBファイル名を自動変更 |
| アップロード制限 | 拡張子チェック | 許可されたファイル形式のみアップロード可能 |

### 暗号化

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| ID暗号化 | 単純な文字置換暗号 | `Encrypt()`/`decrypt()`関数。13文字シフトのROT13類似方式 |
| パスワード保存 | SHA-256ハッシュ | 管理者パスワードはSHA-256でハッシュ化 |
| SMTP認証 | SSL対応 | `QSCDO_smtpusessl`でSSL有効化可能 |

## 拡張性要件

### データベースサポート

| データベース | サポート状況 | 備考 |
| --- | --- | --- |
| Microsoft Access | サポート | デフォルト設定。32bit互換モードが必要 |
| SQL Server 2000/2005 | サポート | `QS_DBS = 2`で切り替え可能 |
| MySQL | サポート | ODBC経由での接続に対応 |

### マルチサイト対応

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 複数サイト | サポート | 1データベース、1コードベースで複数サイト運用可能 |
| 顧客ID | Application変数 | `Application("QS_CMS_iCustomerID")`でサイトを識別 |

### テンプレートシステム

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| オンラインテンプレート | 有効 | `bBrowseOnlineTemplates = true`で外部テンプレートダウンロード可能 |
| テンプレート変数 | 多数サポート | `[SITENAME]`、`[PAGETITLE]`等の置換変数 |

## 保守性要件

### コード構成

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| モジュール分離 | includeファイル | 60以上のincludeファイルで機能を分離 |
| バージョン管理 | 定数定義 | `C_QS_VERSION = "4.4"` |
| エラーハンドリング | 一部実装 | `On Error Resume Next`で例外処理。メール通知機能あり |

### 多言語対応

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 言語ラベル | データベース管理 | `QuickerLabels.mdb`で言語ラベルを管理 |
| 言語切替 | サポート | `languageList`クラスで言語選択可能 |

### 設定管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 設定ファイル | `web_config.asp` | データベース接続、メール設定等を集約 |
| リブランディング | `rebrand.asp` | 製品名変更等のカスタマイズに対応 |

## 運用・監視要件

### エラー通知

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| エラーメール通知 | 有効 | `C_ADMINEMAIL`設定時、VBScriptエラーをメール通知 |
| エラーレポート | `dumpError()`関数 | セッション情報を含むエラーレポート生成 |

### アクセスログ

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 訪問者ログ | `logVisit.asp` | 訪問者情報のログ記録機能 |
| リファラー追跡 | サポート | 参照元URL追跡機能あり |
| 統計機能 | サポート | `bs_stats.asp`で統計情報表示 |

### メンテナンス

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| オフラインモード | `C_DEV = true` | メンテナンス時にサイトをオフライン化可能 |
| アプリケーションリセット | `removeApplication()` | Application変数のリセット機能 |
| ページキャッシュクリア | `clearPageCache()` | ページキャッシュのクリア機能 |

### メール送信

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| メールコンポーネント | 複数対応 | CDO.Message、Persits.MailSender、JMail等に対応 |
| SMTP設定 | 設定ファイル管理 | サーバー、ポート、認証情報を`web_config.asp`で管理 |
| SSL/TLS | サポート | `QSCDO_smtpusessl`でSSL有効化可能 |

## 備考

### 動作環境

- **Webサーバー**: IIS 5以上（IIS Express対応）
- **ランタイム**: ASP/VBScript
- **必須**: ASP.NET 2.0（サムネイル生成等の機能用）
- **データベース**: Microsoft Access（32bit互換）、SQL Server、MySQL
- **対応エディタ**: CKEditor 4.45（WYSIWYG編集）

### 制限事項

1. **32bit互換モード**: Access使用時、IISアプリケーションプールで32bit互換が必要
2. **フォルダ権限**: IUSRにUserFilesフォルダへの読み書き権限が必要
3. **デフォルトドキュメント**: `default.asp`をデフォルトドキュメントに設定が必要
4. **暗号化強度**: ID暗号化は単純な文字置換であり、セキュリティ強度は低い

### 推奨事項

1. **HTTPSの使用**: 本番環境ではHTTPS通信を推奨
2. **データベースファイル名変更**: デフォルトのMDBファイル名から変更を推奨（自動変更機能あり）
3. **管理者パスワード**: 初期パスワード「admin」から必ず変更すること
4. **エラーメール設定**: `C_ADMINEMAIL`を設定し、エラー通知を有効化することを推奨
