# Redox OS Build System

## 概要

Redox OSのビルドシステムリポジトリです。Redox OSはRust言語で書かれたオープンソースのオペレーティングシステムであり、マイクロカーネルアーキテクチャを採用しています。本リポジトリはRedox OSのイメージをビルドするためのツールチェーン、レシピ、設定ファイルを提供します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ディスクイメージ生成 | harddrive.img や redox-live.iso などのブート可能なディスクイメージを生成 |
| クロスコンパイル | x86_64, aarch64, i586, riscv64gc アーキテクチャ向けのクロスコンパイル環境を提供 |
| レシピ管理 (Cookbook) | パッケージのビルド定義（レシピ）を管理し、依存関係を解決しながらビルド |
| Podman コンテナビルド | 再現性の高いビルド環境をPodmanコンテナで提供 |
| エミュレーション | QEMUやVirtualBoxでのテスト実行をサポート |
| パッケージリポジトリ管理 | pkgar形式のパッケージアーカイブの作成とリポジトリ管理 |
| TUIビルドモニター | 並列ビルドの進捗をTUI（テキストユーザーインターフェース）で表示 |

## 技術スタック

### コア

- 言語: Rust (Edition 2024)
- ツールチェーン: nightly-2025-10-03
- ビルドシステム: Make / Cargo
- コンテナ: Podman
- ファイルシステム: RedoxFS

### 主要ライブラリ

- `pkgar` / `pkgar-core` / `pkgar-keys` - パッケージアーカイブ処理
- `redox_installer` - インストーラーライブラリ
- `redoxer` - Redox開発支援ツール
- `ratatui` - TUI（テキストユーザーインターフェース）
- `termion` - ターミナル制御
- `serde` / `toml` - 設定ファイルのシリアライズ/デシリアライズ
- `blake3` - 高速ハッシュ関数
- `anyhow` - エラーハンドリング
- `globset` / `regex` - パターンマッチング

## ディレクトリ構成

```
redox-master/
├── bin/                    # ヘルパーバイナリ
├── config/                 # ビルド設定ファイル（.toml）
│   ├── aarch64/           # ARM64アーキテクチャ向け設定
│   ├── i586/              # x86 32bit向け設定
│   ├── riscv64gc/         # RISC-V向け設定
│   └── x86_64/            # x86_64向け設定
├── mk/                     # Makefileモジュール
│   ├── config.mk          # 環境変数設定
│   ├── disk.mk            # ディスクイメージ生成
│   ├── fstools.mk         # ファイルシステムツール
│   ├── podman.mk          # Podmanコンテナ設定
│   ├── prefix.mk          # クロスコンパイラ設定
│   ├── qemu.mk            # QEMUエミュレーション
│   ├── repo.mk            # リポジトリ管理
│   └── virtualbox.mk      # VirtualBox設定
├── podman/                 # Podman Containerfile
├── recipes/                # パッケージビルドレシピ
├── scripts/                # ユーティリティスクリプト
├── src/                    # Cookbookライブラリソースコード
│   ├── bin/               # バイナリエントリポイント
│   ├── cook/              # ビルド処理モジュール
│   ├── config.rs          # 設定管理
│   ├── recipe.rs          # レシピ解析
│   └── lib.rs             # ライブラリエントリポイント
├── rust/                   # Rustコンパイラソース（サブモジュール）
├── build.sh               # ビルドスクリプト
├── Cargo.toml             # Cargoマニフェスト
├── Makefile               # メインMakefile
├── flake.nix              # Nix Flake設定
└── rust-toolchain.toml    # Rustツールチェーン指定
```

## セットアップ

### 必要条件

- curl
- Podman（推奨）または以下のネイティブビルド依存関係
- Rust nightly-2025-10-03
- x86_64 Linux（バイナリプレフィックス使用時）

### インストール手順

#### Podmanビルド（推奨）

```sh
# ブートストラップスクリプトをダウンロード
curl -sf https://gitlab.redox-os.org/redox-os/redox/raw/master/podman_bootstrap.sh -o podman_bootstrap.sh

# 環境セットアップを実行
time bash -e podman_bootstrap.sh
```

#### ネイティブビルド

```sh
# ブートストラップスクリプトをダウンロード・実行
bash native_bootstrap.sh
```

#### NixOS

```sh
# 開発シェルに入る
nix develop

# Podman設定スクリプトが自動実行される
```

## 開発

### ビルドコマンド

```sh
# デフォルトイメージをビルド
make all

# SELinux無効環境の場合
make all USE_SELINUX=0

# ライブISOをビルド
make live

# イメージを再ビルド（クリーンビルド）
make rebuild

# クリーンアップ
make clean
make distclean  # ソースも含めて完全削除
```

### build.sh の使用

```sh
# 特定アーキテクチャでビルド
./build.sh -X qemu        # x86_64でビルドしてQEMU実行
./build.sh -A all         # aarch64向けにビルド
./build.sh -5 all         # i586向けにビルド
./build.sh -R all         # riscv64gc向けにビルド

# 特定の設定でビルド
./build.sh -c server all  # server設定でビルド
./build.sh -c demo live   # demo設定でライブISO作成
```

### エミュレーション

```sh
# QEMUでテスト実行
make qemu

# VirtualBoxでテスト実行
make virtualbox
```

### デバッグ

```sh
# GDBでカーネルをデバッグ
make gdb

# ユーザースペースアプリケーションをデバッグ
make gdb-userspace GDB_APP_FILE=path/to/app

# ネットワークトラフィックを確認
make wireshark
```

### 設定

主な環境変数（`.config` または `mk/config.mk` で設定可能）:

| 変数 | デフォルト | 説明 |
| --- | --- | --- |
| `ARCH` | ホストアーキテクチャ | ターゲットアーキテクチャ (x86_64, aarch64, i586, riscv64gc) |
| `CONFIG_NAME` | desktop | 設定名 (desktop, server, minimal等) |
| `PODMAN_BUILD` | 1 | Podmanコンテナビルドを使用 |
| `PREFIX_BINARY` | 1 | バイナリプレフィックスを使用（高速） |
| `REPO_BINARY` | 0 | バイナリパッケージを使用 |
| `REPO_OFFLINE` | 0 | オフラインビルドモード |
| `REPO_DEBUG` | 0 | デバッグ情報を含める |

### Cookbook設定

`cookbook.toml` で追加設定が可能:

```toml
[cook]
offline = false      # オフラインモード
jobs = 8             # 並列ジョブ数
tui = true           # TUI表示
logs = true          # ログ出力
nonstop = false      # エラーを無視して継続
verbose = true       # 詳細ログ

[mirrors]
"ftp.gnu.org/gnu" = "mirrors.ocf.berkeley.edu/gnu"
```

### テストとLint

```sh
# Rustコードのフォーマット
cargo fmt

# Lintチェック
cargo clippy

# テスト実行
cargo test
```
