---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **外部ドキュメント参照**: Redox Book等の外部リンクは検証未実施
  2. **TUIアプリパターンの詳細**: ratatuiフレームワーク使用部分の網羅性
  3. **依存クレートの詳細説明**: 外部クレートの内部動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Cargo.toml` - パッケージ定義、依存関係
- E-02: `src/lib.rs` - モジュール構成
- E-03: `src/config.rs` - 設定管理コード
- E-04: `src/recipe.rs` - レシピデータ構造定義
- E-05: `src/cook.rs` - cookモジュール定義
- E-06: `src/cook/cook_build.rs` - ビルド処理実装
- E-07: `src/cook/fetch.rs` - ソース取得処理実装
- E-08: `src/bin/repo.rs` - メインCLI実装
- E-09: `src/bin/repo_builder.rs` - リポジトリビルダー実装
- E-10: `Makefile` - ビルドシステム構成
- E-11: `README.md` - プロジェクト概要
- E-12: `CONTRIBUTING.md` - 開発ガイドライン
- E-13: `recipes/core/kernel/recipe.toml` - レシピ例

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトはRust言語で実装されている | E-01 | ○ |
| C-02 | エントリーポイントは`main()`関数である | E-08:174-180 | ○ |
| C-03 | 設定管理は`CookConfig`構造体で行う | E-03:29-39 | ○ |
| C-04 | レシピは`Recipe`構造体で表現される | E-04:162-174 | ○ |
| C-05 | ビルド種別は`BuildKind`列挙型で定義 | E-04:89-128 | ○ |
| C-06 | `pub mod`でモジュールを公開宣言 | E-02:1-6, E-05:1-9 | ○ |
| C-07 | パターンマッチで処理を分岐 | E-08:291-354 | ○ |
| C-08 | `Result<T, E>`でエラー処理 | E-04:206-216 | ○ |
| C-09 | `?`演算子でエラー伝播 | E-07:117-131 | ○ |
| C-10 | Serdeでシリアライズ/デシリアライズ | E-04:136-144 | ○ |
| C-11 | `repo`がメインCLIツール | E-01:14-16, E-08:42-75 | ○ |
| C-12 | `repo_builder`がリポジトリ構築ツール | E-01:18-19, E-09 | ○ |
| C-13 | `recipes/`にパッケージレシピを配置 | E-13, ディレクトリ構造確認 | ○ |
| C-14 | `config/`にビルドプロファイルを配置 | ディレクトリ構造確認 | ○ |
| C-15 | `mk/`にMakefileフラグメントを配置 | E-10:3-4 | ○ |
| C-16 | モジュラーCLIアーキテクチャを採用 | E-01, E-08 構造から推定 | ○ |
| C-17 | CLI → Library → Cook Submodules の層構造 | E-02, E-05, E-08 | ○ |
| C-18 | fetch処理でソースを取得 | E-07:117-406 | ○ |
| C-19 | cook_build処理でビルドを実行 | E-06:170-462 | ○ |
| C-20 | `handle_fetch`関数がフェッチを制御 | E-08:553-566 | ○ |
| C-21 | `handle_cook`関数がビルドを制御 | E-08:568-606 | ○ |
| C-22 | `parse_args`で引数を解析 | E-08:373-551 | ○ |
| C-23 | `init_config`で設定を初期化 | E-03:68-121 | ○ |
| C-24 | `Cli*`プレフィックスはCLI関連 | E-08:77-88, 90-99 | ○ |
| C-25 | `*Recipe`サフィックスはレシピ関連 | E-04 全体 | ○ |
| C-26 | `handle_*`プレフィックスはハンドラ | E-08:553-766 | ○ |
| C-27 | `fetch_*`プレフィックスはソース取得関連 | E-07 全体 | ○ |
| C-28 | pkgarはパッケージアーカイブ形式 | E-01:41-43, E-06:116-145 | ○ |
| C-29 | sysrootは依存ライブラリ配置場所 | E-06:180, 280-308 | ○ |
| C-30 | stageはビルド成果物配置場所 | E-06:182-183, 261-266 | ○ |
| C-31 | TOMLでレシピを定義 | E-13 | ○ |
| C-32 | gitソースをサポート | E-04:35-53, E-07:161-317 | ○ |
| C-33 | tarソースをサポート | E-04:55-66, E-07:318-379 | ○ |
| C-34 | cargoビルドテンプレートをサポート | E-04:100-106, E-06:343-350 | ○ |
| C-35 | configureビルドテンプレートをサポート | E-04:108-112, E-06:352-355 | ○ |
| C-36 | cmakeビルドテンプレートをサポート | E-04:114-118, E-06:356-359 | ○ |
| C-37 | mesonビルドテンプレートをサポート | E-04:120-124, E-06:360-363 | ○ |
| C-38 | customビルドスクリプトをサポート | E-04:126-127, E-06:364 | ○ |
| C-39 | remoteビルド（バイナリダウンロード）をサポート | E-04:97-98, E-06:335-336, E-06:613-672 | ○ |
| C-40 | TUIモードでビルド進捗を表示 | E-08:770-1010 | ○ |
| C-41 | COOKBOOK_VERBOSE環境変数で詳細ログ | E-03:97-98 | ○ |
| C-42 | build/logs/にログを保存 | E-08:155-159 | ○ |
| C-43 | 外部ドキュメント（Redox Book）への参照 | **根拠なし** | △ |
| C-44 | TUIフレームワーク（ratatui）の詳細動作 | **根拠不足** | △ |
| C-45 | 依存クレート（pkgar等）の内部実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **外部ドキュメント参照（C-43）**: Redox Book等への外部リンクは本リポジトリ内に含まれないため検証不可
  - 候補：`https://doc.redox-os.org/book/` を手動で確認
- **TUIフレームワーク詳細（C-44）**: ratatuiクレートの詳細動作は外部依存のため網羅性に限界あり
  - 候補：`https://docs.rs/ratatui/` を参照
- **依存クレート内部実装（C-45）**: pkgar, redoxer, installer等の内部実装は本リポジトリ外
  - 候補：各GitLabリポジトリを参照

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 言語基礎、命名規則、ディレクトリ構造 - ソースコードから直接確認可能
- **0（低リスク）**: アーキテクチャ概要 - コード構造から推定可能
- **1（中リスク）**: 外部ドキュメントリンク - リンク切れの可能性
- **1（中リスク）**: 業務フロー追跡例 - 実際の動作との乖離可能性
- **0（低リスク）**: トラブルシューティング - 設定値はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] セクション1「言語基礎」のコード例が最新ソースと一致するか確認
- [ ] セクション4「ディレクトリ構造」が現在のプロジェクト構成と一致するか確認
- [ ] セクション5「アーキテクチャ」の図がコード構造を正確に反映しているか確認
- [ ] セクション8「業務フロー追跡」の手順を実際に実行して検証
- [ ] 外部リンク（Redox Book等）が有効か確認
- [ ] 用語集の定義が正確か確認
