---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **Edition 2024使用**: Cargo.tomlに記載されているが、実在するかは要確認
  2. **TUI feature無効化の自動判定**: CI環境判定ロジックの詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Cargo.toml` - パッケージ定義、依存関係
- E-02: `README.md` - プロジェクト概要
- E-03: `src/lib.rs` - ライブラリエントリポイント、モジュール構成
- E-04: `src/config.rs` - 設定管理、CookConfig/CookbookConfig
- E-05: `src/recipe.rs` - Recipe/SourceRecipe/BuildKind定義
- E-06: `src/cook/cook_build.rs` - ビルドロジック
- E-07: `src/cook/fetch.rs` - ソース取得ロジック
- E-08: `src/cook/package.rs` - パッケージング処理
- E-09: `src/cook/fs.rs` - ファイルシステムユーティリティ（参照のみ）
- E-10: `src/cook/script.rs` - ビルドスクリプトテンプレート
- E-11: `src/cook/pty.rs` - PTY制御（参照のみ）
- E-12: `src/bin/repo.rs` - メインCLI、TUI実装
- E-13: `src/bin/repo_builder.rs` - リポジトリ生成
- E-14: `src/bin/cookbook_redoxer.rs` - Redoxerラッパー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rust言語で実装されている | E-01 | ○ |
| C-02 | モジュラーアーキテクチャを採用 | E-03, E-05, E-06, E-07, E-08 | ○ |
| C-03 | Git/Tar/Pathソース取得に対応 | E-05 (SourceRecipe enum), E-07 | ○ |
| C-04 | pkgarパッケージ形式を使用 | E-01 (pkgar依存), E-08 | ○ |
| C-05 | Cargo/Configure/CMake/Mesonビルドテンプレート | E-05 (BuildKind enum), E-10 | ○ |
| C-06 | TUI機能はratatui使用 | E-01 (依存), E-12 (実装) | ○ |
| C-07 | mpscチャネルでスレッド間通信 | E-12 (StatusUpdate, work_tx) | ○ |
| C-08 | OnceLockで設定の不変性を保証 | E-04 (CONFIG: OnceLock) | ○ |
| C-09 | anyhow::Resultによるエラー処理 | E-01 (依存), E-12 | ○ |
| C-10 | アトミック移動でデータ整合性確保 | E-06 (rename), E-07 (rename) | ○ |
| C-11 | Ed25519署名でパッケージ検証 | E-08 (pkgar_keys), E-01 | ○ |
| C-12 | ビルドログはPTYでキャプチャ | E-12 (setup_pty, PtyOut) | ○ |
| C-13 | COOKBOOK_NONSTOP環境変数でエラー継続 | E-04 (nonstop), E-12 | ○ |
| C-14 | 依存関係の再帰的解決 | E-05 (new_recursive, WALK_DEPTH) | ○ |
| C-15 | ミラー設定によるURL変換 | E-04 (translate_mirror) | ○ |
| C-16 | TOML形式でレシピ定義 | E-05 (Recipe::new, toml::from_str) | ○ |
| C-17 | serde使用でシリアライズ | E-01, E-04, E-05 | ○ |
| C-18 | globsetでファイルパターンマッチング | E-01 (依存), E-06 | ○ |
| C-19 | termionでターミナル制御 | E-01, E-12 | ○ |
| C-20 | redoxerでクロスコンパイル | E-01, E-14 | ○ |
| C-21 | 動的リンク依存の自動検出 | E-06 (auto_deps_from_dynamic_linking) | ○ |
| C-22 | source.tmp -> source のアトミック移動 | E-07 (fetch関数内) | ○ |
| C-23 | stage.tmp -> stage のアトミック移動 | E-06 (build関数内) | ○ |
| C-24 | sysroot.tmp -> sysroot のアトミック移動 | E-06 (build_deps_dir) | ○ |
| C-25 | キャッシュ判定はタイムスタンプベース | E-06 (modified, modified_dir) | ○ |
| C-26 | repo.tomlでリポジトリインデックス管理 | E-13 (Repository) | ○ |
| C-27 | blake3ハッシュでtarball検証 | E-07 (get_blake3), E-05 | ○ |
| C-28 | 循環依存を検出して中止 | E-05 (PackageError::Recursion) | ○ |
| C-29 | host/targetパッケージの区別 | E-05 (is_host), E-08 (package_target) | ○ |
| C-30 | オプショナルパッケージ対応 | E-05 (OptionalPackageRecipe), E-06 | ○ |
| C-31 | AppStreamメタデータ生成対応 | E-13 (appstream_sources) | ○ |
| C-32 | シェルスクリプトでビルド実行 | E-10 (bash scripts), E-06 | ○ |
| C-33 | Presentation層はCLI/TUI | E-12 | ○ |
| C-34 | Edition 2024使用 | E-01 | △ |
| C-35 | CI環境でTUI自動無効化 | E-04 (env::var("CI")) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-34: Edition 2024使用**: Cargo.tomlに`edition = "2024"`と記載されているが、Rust Edition 2024は2026年1月時点で安定版ではない可能性がある。実際のビルド可否の確認が必要。
  - 候補：Rust公式ドキュメント / rustup確認 / 実ビルドテスト
- **C-35: CI環境でTUI自動無効化**: `env::var("CI")`の判定は確認できるが、「CI環境」の具体的な定義（GitHub Actions, GitLab CI等）は明示されていない。
  - 候補：CI設定ファイル / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のアーキテクチャ主張はソースコードで直接確認可能
- **1 (中リスク)**: Edition 2024の使用可否（ビルドエラーの可能性）
- **0 (低リスク)**: TUI/CLIの動作切替ロジック（コードで確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] Cargo.tomlの`edition = "2024"`が実際にビルド可能か確認
- [ ] 各モジュールの責務分離が設計書の記載通りか確認
- [ ] 外部連携（Git, pkgar等）のURLやプロトコルが正確か確認
- [ ] ビルドテンプレート（Cargo/Configure/CMake/Meson）の動作確認
- [ ] TUIモードとCLIモードの切替が期待通りに動作するか確認
