# インフラ構成図

## 全体アーキテクチャ

```mermaid
flowchart TB
    subgraph External["外部サービス"]
        GITLAB[("gitlab.redox-os.org<br/>ソースリポジトリ")]
        STATIC[("static.redox-os.org<br/>パッケージ配信")]
        RUSTLANG[("static.rust-lang.org<br/>Rustツールチェーン")]
        CRATES[("crates.io<br/>Rustパッケージ")]
    end

    subgraph CI["CI/CD環境"]
        RUNNER["GitLab CI Runner"]
        PIPELINE["CI Pipeline<br/>lint → test → img"]
    end

    subgraph BuildEnv["ビルド環境"]
        subgraph Container["Podmanコンテナ"]
            DEBIAN["debian:trixie<br/>ベースイメージ"]
            TOOLCHAIN["ツールチェーン<br/>GCC 13 / Rust"]
            COOKBOOK["Cookbook<br/>パッケージビルド"]
        end
        subgraph Native["ネイティブ環境（代替）"]
            LINUX["Linux"]
            MACOS["macOS"]
            FREEBSD["FreeBSD"]
        end
    end

    subgraph Artifacts["ビルド成果物"]
        HDD["harddrive.img"]
        ISO["redox-live.iso"]
        FS["filesystem.img"]
    end

    subgraph Test["テスト環境"]
        QEMU["QEMU<br/>x86_64/i586/aarch64/riscv64"]
        VB["VirtualBox"]
    end

    GITLAB --> RUNNER
    RUNNER --> PIPELINE
    PIPELINE --> Container

    STATIC --> TOOLCHAIN
    RUSTLANG --> TOOLCHAIN
    CRATES --> COOKBOOK

    Container --> Artifacts
    Native --> Artifacts

    Artifacts --> QEMU
    Artifacts --> VB
```

## ビルドパイプライン

```mermaid
flowchart LR
    subgraph Stage1["Stage: lint"]
        FMT["cargo fmt --check"]
        TEST["cargo test"]
    end

    subgraph Stage2["Stage: img"]
        PREFIX["prefix<br/>ツールチェーン準備"]
        FSTOOLS["fstools<br/>ファイルシステムツール"]
        REPO["repo cook<br/>パッケージビルド"]
        IMAGE["イメージ生成"]
    end

    FMT --> TEST
    TEST --> PREFIX
    PREFIX --> FSTOOLS
    FSTOOLS --> REPO
    REPO --> IMAGE
```

## Podmanコンテナ構成

```mermaid
flowchart TB
    subgraph Host["ホストマシン"]
        PODMAN["Podman"]
        FUSE["FUSE3<br/>RedoxFSマウント"]
        SRC["ソースディレクトリ<br/>/mnt/redox"]
    end

    subgraph Container["redox-base コンテナ"]
        BASE["debian:trixie"]
        RUST["Rust toolchain"]
        GCC["GCC 13 cross-compiler"]
        DEPS["ビルド依存パッケージ<br/>cmake, meson, nasm..."]
        QEMU_C["qemu-system-x86<br/>qemu-system-arm"]
    end

    PODMAN --> Container
    SRC -.->|"volume mount"| Container
    Container -.->|"/dev/fuse"| FUSE
```

## ツールチェーンビルド依存関係

```mermaid
flowchart TB
    subgraph Toolchain["ツールチェーンビルド"]
        BINUTILS["binutils-install"]
        LIBTOOL["libtool-install"]
        GCC_FREE["gcc-freestanding-install"]
        RELIBC_FREE["relibc-freestanding-install"]
        GCC_FULL["gcc-install"]
        RUST_INST["rust-install"]
        RELIBC_FULL["relibc-install"]
        SYSROOT["sysroot"]
    end

    BINUTILS --> GCC_FREE
    LIBTOOL --> GCC_FREE
    GCC_FREE --> RELIBC_FREE
    RELIBC_FREE --> GCC_FULL
    LIBTOOL --> GCC_FULL
    GCC_FULL --> RUST_INST
    RELIBC_FREE --> RUST_INST
    RUST_INST --> RELIBC_FULL
    RELIBC_FULL --> SYSROOT
    LIBTOOL --> SYSROOT
```

## 対応アーキテクチャマトリクス

```mermaid
flowchart LR
    subgraph Target["ターゲットアーキテクチャ"]
        X86_64["x86_64-unknown-redox"]
        I586["i586-unknown-redox"]
        AARCH64["aarch64-unknown-redox"]
        RISCV64["riscv64gc-unknown-redox"]
    end

    subgraph QEMU_ARCH["QEMUエミュレータ"]
        Q_X86["qemu-system-x86_64"]
        Q_I386["qemu-system-i386"]
        Q_ARM["qemu-system-aarch64"]
        Q_RISCV["qemu-system-riscv64"]
    end

    X86_64 --> Q_X86
    I586 --> Q_I386
    AARCH64 --> Q_ARM
    RISCV64 --> Q_RISCV
```

## ネットワーク構成（開発環境）

```mermaid
flowchart TB
    subgraph Host["ホストマシン"]
        DEV["開発者"]
        SSH["SSH Port 8022"]
        HTTP["HTTP Port 8080-8083"]
        GDB["GDB Port 64126"]
    end

    subgraph QEMU_NET["QEMU仮想ネットワーク"]
        VM["Redox VM<br/>10.0.2.15"]
        GW["ゲートウェイ<br/>10.0.2.2"]
        DNS["DNS<br/>9.9.9.9"]
    end

    DEV --> SSH
    DEV --> HTTP
    DEV --> GDB
    SSH --> VM
    HTTP --> VM
    GDB --> VM
    VM --> GW
    GW --> DNS
```

## ストレージ構成

```mermaid
flowchart TB
    subgraph Storage["ストレージ"]
        subgraph Build["ビルドディレクトリ"]
            BUILD_DIR["build/{ARCH}/{CONFIG_NAME}"]
            HDD_IMG["harddrive.img"]
            LIVE_ISO["redox-live.iso"]
            EXTRA["extra.img"]
        end

        subgraph Prefix["プレフィックス"]
            PREFIX_DIR["prefix/{TARGET}"]
            SYSROOT["sysroot/"]
            RUST_DIR["rust-install/"]
            GCC_DIR["gcc-install/"]
        end

        subgraph Repo["リポジトリ"]
            RECIPES["recipes/"]
            PKGS["パッケージ"]
        end
    end

    BUILD_DIR --> HDD_IMG
    BUILD_DIR --> LIVE_ISO
    BUILD_DIR --> EXTRA
    PREFIX_DIR --> SYSROOT
    PREFIX_DIR --> RUST_DIR
    PREFIX_DIR --> GCC_DIR
    RECIPES --> PKGS
```

## CI/CDワークフロー

```mermaid
sequenceDiagram
    participant DEV as 開発者
    participant GL as GitLab
    participant CI as CI Runner
    participant CONT as Podmanコンテナ
    participant STATIC as static.redox-os.org

    DEV->>GL: git push
    GL->>CI: トリガー

    rect rgb(200, 220, 240)
        Note over CI,CONT: lint ステージ
        CI->>CONT: rustfmt check
        CI->>CONT: cargo test
    end

    rect rgb(220, 240, 200)
        Note over CI,CONT: img ステージ
        CI->>STATIC: ツールチェーンダウンロード
        STATIC-->>CI: バイナリツールチェーン
        CI->>CONT: make ci-img
        CONT-->>CI: harddrive.img, redox-live.iso
    end

    CI->>GL: 成果物アップロード
    GL-->>DEV: ビルド完了通知
```
