# インフラ設計書

## 概要

本ドキュメントは、Redox OSビルドシステムのインフラストラクチャ設計を記載する。Redox OSはRust言語で開発されたマイクロカーネルベースのオペレーティングシステムであり、本ビルドシステムはそのOSイメージを生成するための基盤を提供する。

## システム構成

### 全体構成

Redox OSビルドシステムは以下のコンポーネントから構成される：

1. **ビルド環境**
   - Podmanコンテナベースのビルド環境（推奨）
   - ネイティブLinux/macOS/FreeBSDビルド環境

2. **ツールチェーン**
   - GCC 13クロスコンパイラ
   - Rust コンパイラ（カスタムターゲット対応）
   - relibc（Redox用Cライブラリ）

3. **CI/CD環境**
   - GitLab CI/CD

4. **仮想化・エミュレーション**
   - QEMU（テスト・開発用）
   - VirtualBox（テスト・開発用）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| CI/CDサーバー | GitLab CI実行、イメージビルド | Docker/Podman対応、Linux環境 | 構成依存 |
| 静的ファイル配信サーバー | ツールチェーン・パッケージ配信 | `static.redox-os.org` | 1以上 |
| リポジトリサーバー | ソースコード管理 | GitLab CE/EE | 1以上 |

### ネットワーク構成

```
[開発者端末] <--HTTPS--> [GitLab リポジトリ (gitlab.redox-os.org)]
                              |
                              v
                        [CI/CD Runner]
                              |
                              v
[静的配信サーバー (static.redox-os.org)] <-- パッケージ/ツールチェーンダウンロード
                              |
                              v
                        [ビルド成果物]
```

#### QEMU仮想ネットワーク（開発・テスト用）

| 項目 | 設定値 |
| --- | --- |
| デフォルトIP | 10.0.2.15 |
| デフォルトゲートウェイ | 10.0.2.2 |
| サブネットマスク | 255.255.255.0 |
| DNS | 9.9.9.9 |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Podman | 最新 | コンテナビルド環境 |
| Docker | 最新（互換） | 代替コンテナランタイム |
| QEMU | 最新 | 仮想化テスト（x86_64, i586, aarch64, riscv64） |
| VirtualBox | 最新 | 仮想化テスト |
| FUSE3 | 最新 | RedoxFSマウント |
| GCC | 13.x | クロスコンパイラ |
| Rust | nightly | システム言語 |
| sccache | 最新（任意） | ビルドキャッシュ |

### Podmanコンテナ依存パッケージ

ビルドコンテナ（debian:trixie ベース）には以下のパッケージが含まれる：

- ビルドツール: autoconf, automake, bison, build-essential, cmake, flex, make, meson, ninja-build
- 言語・ランタイム: python3, perl, ruby
- アーカイブ・圧縮: lzip, unzip, zip, zstd
- 開発ライブラリ: libfuse3-dev, libgmp-dev, libmpfr-dev, libmpc-dev, zlib1g-dev
- 仮想化: qemu-system-x86, qemu-system-arm, qemu-efi-aarch64

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| gitlab.redox-os.org | ソースコードリポジトリ、CI/CD | HTTPS/SSH (Git) |
| static.redox-os.org | ツールチェーン・パッケージ配信 | HTTPS |
| static.rust-lang.org | Rust公式ツールチェーン | HTTPS |
| crates.io | Rustパッケージレジストリ | HTTPS |

## スケーリング設計

### ビルド並列化

- **CI並列ビルド**: GitLab CI Runnerを複数配置可能
- **コンパイル並列化**: `nproc`による自動CPU数検出
- **sccacheによるキャッシュ**: Podman環境内で自動有効化

### 対応アーキテクチャ

| アーキテクチャ | ターゲット | サポート状況 |
| --- | --- | --- |
| x86_64 | x86_64-unknown-redox | フル対応 |
| i586 | i586-unknown-redox | 対応 |
| aarch64 | aarch64-unknown-redox | 対応 |
| riscv64gc | riscv64gc-unknown-redox | 対応 |

## 可用性設計

### 冗長構成

- **ツールチェーン配信**: `static.redox-os.org`からのバイナリダウンロードまたはローカルビルド
- **オフラインビルド**: `REPO_OFFLINE=1`設定によるオフラインモード対応
- **ローカルキャッシュ**: ビルド済みパッケージのローカルキャッシュ

### フェイルオーバー方式

- ツールチェーンバイナリのダウンロード失敗時はソースからのビルドにフォールバック
- Podmanビルドが利用できない場合はネイティブビルドに切り替え可能

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Gitリポジトリ（GitLab） | リアルタイム（プッシュ時） | 永続 |
| ビルドツールチェーン | static.redox-os.org配信 | リリース時 | 複数バージョン保持 |
| ビルド成果物 | CI Artifacts | ビルド毎 | CI設定依存 |
| OSイメージ | zstd圧縮、SHA256チェックサム | リリース時 | 複数バージョン保持 |

## 監視設計

### CI/CDパイプライン監視

GitLab CIにて以下のステージを監視：

1. **lint**: コードフォーマットチェック（rustfmt）
2. **test**: ユニットテスト、ビルドテスト
3. **img**: イメージビルド

### ビルド成果物検証

- SHA256チェックサムによるイメージ整合性検証
- zstd圧縮による成果物サイズ最適化

## ストレージ設計

### ファイルシステムサイズ

| 構成 | デフォルトサイズ (MiB) |
| --- | --- |
| Server | 512 |
| Desktop | 650 |
| Minimal | 構成依存 |

### ディスクイメージ形式

- **harddrive.img**: ハードディスクイメージ（raw形式）
- **redox-live.iso**: ライブISOイメージ
- **filesystem.img**: ファイルシステムイメージ

## セキュリティ設計

### コンテナ分離

- Podmanコンテナによるビルド環境分離
- SYS_ADMIN capability と /dev/fuse のみ許可

### 署名・検証

- pkgarによるパッケージ署名
- SHA256チェックサムによる整合性検証

## 備考

### 環境変数一覧

| 変数名 | 説明 | デフォルト値 |
| --- | --- | --- |
| ARCH | ターゲットアーキテクチャ | ホストと同一 |
| PODMAN_BUILD | Podmanビルド有効化 | 1 |
| PREFIX_BINARY | バイナリツールチェーン使用 | 1 |
| REPO_BINARY | バイナリパッケージ使用 | 0 |
| SCCACHE_BUILD | sccache有効化 | コンテナ内で1 |
| REPO_NONSTOP | エラー時も継続 | 0 |
| REPO_OFFLINE | オフラインモード | 0 |
| REPO_DEBUG | デバッグビルド | 0 |

### QEMUエミュレーション設定

| アーキテクチャ | QEMU SMP | QEMU MEM (MB) | デフォルトGPU |
| --- | --- | --- | --- |
| x86_64 | 4 | 2048 | vga |
| i586 | 1 | 1024 | vga |
| aarch64 | 1 | 2048 | ramfb |
| riscv64gc | 4 | 2048 | ramfb |
