---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **秘密鍵のファイルシステム権限設定**：運用設定に依存、コード上の強制なし
  2. **TLS証明書検証の詳細**：wget依存、内部実装不明
  3. **ログ保持期間**：設定ファイルに依存、デフォルト値未定義

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/blake3.rs` - BLAKE3ハッシュ実装
- E-02: `src/cook/package.rs` - パッケージ署名・鍵管理
- E-03: `src/cook/fetch.rs` - ソース取得・検証処理
- E-04: `src/cook/cook_build.rs` - ビルド時の署名検証
- E-05: `src/config.rs` - 設定・ミラー管理
- E-06: `src/cook/fs.rs` - ファイルシステム操作・Git処理
- E-07: `src/cook/ident.rs` - ソース識別子管理
- E-08: `src/lib.rs` - リモートパッケージソースURL定義
- E-09: `src/recipe.rs` - レシピ定義（BLAKE3ハッシュフィールド含む）
- E-10: `Cargo.toml` - 依存クレート定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ed25519公開鍵暗号によるパッケージ署名 | E-02, E-04 | ○ |
| C-02 | 鍵ファイルがbuild/配下に保存される | E-02 | ○ |
| C-03 | pkgar_keys::SecretKeyFile::new()による鍵生成 | E-02 | ○ |
| C-04 | BLAKE3ハッシュによるtarファイル検証 | E-01, E-03, E-09 | ○ |
| C-05 | リモートパッケージ取得にHTTPS使用 | E-08, E-03 | ○ |
| C-06 | ミラーURL変換機能 | E-05 | ○ |
| C-07 | パス・トラバーサル対策（check_path） | E-04 | ○ |
| C-08 | シンボリックリンクループ検出 | E-03 | ○ |
| C-09 | サンドボックス化されたsysroot環境 | E-04 | ○ |
| C-10 | ソース識別子（コミット・タイムスタンプ）追跡 | E-07 | ○ |
| C-11 | auto_deps.tomlへの依存関係永続化 | E-04 | ○ |
| C-12 | オフラインモードサポート | E-05, E-03 | ○ |
| C-13 | blake3クレート使用 | E-10 | ○ |
| C-14 | pkgar/pkgar-keysクレート使用 | E-10 | ○ |
| C-15 | 公開鍵のリモート取得 | E-03 | ○ |
| C-16 | tarファイルのBLAKE3不一致時のエラー | E-03 | ○ |
| C-17 | wget経由でのダウンロード | E-06 | ○ |
| C-18 | ビルドログの出力 | E-05 | ○ |
| C-19 | source_info.tomlへの永続化 | E-03, E-07 | ○ |
| C-20 | Rust所有権システムによるメモリ安全性 | E-10 | ○ |
| C-21 | clean_build/clean_targetオプション | E-05 | ○ |
| C-22 | cookbook.tomlによるミラー設定 | E-05 | ○ |
| C-23 | 秘密鍵のファイルシステム権限による保護 | **根拠なし** | △ |
| C-24 | TLSによる通信暗号化の詳細 | **根拠なし** | △ |
| C-25 | ログ保持期間の具体的設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **秘密鍵のファイルシステム権限設定**
  - 理由：コード上でファイル権限を設定するロジックが見当たらない
  - 候補：運用マニュアル / デプロイスクリプト / OSレベルの設定
- **TLS証明書検証の詳細**
  - 理由：wgetコマンドに依存しており、内部でのTLS検証ロジックがない
  - 候補：wget設定 / システムCA証明書 / 環境変数
- **ログ保持期間**
  - 理由：明示的な保持期間設定がコードに存在しない
  - 候補：運用ポリシー / 外部ログ管理システム / ディスククォータ

## 5) リスクフラグ（レビュー観点）
- **低リスク (0)**: BLAKE3ハッシュ検証、Ed25519署名検証、ソース追跡
- **中リスク (1)**: ミラーサーバ信頼性、オフラインモード時の検証スキップ可能性
- **高リスク (2)**: 秘密鍵の物理的保護（運用依存）、wget経由ダウンロードの証明書検証

## 6) レビュアーチェックリスト（最小）
- [ ] 秘密鍵ファイル（build/id_ed25519.toml）のアクセス権限が適切に設定されているか確認
- [ ] 本番環境でのミラーサーバ設定が信頼できるソースのみになっているか確認
- [ ] tarファイルのBLAKE3ハッシュがすべてのrecipe.tomlで設定されているか確認
- [ ] wgetのTLS設定（証明書検証）が有効になっているか確認
- [ ] オフラインモード使用時のセキュリティリスクを評価済みか確認
- [ ] ビルドログに機密情報が含まれていないか確認
- [ ] 依存クレート（pkgar, pkgar-keys, blake3）のセキュリティアドバイザリを確認
