---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な目標値がソースコードから確認できない
  2. **不具合管理方法の詳細**：GitLab Issuesの具体的な運用方法が不明
  3. **性能テスト実施タイミング**：リリース前・定期実行の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.gitlab-ci.yml` - CI/CDパイプライン設定
- E-02: `Cargo.toml` - Rustプロジェクト設定（2024 edition）
- E-03: `Makefile` - ビルドシステムエントリーポイント
- E-04: `mk/ci.mk` - CI関連Makeターゲット
- E-05: `config/tests.toml` - テスト構成定義
- E-06: `config/x86_64/tests.toml` - x86_64テスト構成
- E-07: `config/acid.toml` - acidテスト構成
- E-08: `config/resist.toml` - resistテスト構成
- E-09: `recipes/tests/acid/recipe.toml` - acidパッケージ定義
- E-10: `recipes/tests/resist/recipe.toml` - resistパッケージ定義
- E-11: `recipes/tests/os-test/recipe.toml` - os-testパッケージ定義
- E-12: `recipes/tests/openposixtestsuite/recipe.toml` - OpenPOSIXパッケージ定義
- E-13: `recipes/tests/redox-posix-tests/recipe.toml` - redox-posix-testsパッケージ定義
- E-14: `recipes/tests/relibc-tests/recipe.toml` - relibc-testsパッケージ定義
- E-15: `recipes/tests/vttest/recipe.toml` - vttestパッケージ定義
- E-16: `recipes/tests/benchmarks/recipe.toml` - benchmarksパッケージ定義
- E-17: `recipes/tests/hello-redox/recipe.toml` - hello-redoxパッケージ定義
- E-18: `src/config.rs` - 設定モジュール（テストコード含む）
- E-19: `src/recipe.rs` - レシピモジュール（テストコード含む）
- E-20: `src/cook/cook_build.rs` - ビルドモジュール（テストコード含む）
- E-21: `README.md` - プロジェクト概要・リンク
- E-22: `recipes/tests/hello-redox/files/` - マルチ言語サンプルファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Redox OSビルドシステムはRust言語で実装されている | E-02 | ○ |
| C-02 | 単体テストはconfig、recipe、cook_buildモジュールで実施 | E-18, E-19, E-20 | ○ |
| C-03 | GitLab CIでfmt、cargo-test、imgジョブが実行される | E-01 | ○ |
| C-04 | テストは複数アーキテクチャ（x86_64、i586、aarch64、riscv64gc）をサポート | E-05, E-06 | ○ |
| C-05 | acidテストはcreate_test, switch, tls, threadを検証 | E-07 | ○ |
| C-06 | resistテストはPOSIX/Redox仕様準拠テストを実行 | E-08, E-10 | ○ |
| C-07 | os-testパッケージはSortix由来のOSテストスイート | E-11 | ○ |
| C-08 | openposixtestsuiteはRedoxブランチを使用 | E-12 | ○ |
| C-09 | vttestはバージョン20140305を使用 | E-15 | ○ |
| C-10 | relibc-testsはrelibcソースからテストをコピー | E-14 | ○ |
| C-11 | テスト構成ファイルはserver.tomlを継承 | E-05 | ○ |
| C-12 | RUST_BACKTRACE=fullでテスト実行 | E-07, E-08 | ○ |
| C-13 | CI環境はUbuntu 24.04とrust:trixieを使用 | E-01 | ○ |
| C-14 | cargo test --lockedでテスト実行 | E-01 | ○ |
| C-15 | cargo fmt --checkでフォーマットチェック | E-01 | ○ |
| C-16 | Podmanによるビルド分離が可能 | E-03, E-04 | ○ |
| C-17 | hello-redoxは複数言語（Rust, C, Go, Python, Java, etc.）のサンプル | E-17, E-22 | ○ |
| C-18 | benchmarksパッケージで性能ベンチマークを実施 | E-16 | ○ |
| C-19 | resistはposix/base.toml, posix/shell.toml, redox/spec.tomlを検証 | E-08 | ○ |
| C-20 | filesystem_sizeは10000MiBをデフォルト設定 | E-05 | ○ |
| C-21 | os-testはgcc13, gnu-binutils等に依存 | E-11 | ○ |
| C-22 | master/MRでCIがトリガーされる | E-01 | ○ |
| C-23 | カバレッジ目標値は明示的に設定されていない | **根拠なし** | △ |
| C-24 | 不具合管理はGitLab Issuesで実施 | **根拠なし（推定）** | △ |
| C-25 | 性能テストはリリース前・定期実行される | **根拠なし（推定）** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値**: ソースコード内にカバレッジ目標の設定が見当たらない。Rustの型システムによる安全性重視のアプローチと推定。
  - 候補：プロジェクトポリシードキュメント / 開発者インタビュー / GitLab CI設定の詳細確認
- **不具合管理の詳細運用**: GitLab Issuesの使用は一般的なGitLab運用から推定したが、具体的な運用ルールは不明。
  - 候補：CONTRIBUTING.md / Issue Templates / GitLab Project設定
- **性能テスト実施タイミング**: benchmarksパッケージの存在は確認できるが、実行タイミングの明示的な定義はない。
  - 候補：リリース手順書 / CI設定の拡張部分 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 単体テスト、CI/CD連携、テストツールに関する記述 - ソースコードから直接確認可能
- **1（中リスク）**: テスト環境、アーキテクチャサポートに関する記述 - 設定ファイルから推測可能
- **2（高リスク）**: カバレッジ目標、不具合管理方法、性能テスト運用 - 外部情報源が必要

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標が組織として設定されているか確認（ある場合は追記）
- [ ] GitLab Issuesの運用ルールが存在するか確認（CONTRIBUTING.md等）
- [ ] 性能テスト（benchmarks）の実行頻度・タイミングを開発チームに確認
- [ ] 各テストパッケージ（acid、resist等）の最新バージョンとの整合性確認
- [ ] 記載されていないテストツール・方針がないか確認
- [ ] マルチアーキテクチャテストの実行状況（全アーキテクチャでテストが通っているか）を確認
