# テスト方針書

## 概要

本ドキュメントは、Redox OSビルドシステム（redox_cookbook）のテスト方針を定義します。Redox OSはRust言語で実装されたマイクロカーネルベースのオペレーティングシステムであり、本リポジトリはそのビルドシステム、パッケージ管理、およびOS全体のテストインフラストラクチャを提供します。テストは、ビルドシステム自体のユニットテストから、OS全体のPOSIX準拠テスト、システムテストまで多層的に実施されます。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | Rustコードの個別モジュール（config、recipe、cook_build）の機能検証 | 開発者 |
| 結合テスト | ビルドシステムコンポーネント間の連携検証（CI/CDパイプラインで実施） | CI自動実行 |
| システムテスト | Redox OS全体の動作検証（acid、resist、os-test等のテストスイート） | CI自動実行、QAチーム |
| 受入テスト | POSIX準拠検証（openposixtestsuite、redox-posix-tests） | CI自動実行、コミュニティ |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各コンポーネントの機能が仕様通り動作することを確認 | プルリクエスト時、マージ時 |
| 性能テスト | benchmarksパッケージによるシステム性能測定 | リリース前、定期実行 |
| セキュリティテスト | Rustの安全性機能に依存、POSIX準拠テストでの境界値検証 | 継続的 |
| POSIX準拠テスト | Open POSIX Test Suite、redox-posix-testsによる標準準拠検証 | テスト構成ビルド時 |
| 回帰テスト | 既存機能が新変更で壊れないことを確認 | プルリクエスト時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体テスト実行 | Linux/macOS + Rust toolchain |
| GitLab CI | 自動テスト・ビルド検証 | Ubuntu 24.04 / rust:trixie Docker image |
| QEMU仮想環境 | Redox OSシステムテスト実行 | QEMU + Redox OS test configuration |
| 実機テスト環境 | ハードウェア互換性検証 | x86_64、i586、aarch64、riscv64gcアーキテクチャ |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| cargo test | Rustユニットテスト実行 | Rust 2024 edition |
| rustfmt | コードフォーマットチェック | Rust toolchain付属 |
| acid | システム機能テスト（create_test, switch, tls, thread） | Redox OS固有 |
| resist | POSIX/Redox仕様準拠テストフレームワーク | Redox OS固有 |
| os-test | OSレベルテストスイート（Sortix由来） | 外部プロジェクト |
| openposixtestsuite | POSIX標準準拠テスト | Redoxブランチ |
| redox-posix-tests | Redox固有POSIXテスト | Redox OS固有 |
| vttest | ターミナルエミュレータテスト | vttest-20140305 |
| benchmarks | 性能ベンチマーク | Redox OS固有 |
| hello-redox | マルチ言語サンプルテスト（Rust, C, Go, Python, Java, etc.） | Redox OS固有 |
| relibc-tests | Cライブラリ（relibc）テスト | relibc付属 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な数値目標なし（Rustの型システムによる安全性重視） |
| 分岐カバレッジ | 明示的な数値目標なし |
| POSIX API準拠率 | Open POSIX Test Suiteで継続的に計測・向上 |

## テストデータ

テストデータの準備方針は以下の通りです：

1. **ユニットテスト用データ**: 各テスト関数内でインラインで定義（例：TOML設定文字列）
2. **システムテスト用データ**: テストパッケージ内に含まれるテストケース定義ファイル
   - resist: `/share/resist/posix/`, `/share/resist/redox/`に仕様定義
   - os-test: `/share/os-test/`に配置
   - openposixtestsuite: `/share/openposixtestsuite/`に配置
3. **ベンチマーク用データ**: `/usr/share/benchmarks/`に配置

## 不具合管理

不具合管理は以下の方法で実施されます：

1. **GitLab Issues**: 不具合の報告・追跡はGitLab Issuesで管理
2. **マージリクエストレビュー**: CI通過およびコードレビューが必須
3. **バックトレース出力**: テスト実行時は`RUST_BACKTRACE=full`を設定し、障害調査を容易化
4. **アーキテクチャ別追跡**: x86_64、i586、aarch64、riscv64gc各アーキテクチャでの動作状況を個別管理

## CI/CD連携

CI/CDパイプラインでのテスト実行について：

### GitLab CI パイプライン構成

```yaml
stages:
  - lint
  - test
```

### 実行されるジョブ

| ジョブ名 | ステージ | 内容 | トリガー条件 |
| --- | --- | --- | --- |
| fmt | lint | `cargo fmt --check`によるフォーマットチェック | master/MR |
| cargo-test | lint | `cargo test --locked`による単体テスト | master/MR |
| img | test | 各種イメージ（server, desktop, demo）のビルド検証 | master/MR |

### テスト構成ファイル

テスト専用の構成ファイルが用意されており、完全なテストスイートを含むOSイメージをビルド可能：

- `config/tests.toml`: テスト構成のベース定義
- `config/x86_64/tests.toml`: x86_64アーキテクチャ用テスト構成
- `config/aarch64/tests.toml`: ARM64アーキテクチャ用テスト構成
- `config/i586/tests.toml`: 32bitアーキテクチャ用テスト構成
- `config/riscv64gc/tests.toml`: RISC-Vアーキテクチャ用テスト構成

### テスト専用パッケージ

テスト構成に含まれるパッケージ：
- acid
- resist
- relibc-tests
- os-test
- openposixtestsuite
- redox-posix-tests
- vttest
- benchmarks
- hello-redox

## 備考

### アーキテクチャサポート

Redox OSは複数のアーキテクチャをサポートしており、テストも各アーキテクチャで実行されます：
- x86_64（主要ターゲット）
- i586（32bit x86）
- aarch64（ARM64、Raspberry Pi 3B+含む）
- riscv64gc（RISC-V 64bit）

### Podmanによるビルド分離

CI/CDではPodmanコンテナを使用してビルド環境を分離し、再現性のあるテスト実行を実現しています。`PODMAN_BUILD=1`フラグでコンテナ内実行を制御します。

### テスト実行コマンド例

```bash
# ユニットテスト実行
cargo test --locked

# フォーマットチェック
cargo fmt -- --check

# テスト構成でのOSイメージビルド
make CONFIG_NAME=tests all
```

### 関連ドキュメント

- [Redox Book](https://doc.redox-os.org/book/)
- [Build System Documentation](https://doc.redox-os.org/book/build-system-reference.html)
- [Developer FAQ](https://doc.redox-os.org/book/developer-faq.html)
