# ER図

本ドキュメントは、Redox OS Cookbook（ビルドシステム）におけるデータエンティティ間の関係を図示します。

## 全体ER図

```mermaid
erDiagram
    CookbookConfig ||--|| CookConfig : contains
    CookbookConfig ||--o{ Mirror : has

    Recipe ||--o| SourceRecipe : has
    Recipe ||--|| BuildRecipe : contains
    Recipe ||--|| PackageRecipe : contains
    Recipe ||--o{ OptionalPackageRecipe : has

    BuildRecipe ||--o{ PackageName : "dependencies"
    BuildRecipe ||--o{ PackageName : "dev_dependencies"
    PackageRecipe ||--o{ PackageName : "dependencies"
    OptionalPackageRecipe ||--o{ PackageName : "dependencies"

    CookRecipe ||--|| Recipe : wraps
    CookRecipe ||--|| PackageName : identifies

    Package ||--|| PackageName : identifies
    Package ||--o{ PackageName : "depends"

    SourceRecipe ||--|{ GitSource : is_a
    SourceRecipe ||--|{ TarSource : is_a
    SourceRecipe ||--|{ PathSource : is_a
    SourceRecipe ||--|{ SameAsSource : is_a

    BuildRecipe ||--|{ BuildKind : has

    CookbookConfig {
        CookConfig cook
        HashMap mirrors
    }

    CookConfig {
        bool offline
        usize jobs
        bool tui
        bool logs
        bool nonstop
        bool verbose
        bool clean_build
        bool clean_target
    }

    Mirror {
        String original_url PK
        String mirror_url
    }

    Recipe {
        SourceRecipe source
        BuildRecipe build
        PackageRecipe package
        Vec optional_packages
    }

    SourceRecipe {
        String type
    }

    GitSource {
        String git PK
        String upstream
        String branch
        String rev
        bool shallow_clone
        Vec patches
        String script
    }

    TarSource {
        String tar PK
        String blake3
        Vec patches
        String script
    }

    PathSource {
        String path PK
    }

    SameAsSource {
        String same_as PK
    }

    BuildRecipe {
        BuildKind kind
        Vec dependencies
        Vec dev_dependencies
    }

    BuildKind {
        String template PK
        String script
        Vec flags
    }

    PackageRecipe {
        Vec dependencies
        String version
    }

    OptionalPackageRecipe {
        String name PK
        Vec dependencies
        Vec files
    }

    PackageName {
        String name PK
        String suffix
        bool is_host
    }

    CookRecipe {
        PackageName name PK
        PathBuf dir
        Recipe recipe
        String target
        bool is_deps
        String rule
    }

    Package {
        PackageName name PK
        String version
        String target
        String blake3
        u64 network_size
        u64 storage_size
        Vec depends
        String commit_identifier
        String source_identifier
        String time_identifier
    }

    IdentifierConfig {
        String commit_identifier
        String source_identifier
        String time_identifier
    }

    AutoDeps {
        BTreeSet packages
    }
```

## 設定エンティティの関係図

```mermaid
erDiagram
    CookbookConfig ||--|| CookConfig : "cook"
    CookbookConfig ||--o{ Mirror : "mirrors"

    CookbookConfig {
        CookConfig cook "ビルド設定"
        HashMap mirrors "ミラーマップ"
    }

    CookConfig {
        bool offline "オフラインモード"
        usize jobs "並列ジョブ数"
        bool tui "TUI有効"
        bool logs "ログ出力"
        bool nonstop "エラー継続"
        bool verbose "詳細ログ"
        bool clean_build "ビルド前クリーン"
        bool clean_target "ビルド後クリーン"
    }

    Mirror {
        String original_url PK "元のURL"
        String mirror_url "ミラーURL"
    }
```

## レシピエンティティの関係図

```mermaid
erDiagram
    Recipe ||--o| SourceRecipe : "source (optional)"
    Recipe ||--|| BuildRecipe : "build"
    Recipe ||--|| PackageRecipe : "package"
    Recipe ||--o{ OptionalPackageRecipe : "optional_packages"

    BuildRecipe ||--|| BuildKind : "kind"
    BuildRecipe }o--o{ PackageName : "dependencies"
    BuildRecipe }o--o{ PackageName : "dev_dependencies"

    PackageRecipe }o--o{ PackageName : "dependencies"

    OptionalPackageRecipe }o--o{ PackageName : "dependencies"

    Recipe {
        SourceRecipe source "ソース設定"
        BuildRecipe build "ビルド設定"
        PackageRecipe package "パッケージ設定"
        Vec optional_packages "オプションパッケージ"
    }

    SourceRecipe {
        String variant "Git/Tar/Path/SameAs"
    }

    BuildRecipe {
        BuildKind kind "ビルドテンプレート"
        Vec dependencies "ビルド依存"
        Vec dev_dependencies "開発依存"
    }

    BuildKind {
        String template "none/remote/cargo/configure/cmake/meson/custom"
    }

    PackageRecipe {
        Vec dependencies "ランタイム依存"
        String version "バージョン"
    }

    OptionalPackageRecipe {
        String name PK "名前"
        Vec dependencies "依存"
        Vec files "ファイルパターン"
    }

    PackageName {
        String name PK "パッケージ名"
        String suffix "サフィックス"
        bool is_host "ホスト用か"
    }
```

## ソースタイプの継承関係図

```mermaid
erDiagram
    SourceRecipe ||--|{ GitSource : "variant"
    SourceRecipe ||--|{ TarSource : "variant"
    SourceRecipe ||--|{ PathSource : "variant"
    SourceRecipe ||--|{ SameAsSource : "variant"

    SourceRecipe {
        String type "タイプ識別子"
    }

    GitSource {
        String git PK "GitリポジトリURL"
        String upstream "アップストリームURL"
        String branch "ブランチ名"
        String rev "リビジョン"
        bool shallow_clone "シャロークローン"
        Vec patches "パッチリスト"
        String script "準備スクリプト"
    }

    TarSource {
        String tar PK "tarファイルURL"
        String blake3 "BLAKE3ハッシュ"
        Vec patches "パッチリスト"
        String script "準備スクリプト"
    }

    PathSource {
        String path PK "ローカルパス"
    }

    SameAsSource {
        String same_as PK "共有元パッケージ"
    }
```

## ビルドテンプレートの種類

```mermaid
erDiagram
    BuildKind ||--|{ NoneTemplate : "variant"
    BuildKind ||--|{ RemoteTemplate : "variant"
    BuildKind ||--|{ CargoTemplate : "variant"
    BuildKind ||--|{ ConfigureTemplate : "variant"
    BuildKind ||--|{ CmakeTemplate : "variant"
    BuildKind ||--|{ MesonTemplate : "variant"
    BuildKind ||--|{ CustomTemplate : "variant"

    BuildKind {
        String template "テンプレート種別"
    }

    NoneTemplate {
        String template "none - ビルドなし"
    }

    RemoteTemplate {
        String template "remote - リモート取得"
    }

    CargoTemplate {
        String template "cargo"
        String package_path "パッケージパス"
        String cargoflags "Cargoフラグ"
    }

    ConfigureTemplate {
        String template "configure"
        Vec configureflags "configureフラグ"
    }

    CmakeTemplate {
        String template "cmake"
        Vec cmakeflags "CMakeフラグ"
    }

    MesonTemplate {
        String template "meson"
        Vec mesonflags "Mesonフラグ"
    }

    CustomTemplate {
        String template "custom"
        String script "カスタムスクリプト"
    }
```

## ビルド時データフロー図

```mermaid
erDiagram
    CookRecipe ||--|| Recipe : "contains"
    CookRecipe ||--|| PackageName : "name"
    CookRecipe ||--|| Package : "generates"

    Package ||--|| IdentifierConfig : "contains"
    Package }o--o{ PackageName : "depends"

    AutoDeps }o--o{ PackageName : "packages"

    CookRecipe {
        PackageName name PK "パッケージ名"
        PathBuf dir "ディレクトリ"
        Recipe recipe "レシピ"
        String target "ターゲット"
        bool is_deps "依存として追加"
        String rule "ビルドルール"
    }

    Package {
        PackageName name PK "パッケージ名"
        String version "バージョン"
        String target "ターゲット"
        String blake3 "BLAKE3ハッシュ"
        u64 network_size "ネットワークサイズ"
        u64 storage_size "ストレージサイズ"
        Vec depends "依存"
        String commit_identifier "コミット識別子"
        String source_identifier "ソース識別子"
        String time_identifier "時間識別子"
    }

    IdentifierConfig {
        String commit_identifier "コミット識別子"
        String source_identifier "ソース識別子"
        String time_identifier "時間識別子"
    }

    AutoDeps {
        BTreeSet packages "自動検出依存"
    }

    PackageName {
        String name PK "パッケージ名"
    }

    Recipe {
        SourceRecipe source "ソース"
        BuildRecipe build "ビルド"
        PackageRecipe package "パッケージ"
    }
```

## ファイルとエンティティのマッピング

```mermaid
flowchart TD
    subgraph Files["ファイル"]
        F1[cookbook.toml]
        F2[recipe.toml]
        F3[stage.toml]
        F4[stage.pkgar]
        F5[id_ed25519.toml]
        F6[id_ed25519.pub.toml]
    end

    subgraph Entities["エンティティ"]
        E1[CookbookConfig]
        E2[Recipe]
        E3[Package]
        E4[pkgarアーカイブ]
        E5[秘密鍵]
        E6[公開鍵]
    end

    F1 --> E1
    F2 --> E2
    F3 --> E3
    F4 --> E4
    F5 --> E5
    F6 --> E6

    E2 -->|ビルド実行| E3
    E5 -->|署名| E4
    E6 -->|検証| E4
```

## 依存関係の種類

```mermaid
graph LR
    subgraph "依存関係の種類"
        BD[Build Dependencies<br/>ビルド依存]
        DD[Dev Dependencies<br/>開発依存]
        PD[Package Dependencies<br/>ランタイム依存]
        AD[Auto Dependencies<br/>自動検出依存]
    end

    subgraph "使用タイミング"
        BT[ビルド時]
        RT[実行時]
    end

    BD --> BT
    DD --> BT
    PD --> RT
    AD --> RT

    style BD fill:#f9f,stroke:#333
    style DD fill:#f9f,stroke:#333
    style PD fill:#9ff,stroke:#333
    style AD fill:#9ff,stroke:#333
```
