---
generated_at: 2026-01-22 22:50:00
metrics:
  claims_total: 21
  claims_with_evidence: 21
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：21 / 21、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build.sh`（106行）
- E-02: `native_bootstrap.sh`（1135行）
- E-03: `podman_bootstrap.sh`（664行）
- E-04: `podman/rustinstall.sh`（22行）
- E-05: `scripts/changelog.sh`（81行）
- E-06: `scripts/executables.sh`（61行）
- E-07: `scripts/mount-redoxfs.sh`（119行）
- E-08: `scripts/cargo-update.sh`（10行）
- E-09: `scripts/backtrace.sh`（78行）
- E-10: `scripts/dual-boot.sh`（61行）
- E-11: `scripts/category.sh`（15行）
- E-12: `scripts/check-ci-config.sh`（37行）
- E-13: `scripts/commit-hash.sh`（16行）
- E-14: `scripts/find-recipe.sh`（45行）
- E-15: `scripts/include-recipes.sh`（27行）
- E-16: `scripts/pkg-size.sh`（30行）
- E-17: `scripts/show-package.sh`（27行）
- E-18: `scripts/ventoy.sh`（36行）
- E-19: `scripts/recipe-match.sh`（6行）
- E-20: `scripts/recipe-path.sh`（9行）
- E-21: `scripts/print-recipe.sh`（6行）
- E-22: `.gitlab-ci.yml`（64行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build.sh：指定されたアーキテクチャと構成でシステムをビルドするmakeコマンドを実行 | E-01（usage関数、make $@呼び出し） | ○ |
| C-02 | native_bootstrap.sh：ネイティブ環境でのRedoxビルドシステムをセットアップ | E-02（rustInstall、各OSインストール関数、boot関数） | ○ |
| C-03 | podman_bootstrap.sh：Podman環境でのRedoxビルドシステムをセットアップ | E-03（banner、OS検出、boot関数でPODMAN_BUILD=1設定） | ○ |
| C-04 | podman/rustinstall.sh：Podmanコンテナ内でRustツールチェーンとビルド依存ツールをインストール | E-04（rustup、sccache、just、cbindgenのインストール） | ○ |
| C-05 | scripts/changelog.sh：全Redoxコンポーネントの変更履歴を表示 | E-05（git describe、git log、リポジトリ比較） | ○ |
| C-06 | scripts/executables.sh：レシピの実行ファイル名を一覧表示し重複を検出 | E-06（find、uniq -D、duplicates検出） | ○ |
| C-07 | scripts/mount-redoxfs.sh：RedoxFSパーティションをマウント/アンマウント | E-07（fusermount、redoxfs、マウントポイント管理） | ○ |
| C-08 | scripts/cargo-update.sh：指定されたレシピのCargoパッケージを更新 | E-08（make f.recipe、cargo update） | ○ |
| C-09 | scripts/backtrace.sh：Redoxからコピーしたバックトレースのシンボルを解決 | E-09（addr2line、--demangle=rust） | ○ |
| C-10 | scripts/dual-boot.sh：Redoxをストレージデバイスにインストールし、ブートエントリを追加 | E-10（popsicle、bootctl、systemd-boot設定） | ○ |
| C-11 | scripts/category.sh：指定されたCookbookカテゴリに対してレシピコマンドを実行 | E-11（make action.--category-name） | ○ |
| C-12 | scripts/check-ci-config.sh：CI構成ファイル内の不足パッケージをチェック | E-12（list_recipes、redox_installer --list-packages比較） | ○ |
| C-13 | scripts/commit-hash.sh：レシピソースの現在のGitブランチとコミットハッシュを表示 | E-13（find_recipe、git branch -v） | ○ |
| C-14 | scripts/find-recipe.sh：レシピ名からレシピディレクトリを検索 | E-14（find、mount/unmount、ファイルパス検索） | ○ |
| C-15 | scripts/include-recipes.sh：指定パターンにマッチするレシピをファイルシステム構成形式で出力 | E-15（grep -rl、recipe.toml検索） | ○ |
| C-16 | scripts/pkg-size.sh：レシピのパッケージサイズを表示 | E-16（find stage.pkgar/stage.tar.gz、ls -hs） | ○ |
| C-17 | scripts/show-package.sh：レシピのstageとsysrootフォルダの内容を表示 | E-17（find_recipe、ls -1 stage,sysroot） | ○ |
| C-18 | scripts/ventoy.sh：Redoxブータブルイメージを作成しVentoyフォーマットデバイスにコピー | E-18（make redox-live.iso、cp to /media/Ventoy） | ○ |
| C-19 | scripts/recipe-match.sh：指定テキストを含むレシピ構成ファイルを表示 | E-19（rg、bat） | ○ |
| C-20 | scripts/recipe-path.sh：レシピ名からレシピパスを出力 | E-20（find recipes -maxdepth 4） | ○ |
| C-21 | scripts/print-recipe.sh：レシピの構成ファイルを表示 | E-21（cat recipe.*） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対してソースコードによる根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのバッチスクリプトについてソースコードを直接確認し、機能を正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] CSVの各バッチ名が実際のファイルパスと一致しているか確認
- [ ] カテゴリ分類が適切か（ビルド/セットアップ/ユーティリティ/デバッグ/インストール）確認
- [ ] 説明文がスクリプトの主要機能を正確に反映しているか確認
- [ ] 備考欄の補足情報が有用であるか確認
