# バッチ設計書 1-build.sh

## 概要

本ドキュメントは、Redoxビルドシステムにおけるbuild.shスクリプトの設計仕様を定義するものです。build.shは、指定されたプロセッサアーキテクチャとファイルシステム構成でmakeコマンドを実行するためのラッパースクリプトです。

### 本バッチの処理概要

build.shは、Redox OSのビルドプロセスを簡素化するためのシェルスクリプトです。複数のアーキテクチャ（x86_64、aarch64、i586、riscv64gc）に対応し、設定ファイルに基づいてシステムイメージを生成します。

**業務上の目的・背景**：Redox OSは複数のCPUアーキテクチャをサポートしており、各アーキテクチャごとに異なるビルド設定が必要です。開発者がmk/config.mkを直接編集せずに、コマンドラインオプションで柔軟にビルドパラメータを変更できるようにすることで、開発効率を向上させます。また、複数の構成（desktop、server、demoなど）を簡単に切り替えられるため、異なるユースケースに対応したイメージを効率的に生成できます。

**バッチの実行タイミング**：手動実行。開発者がRedoxのビルドを実行する際に随時使用します。CI/CDパイプラインでの自動ビルド時にも利用可能です。

**主要な処理内容**：
1. コマンドライン引数の解析（アーキテクチャ、設定名、ファイルシステム構成ファイル）
2. 未指定パラメータへのデフォルト値適用（ARCH=x86_64、CONFIG_NAME=desktop）
3. ファイルシステム構成ファイルパスの推論と設定
4. 環境変数のエクスポート（ARCH、CONFIG_NAME、FILESYSTEM_CONFIG）
5. makeコマンドの実行とターゲットビルドの開始

**前後の処理との関連**：このバッチを実行する前に、native_bootstrap.shまたはpodman_bootstrap.shによる環境構築が完了している必要があります。ビルド完了後は、生成されたイメージ（build/ARCH/CONFIG/harddrive.img等）をQEMUやVirtualBoxで実行できます。

**影響範囲**：buildディレクトリ配下にアーキテクチャおよび構成別のビルド成果物が生成されます。既存のビルド成果物は上書きされる可能性があります。

## バッチ種別

ビルド処理 / システムイメージ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Rustツールチェーン | rustupおよびRustコンパイラがインストール済みであること |
| ビルド依存パッケージ | native_bootstrap.shまたはpodman_bootstrap.shで依存パッケージがインストール済みであること |
| 設定ファイル | 指定されたFILESYSTEM_CONFIGファイルが存在すること |

### 実行可否判定

- 指定されたアーキテクチャがサポート対象（x86_64、aarch64、riscv64gc、i586）であること
- 設定ファイル（config/ARCH/CONFIG_NAME.toml）が存在すること
- Makefileが正しく構成されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -X | フラグ | No | - | x86_64アーキテクチャを指定 |
| -A | フラグ | No | - | aarch64アーキテクチャを指定 |
| -5 | フラグ | No | - | i586アーキテクチャを指定 |
| -R | フラグ | No | - | riscv64gcアーキテクチャを指定 |
| -a ARCH | 文字列 | No | x86_64 | プロセッサアーキテクチャを直接指定 |
| -c CONFIG | 文字列 | No | desktop | 設定名（desktop/server/demo等） |
| -f FILESYSTEM_CONFIG | 文字列 | No | config/ARCH/CONFIG.toml | ファイルシステム設定ファイルパス |
| TARGET... | 文字列 | Yes | - | makeターゲット（all、qemu、live等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| config/ARCH/CONFIG.toml | TOML | ファイルシステム構成ファイル |
| mk/config.mk | Makefile | ビルドシステム設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/ARCH/CONFIG/harddrive.img | バイナリ | ハードディスクイメージ |
| build/ARCH/CONFIG/redox-live.iso | バイナリ | ライブISOイメージ（liveターゲット時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | harddrive.img / redox-live.iso |
| 出力先 | build/ARCH/CONFIG/ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. ヘルプオプションチェック
   └─ -hまたは--helpが指定された場合、usage()を表示して終了

2. コマンドラインオプション解析
   └─ getoptsを使用して-a, -c, -f, -X, -A, -5, -6, -R, -hオプションを解析

3. アーキテクチャ推論
   └─ ARCHが未指定でFILESYSTEM_CONFIGが指定されている場合、
      ディレクトリ名からアーキテクチャを推論

4. 設定名推論
   └─ CONFIG_NAMEが未指定でFILESYSTEM_CONFIGが指定されている場合、
      ファイル名から設定名を推論

5. デフォルト値適用
   └─ ARCH未指定時はx86_64、CONFIG_NAME未指定時はdesktop

6. ファイルシステム構成ファイルパス生成
   └─ FILESYSTEM_CONFIG未指定時はconfig/ARCH/CONFIG_NAME.tomlを設定

7. 環境変数エクスポート
   └─ ARCH、CONFIG_NAME、FILESYSTEM_CONFIGをエクスポート

8. makeコマンド実行
   └─ 残りの引数をmakeに渡して実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ヘルプ要求?}
    B -->|Yes| C[usage表示]
    C --> D[終了]
    B -->|No| E[オプション解析]
    E --> F{ARCH指定あり?}
    F -->|No| G[FILESYSTEM_CONFIGからARCH推論]
    F -->|Yes| H[指定ARCHを使用]
    G --> I{CONFIG_NAME指定あり?}
    H --> I
    I -->|No| J[FILESYSTEM_CONFIGからCONFIG_NAME推論]
    I -->|Yes| K[指定CONFIG_NAMEを使用]
    J --> L[デフォルト値適用]
    K --> L
    L --> M[FILESYSTEM_CONFIGパス生成]
    M --> N[環境変数エクスポート]
    N --> O[make実行]
    O --> P[バッチ終了]
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | オプションエラー | 不明なオプションが指定された場合 | "Unknown option"メッセージを表示して終了 |
| - | 値エラー | オプションに値が必要なのに指定されていない場合 | "-OPTARG requires a value"メッセージを表示して終了 |
| - | アーキテクチャエラー | サポート外のアーキテクチャが検出された場合 | エラーメッセージを表示（ただしARCHは空のまま） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- オプション解析エラー時：正しいオプション形式で再実行
- ビルドエラー時：makeコマンドのエラーログを確認し、依存関係や設定ファイルを修正後に再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド実行 |
| 目標処理時間 | ビルド対象により異なる（数分〜数時間） |
| メモリ使用量上限 | システムリソースに依存 |

## 排他制御

同一ビルドディレクトリへの同時書き込みを避けるため、同じARCH/CONFIGの組み合わせでの並行実行は推奨されません。異なるアーキテクチャや構成であれば並行実行可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | make開始時 | makeの実行開始メッセージ |
| 進捗ログ | ビルド中 | makeによるコンパイル進捗 |
| 終了ログ | make終了時 | makeの完了ステータス |
| エラーログ | エラー発生時 | コンパイルエラーやリンクエラーの詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ビルド対象により異なる | 標準出力 |
| ディスク使用量 | ビルド成果物サイズ | 標準エラー出力 |

## 備考

- -6オプションは非推奨です。代わりに-5オプションを使用してください
- アーキテクチャは検証なしで受け入れられるため、新しいアーキテクチャを追加することも可能です
- 頻繁にARCHやCONFIGを変更しない場合は、mk/config.mkを直接編集することを推奨します
